/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef __FLTK_MAINWINDOW_H__
#define __FLTK_MAINWINDOW_H__

#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_Button.H>

class Document;
class LCD_window;


class MainWindow : public Fl_Window
{
public:
	// -----------------------------------------------------------------------------
	// constructor / destructor
	// -----------------------------------------------------------------------------

	MainWindow();

	// -----------------------------------------------------------------------------
	// public methods
	// -----------------------------------------------------------------------------

	void popupMenu() { (void) _menuButton->popup(); }

	Document* getDocument() { return _doc; }

	static MainWindow* getMainWindow() { return _sMainWindow; };

private:
public:

	// -----------------------------------------------------------------------------
	// private methods
	// -----------------------------------------------------------------------------

	void doLoadApplication();
	void doExportDatabase();
	void doEmulatorStart();
	Bool doEmulatorStop();
	void doQuit();
	void doSaveMemoryAs();
	void doSaveScreen();
	void doOpenMemory();

	void doEditLoggingPreferences();
	void doEditDebugPreferences();
	void doEditSkins();
	void doEditPreferences();

	friend void menuCallback( Fl_Menu_ *w, void *data );
	friend void docChangedCallback( int property, void *param );

	// -----------------------------------------------------------------------------
	// private data members
	// -----------------------------------------------------------------------------

	Fl_Menu_Button *_menuButton;
	LCD_window *_lcd;

	Document *_doc;

	static MainWindow* _sMainWindow;
};

#endif /* __FLTK_MAINWINDOW_H__ */
