/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef __QUANTIZER_H__
#define __QUANTIZER_H__

struct NODE;

class CQuantizer
{
	public:
								CQuantizer			(uae_u32 nMaxColors, uae_u32 nColorBits);
		virtual					~CQuantizer			(void);
	
		Bool					ProcessImage		(/*HANDLE hImage*/ LPBITMAPINFO bm, void* bits);

		uae_u32					GetColorCount		(void);
		void					GetColorTable		(RGBQUAD* prgb);

	protected:
		int						GetLeftShiftCount	(uae_u32 dwVal);
		int						GetRightShiftCount	(uae_u32 dwVal);
		void					AddColor			(NODE** ppNode, uae_u8 r, uae_u8 g, uae_u8 b,
													 uae_u32 nColorBits, uae_u32 nLevel,
													 uae_u32* pLeafCount, NODE** pReducibleNodes);
		NODE*					CreateNode			(uae_u32 nLevel, uae_u32 nColorBits,
													 uae_u32* pLeafCount, NODE** pReducibleNodes);
		void					ReduceTree			(uae_u32 nColorBits,
													 uae_u32* pLeafCount, NODE** pReducibleNodes);
		void					DeleteTree			(NODE** ppNode);
		void					GetPaletteColors	(NODE* pTree, RGBQUAD* prgb, uae_u32* pIndex);

	protected:
		NODE*					m_pTree;
		uae_u32					m_nLeafCount;
		NODE*					m_pReducibleNodes[9];
		uae_u32					m_nMaxColors;
		uae_u32					m_nColorBits;
};

#endif	// __QUANTIZER_H__
