/*******************************************************************
 * 							 Pilot Software
 *
 *	Copyright (c) 1994-1999, Palm Computing Inc., All Rights Reserved
 *
 *-------------------------------------------------------------------
 * FileName:
 *		Common.h
 *
 * Description:
 *		Common header file for all Pilot routines.
 *		Contains elementary data types
 *
 * History:
 *   	10/19/94 RM		Created by Ron Marianetti  
 *   	04/24/97 SCL	Changes for PalmOS 2.0 SDK
 *		08/21/98	SCL	Merged WChar & WCharPtr typedefs from Sumo.
 *		08/21/98	SCL	Merged (changed) ConstCharPtr typedef from Sumo
 *		02/02/99	kwk	Cleanup of ConstXXX types.
 *
 *******************************************************************/


#ifndef __COMMON_H__
#define __COMMON_H__


/************************************************************
 * Build Rules
 *************************************************************/
#include <BuildRules.h>


/************************************************************
 * Metrowerks will substitute strlen and strcpy with inline
 * 68K assembly code.  Prevent this.
 *************************************************************/
 
#ifdef __MC68K__
#define _NO_FAST_STRING_INLINES_ 0
#endif


/************************************************************
 * Define whether or not we are direct linking, or going through
 *  traps.
 *
 * When eumulating we use directy linking.
 * When running under native mode, we use traps EXCEPT for the
 *   modules that actually install the routines into the trap table. 
 *   These modules will set the DIRECT_LINK define to 1
 *************************************************************/
#ifndef EMULATION_LEVEL
#error "This should not happen!"
#endif

#ifndef USE_TRAPS 
	#if EMULATION_LEVEL == EMULATION_NONE
		#define	USE_TRAPS 1						// use Pilot traps
	#else
		#define	USE_TRAPS 0						// direct link (Simulator)
	#endif
#endif

#if USE_TRAPS == 0

#define ONEWORD_INLINE(trapNum)
#define TWOWORD_INLINE(w1, w2)
#define THREEWORD_INLINE(w1, w2, w3)
#define FOURWORD_INLINE(w1, w2, w3, w4)
#define FIVEWORD_INLINE(w1, w2, w3, w4, w5)
#define SIXWORD_INLINE(w1, w2, w3, w4, w5, w6)
#define SEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7)
#define EIGHTWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8)
#define NINEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9)
#define TENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10)
#define ELEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11)
#define TWELVEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12)

#else

// Define the traps differently depending on the compiler

#ifdef __GNUC__
#define ASMWORD(W) asm("dc.w %c0"::"i"(W));
#define ONEWORD_INLINE(trapNum) 	\
	{ASMWORD(trapNum)}
#define TWOWORD_INLINE(w1, w2) 	\
	{ASMWORD(w1)ASMWORD(w2)}
#define THREEWORD_INLINE(w1, w2, w3)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)}
#define FOURWORD_INLINE(w1, w2, w3, w4)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)}
#define FIVEWORD_INLINE(w1, w2, w3, w4, w5)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)}
#define SIXWORD_INLINE(w1, w2, w3, w4, w5, w6)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)}
#define SEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)}
#define EIGHTWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)ASMWORD(w8)}
#define NINEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)ASMWORD(w8)ASMWORD(w9)}
#define TENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)ASMWORD(w8)ASMWORD(w9)ASMWORD(w10)}
#define ELEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)ASMWORD(w8)ASMWORD(w9)ASMWORD(w10)ASMWORD(w11)}
#define TWELVEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12)  \
	{ASMWORD(w1)ASMWORD(w2)ASMWORD(w3)ASMWORD(w4)ASMWORD(w5)ASMWORD(w6)ASMWORD(w7)ASMWORD(w8)ASMWORD(w9)ASMWORD(w10)ASMWORD(w11)ASMWORD(w12)}

#else

// Define the traps for Metrowerks IDE or MPW 68K compiler

#define ONEWORD_INLINE(trapNum) 	\
	= trapNum
#define TWOWORD_INLINE(w1, w2) 	\
	= {w1,w2}
#define THREEWORD_INLINE(w1, w2, w3)  \
	= {w1,w2,w3}
#define FOURWORD_INLINE(w1, w2, w3, w4)  \
	= {w1,w2,w3,w4}
#define FIVEWORD_INLINE(w1, w2, w3, w4, w5)  \
	= {w1,w2,w3,w4,w5}
#define SIXWORD_INLINE(w1, w2, w3, w4, w5, w6)  \
	= {w1,w2,w3,w4,w5,w6}
#define SEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7)  \
	= {w1,w2,w3,w4,w5,w6,w7}
#define EIGHTWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8)  \
	= {w1,w2,w3,w4,w5,w6,w7,w8}
#define NINEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9)  \
	= {w1,w2,w3,w4,w5,w6,w7,w8,w9}
#define TENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10)  \
	= {w1,w2,w3,w4,w5,w6,w7,w8,w9,w10}
#define ELEVENWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11)  \
	= {w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11}
#define TWELVEWORD_INLINE(w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12)  \
	= {w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12}

#endif

#endif


/********************************************************************
 * Elementary data types
 ********************************************************************/
// Determine if we need to define our basic types or not
#ifndef	__TYPES__					// (Already defined in CW11)
#ifndef	__MACTYPES__				// (Already defined in CWPro3)
#define	__DEFINE_TYPES_	1
#endif
#endif


// Fixed size data types
typedef signed char		SByte;		// 8 bits
#if __DEFINE_TYPES_						
typedef unsigned char 	Byte;
typedef unsigned short  UInt16;
typedef unsigned long   UInt32;
#endif

typedef signed short		SWord;		// 16 bits
typedef signed short		Int16;
typedef unsigned short 	Word;			

typedef signed long		SDWord;		// 32 bits
typedef signed long		Int32;
typedef unsigned long	DWord;		


// Logical data types
#if __DEFINE_TYPES_						 
typedef unsigned char	Boolean;
#endif

typedef char				Char;
typedef signed char		SChar;
typedef unsigned char	UChar;
typedef unsigned short	WChar;		// 'wide' int'l character type.

typedef signed short		Short;		// >= Byte
typedef unsigned short	UShort;

typedef signed short		Int;			// >= Word (use short so MPW and CW agree)
typedef unsigned short	UInt;			   

typedef signed long		Long;			// >= DWord
typedef unsigned long	ULong;

typedef signed short		Err;

typedef DWord				LocalID;		// local (card relative) chunk ID



/************************************************************
 * Pointer Types
 *************************************************************/ 
typedef void*				VoidPtr;
typedef void const *		ConstVoidPtr;
typedef VoidPtr*			VoidHand;
typedef ConstVoidPtr*	ConstVoidHand;


// Fixed size data types
typedef SByte*				SBytePtr;
typedef SByte const *	ConstSBytePtr;
#if __DEFINE_TYPES_						 
typedef Byte*				BytePtr;
typedef Byte const *		ConstBytePtr;
#endif

typedef SWord*				SWordPtr;
typedef Word*				WordPtr;
typedef unsigned short* UInt16Ptr;
typedef SWord const *	ConstSWordPtr;
typedef Word const *		ConstWordPtr;
typedef unsigned short const * ConstUInt16Ptr;

typedef SDWord*			SDWordPtr;
typedef DWord*				DWordPtr;
typedef SDWord const *	ConstSDWordPtr;
typedef DWord const *	ConstDWordPtr;


// Logical data types
typedef Boolean*			BooleanPtr;
typedef Boolean const *	ConstBooleanPtr;

typedef Char*				CharPtr;
typedef SChar*				SCharPtr;
typedef UChar*				UCharPtr;
typedef Char const *		ConstCharPtr;
typedef SChar const *	ConstSCharPtr;
typedef UChar const*		ConstUCharPtr;

typedef WChar*				WCharPtr;
typedef WChar const *	ConstWCharPtr;

typedef Short*				ShortPtr;
typedef UShort*			UShortPtr;
typedef Short const *	ConstShortPtr;
typedef UShort const *	ConstUShortPtr;

typedef Int*				IntPtr;
typedef UInt*				UIntPtr;
typedef Int const *		ConstIntPtr;
typedef UInt const *		ConstUIntPtr;

typedef Long*				LongPtr;
typedef ULong*				ULongPtr;
typedef Long const *		ConstLongPtr;
typedef ULong const *	ConstULongPtr;

// Include the following typedefs if types.h wasn't read.
#if __DEFINE_TYPES_						 

// Generic Pointer types used by Memory Manager
// We have to define Ptr as char* because that's what the Mac includes do.
// [TODO kwk - seems like we shouldn't be using these types in the Palm OS
// anywhere, since they have some constraint on being the same as the Mac
// types, and thus if somebody sets char as unsigned via the compiler option,
// they'll get different results]
typedef char*		Ptr;							// global pointer
typedef Ptr*				Handle;				// global handle
typedef char const * ConstPtr;			// global pointer to constant data
typedef ConstPtr*			ConstHandle;		// global handle to constant data

// Function types
typedef Long (*ProcPtr)();

#endif /* __DEFINE_TYPES_ */



/************************************************************
 * Common constants
 *************************************************************/
#ifndef NULL
#define NULL	0
#endif	// NULL

#ifndef bitsInByte
#define bitsInByte	8
#endif	// bitsInByte

// Include the following typedefs if types.h wasn't read.
#if  __DEFINE_TYPES_
	#ifdef __MWERKS__
		#if !__option(bool)
			#ifndef true
				#define true			1
			#endif
			#ifndef false
				#define false			0
			#endif
		#endif
	#else
      #ifndef __cplusplus
		  #ifndef true
				enum {false, true};
		  #endif
	   #endif
	#endif
#endif /* __TYPES__ */



/************************************************************
 * Misc
 *************************************************************/

// Standardized infinite loop notation
// Use in place of while(1), while(true), while(!0), ...
#define loop_forever	for (;;)


#endif //__COMMON_H__
