/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef EMRPC_H_
#define EMRPC_H_

#include "ErrorHandling.h"		// ErrCode
#include "HostControl.h"		// HostSignal

class SLP;
class CSocket;

#define slkSocketRPC			(slkSocketFirstDynamic + 10)
#define sysPktRPC2Cmd			0x70
#define sysPktRPC2Rsp			0xF0

class RPC
{
	public:
		static void 			Startup 			(void);
		static void 			Shutdown			(void);

		static void				Idle				(void);
		static ErrCode			SignalWaiters		(HostSignal);

		static ErrCode			HandleNewPacket 	(SLP&);

		static Bool				HandlingPacket		(void);
		static void				DeferCurrentPacket	(long timeout);

	private:
		static void 			EventCallback		(CSocket* s, int event);
		static void 			CreateNewListener	(void);
};

#endif	// EMRPC_H_

