########################################################################
#
#	File:			SkipStartup.pl
#
#	Purpose:		Skip the Palm V startup application.
#
#	Description:	Run this script to skip past the application that
#					automatically starts when cold-booting a Palm V
#					(or Palm IIIx).  It generates the appropriate
#					pen events to "tap past" the initial forms.
#
########################################################################

use EmRPC;			# EmRPC::OpenConnection, CloseConnection
use EmFunctions;
use EmUtils;		# Wait, TapPen, TapButton

EmRPC::OpenConnection(6415, "localhost");

	Wait();

	TapPen (100, 100);			# Tap past first setup screen
	TapPen (100, 100);			# Tap past second setup screen

	TapPen (10, 10);			# First tap in pen calibration screen
	TapPen (160-10, 160-10);	# Second tap in pen calibration screen
	TapPen (80, 60);			# Confirmation tap in pen calibration screen

	TapButton ("Next");			# Tap Next button
	TapButton ("Done");			# Tap Done button

EmRPC::CloseConnection();
