/* 
 * Apple // emulator for Linux: Opcode tables for debugger
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#include "debug.h"

#ifdef APPLE_IIE

struct opcode_struct opcodes_65c02[256] =
{

  {"BRK", "BRK", 0x00, 0},
  {"ORA", "ORA ($%02X,X)", 0x01, 1},
  {"???", "???", 0x02, 0},
  {"???", "???", 0x03, 0},
  {"TSB", "xTSB $%02X", 0x04, 1},
  {"ORA", "ORA $%02X", 0x05, 1},
  {"ASL", "ASL $%02X", 0x06, 1},
  {"???", "???", 0x07, 0},
  {"PHP", "PHP", 0x08, 0},
  {"ORA", "ORA #$%02X", 0x09, 1},
  {"ASL", "ASL", 0x0A, 0},
  {"???", "???", 0x0B, 0},
  {"TSB", "xTSB $%02X%02X", 0x0C, 2},
  {"ORA", "ORA $%02X%02X", 0x0D, 2},
  {"ASL", "ASL $%02X%02X", 0x0E, 2},
  {"???", "???", 0x0F, 0},
  {"BPL", "BPL $%04X (_$%02X)", 0x10, 3},
  {"ORA", "ORA ($%02X),Y", 0x11, 1},
  {"ORA", "xORA $%02X", 0x12, 1},
  {"???", "???", 0x13, 0},
  {"TRB", "xTRB $%02X", 0x14, 1},
  {"ORA", "ORA $%02X,X", 0x15, 1},
  {"ASL", "ASL $%02X,X", 0x16, 1},
  {"???", "???", 0x17, 0},
  {"CLC", "CLC", 0x18, 0},
  {"ORA", "ORA $%02X%02X,Y", 0x19, 2},
  {"INA", "xINA", 0x1A, 0},
  {"???", "???", 0x1B, 0},
  {"TRB", "xTRB $%02X%02X", 0x1C, 2},
  {"ORA", "ORA $%02X%02X,X", 0x1D, 2},
  {"ASL", "ASL $%02X%02X,X", 0x1E, 2},
  {"???", "???", 0x1F, 0},
  {"JSR", "JSR %02X%02X", 0x20, 2},
  {"AND", "AND ($%02X,X)", 0x21, 1},
  {"???", "???", 0x22, 0},
  {"???", "???", 0x23, 0},
  {"BIT", "BIT $%02X", 0x24, 1},
  {"AND", "AND $%02X", 0x25, 1},
  {"ROL", "ROL $%02X", 0x26, 1},
  {"???", "???", 0x27, 0},
  {"PLP", "PLP", 0x28, 0},
  {"AND", "AND #$%02X", 0x29, 1},
  {"ROL", "ROL", 0x2A, 0},
  {"???", "???", 0x2B, 0},
  {"BIT", "BIT $%02X%02X", 0x2C, 2},
  {"AND", "AND $%02X%02X", 0x2D, 2},
  {"ROL", "ROL $%02X%02X", 0x2E, 2},
  {"???", "???", 0x2F, 0},
  {"BMI", "BMI $%04X (_$%02X)", 0x30, 3},
  {"AND", "AND ($%02X),Y", 0x31, 1},
  {"AND", "xAND ($%02X)", 0x32, 1},
  {"???", "???", 0x33, 0},
  {"BIT", "xBIT $%02X,X", 0x34, 1},
  {"AND", "AND $%02X,X", 0x35, 1},
  {"ROL", "ROL $%02X,X", 0x36, 1},
  {"???", "???", 0x37, 0},
  {"SEC", "SEC", 0x38, 0},
  {"AND", "AND $%02X%02X,Y", 0x39, 2},
  {"DEA", "xDEA", 0x3A, 0},
  {"???", "???", 0x3B, 0},
  {"BIT", "xBIT $%02X%02X,X", 0x3C, 2},
  {"AND", "AND $%02X%02X,X", 0x3D, 2},
  {"ROL", "ROL $%02X%02X,X", 0x3E, 2},
  {"???", "???", 0x3F, 0},
  {"RTI", "RTI", 0x40, 0},
  {"EOR", "EOR ($%02X,X)", 0x41, 1},
  {"???", "???", 0x42, 0},
  {"???", "???", 0x43, 0},
  {"???", "???", 0x44, 0},
  {"EOR", "EOR $%02X", 0x45, 1},
  {"LSR", "LSR $%02X", 0x46, 1},
  {"???", "???", 0x47, 0},
  {"PHA", "PHA", 0x48, 0},
  {"EOR", "EOR #$%02X", 0x49, 1},
  {"LSR", "LSR", 0x4A, 0},
  {"???", "???", 0x4B, 0},
  {"JMP", "JMP %02X%02X", 0x4C, 2},
  {"EOR", "EOR %02X%02X", 0x4D, 2},
  {"LSR", "LSR %02X%02X", 0x4E, 2},
  {"???", "???", 0x4F, 0},
  {"BVC", "BVC $%04X (_$%02X)", 0x50, 3},
  {"EOR", "EOR ($%02X),Y", 0x51, 1},
  {"EOR", "xEOR ($%02X)", 0x52, 1},
  {"???", "???", 0x53, 0},
  {"???", "???", 0x54, 0},
  {"EOR", "EOR $%02X,X", 0x55, 1},
  {"LSR", "LSR $%02X,X", 0x56, 1},
  {"???", "???", 0x57, 0},
  {"CLI", "CLI", 0x58, 0},
  {"EOR", "EOR $%02X%02X,Y", 0x59, 2},
  {"PHY", "xPHY", 0x5A, 0},
  {"???", "???", 0x5B, 0},
  {"???", "???", 0x5C, 0},
  {"EOR", "EOR $%02X%02X,X", 0x5D, 2},
  {"LSR", "LSR $%02X%02X,X", 0x5E, 2},
  {"???", "???", 0x5F, 0},
  {"RTS", "RTS", 0x60, 0},
  {"ADC", "ADC ($%02X,X)", 0x61, 1},
  {"???", "???", 0x62, 0},
  {"???", "???", 0x63, 0},
  {"STZ", "xSTZ $%02X", 0x64, 1},
  {"ADC", "ADC $%02X", 0x65, 1},
  {"ROR", "ROR $%02X", 0x66, 1},
  {"???", "???", 0x67, 0},
  {"PLA", "PLA", 0x68, 0},
  {"ADC", "ADC #$%02X", 0x69, 1},
  {"ROR", "ROR", 0x6A, 0},
  {"???", "???", 0x6B, 0},
  {"JMP", "JMP ($%02X%02X)", 0x6C, 2},
  {"ADC", "ADC $%02X%02X", 0x6D, 2},
  {"ROR", "ROR $%02X%02X", 0x6E, 2},
  {"???", "???", 0x6F, 0},
  {"BVS", "BVS $%04X (_$%02X)", 0x70, 3},
  {"ADC", "ADC ($%02X),Y", 0x71, 1},
  {"ADC", "xADC ($%02X)", 0x72, 1},
  {"???", "???", 0x73, 0},
  {"STZ", "xSTZ $02X,X", 0x74, 1},
  {"ADC", "ADC $%02X,X", 0x75, 1},
  {"ROR", "ROR $%02X,X", 0x76, 1},
  {"???", "???", 0x77, 0},
  {"SEI", "SEI", 0x78, 0},
  {"ADC", "ADC $%02X%02X,Y", 0x79, 2},
  {"PLY", "xPLY", 0x7A, 0},
  {"???", "???", 0x7B, 0},
  {"JMP", "xJMP ($%02X%02X),X", 0x7C, 2},
  {"ADC", "ADC $%02X%02X,X", 0x7D, 2},
  {"ROR", "ROR $%02X%02X,X", 0x7E, 2},
  {"???", "???", 0x7F, 0},
  {"BRA", "xBRA $%04X (_$%02X)", 0x80, 3},
  {"STA", "STA ($%02X,X)", 0x81, 1},
  {"???", "???", 0x82, 0},
  {"???", "???", 0x83, 0},
  {"STY", "STY $%02X", 0x84, 1},
  {"STA", "STA $%02X", 0x85, 1},
  {"STX", "STX $%02X", 0x86, 1},
  {"???", "???", 0x87, 0},
  {"DEY", "DEY", 0x88, 0},
  {"BIT", "xBIT #$%02X", 0x89, 1},
  {"TXA", "TXA", 0x8A, 0},
  {"???", "???", 0x8B, 0},
  {"STY", "STY $%02X%02X", 0x8C, 2},
  {"STA", "STA $%02X%02X", 0x8D, 2},
  {"STX", "STX $%02X%02X", 0x8E, 2},
  {"???", "???", 0x8F, 0},
  {"BCC", "BCC $%04X (_$%02X)", 0x90, 3},
  {"STA", "STA ($%02X),Y", 0x91, 1},
  {"STA", "xSTA ($%02X)", 0x92, 1},
  {"???", "???", 0x93, 0},
  {"STY", "STY $%02X,X", 0x94, 1},
  {"STA", "STA $%02X,X", 0x95, 1},
  {"STX", "STX $%02X,Y", 0x96, 1},
  {"???", "???", 0x97, 0},
  {"TYA", "TYA", 0x98, 0},
  {"STA", "STA $%02X%02X,Y", 0x99, 2},
  {"TXS", "TXS", 0x9A, 0},
  {"???", "???", 0x9B, 0},
  {"STZ", "xSTZ $%02X%02X", 0x9C, 2},
  {"STA", "STA $%02X%02X,X", 0x9D, 2},
  {"STZ", "xSTZ $%02X%02X,X", 0x9E, 2},
  {"???", "???", 0x9F, 0},
  {"LDY", "LDY #$%02X", 0xA0, 1},
  {"LDA", "LDA ($%02X,X)", 0xA1, 1},
  {"LDX", "LDX #$%02X", 0xA2, 1},
  {"???", "???", 0xA3, 0},
  {"LDY", "LDY $%02X", 0xA4, 1},
  {"LDA", "LDA $%02X", 0xA5, 1},
  {"LDX", "LDX $%02X", 0xA6, 1},
  {"???", "???", 0xA7, 0},
  {"TAY", "TAY", 0xA8, 0},
  {"LDA", "LDA #$%02X", 0xA9, 1},
  {"TAX", "TAX", 0xAA, 0},
  {"???", "???", 0xAB, 0},
  {"LDY", "LDY $%02X%02X", 0xAC, 2},
  {"LDA", "LDA $%02X%02X", 0xAD, 2},
  {"LDX", "LDX $%02X%02X", 0xAE, 2},
  {"???", "???", 0xAF, 0},
  {"BCS", "BCS $%04X (_$%02X)", 0xB0, 3},
  {"LDA", "LDA ($%02X),Y", 0xB1, 1},
  {"LDA", "xLDA ($%02X)", 0xB2, 1},
  {"???", "???", 0xB3, 0},
  {"LDY", "LDY $%02X,X", 0xB4, 1},
  {"LDA", "LDA $%02X,X", 0xB5, 1},
  {"LDX", "LDX $%02X,Y", 0xB6, 1},
  {"???", "???", 0xB7, 0},
  {"CLV", "CLV", 0xB8, 0},
  {"LDA", "LDA $%02X%02X,Y", 0xB9, 2},
  {"TSX", "TSX", 0xBA, 0},
  {"???", "???", 0xBB, 0},
  {"LDY", "LDY $%02X%02X,X", 0xBC, 2},
  {"LDA", "LDA $%02X%02X,X", 0xBD, 2},
  {"LDX", "LDX $%02X%02X,Y", 0xBE, 2},
  {"???", "???", 0xBF, 0},
  {"CPY", "CPY #$%02X", 0xC0, 1},
  {"CMP", "CMP ($%02X,X)", 0xC1, 1},
  {"???", "???", 0xC2, 0},
  {"???", "???", 0xC3, 0},
  {"CPY", "CPY $%02X", 0xC4, 1},
  {"CMP", "CMP $%02X", 0xC5, 1},
  {"DEC", "DEC $%02X", 0xC6, 1},
  {"???", "???", 0xC7, 0},
  {"INY", "INY", 0xC8, 0},
  {"CMP", "CMP #$%02X", 0xC9, 1},
  {"DEX", "DEX", 0xCA, 0},
  {"???", "???", 0xCB, 0},
  {"CPY", "CPY $%02X%02X", 0xCC, 2},
  {"CMP", "CMP $%02X%02X", 0xCD, 2},
  {"DEC", "DEC $%02X%02X", 0xCE, 2},
  {"???", "???", 0xCF, 0},
  {"BNE", "BNE $%04X (_$%02X)", 0xD0, 3},
  {"CMP", "CMP ($%02X),Y", 0xD1, 1},
  {"CMP", "xCMP ($%02X)", 0xD2, 1},
  {"???", "???", 0xD3, 0},
  {"???", "???", 0xD4, 0},
  {"CMP", "CMP $%02X,X", 0xD5, 1},
  {"DEC", "DEC $%02X,X", 0xD6, 1},
  {"???", "???", 0xD7, 0},
  {"CLD", "CLD", 0xD8, 0},
  {"CMP", "CMP $%02X%02X,Y", 0xD9, 2},
  {"PHX", "xPHX", 0xDA, 0},
  {"???", "???", 0xDB, 0},
  {"???", "???", 0xDC, 0},
  {"CMP", "CMP $%02X%02X,X", 0xDD, 2},
  {"DEC", "DEC $%02X%02X,X", 0xDE, 2},
  {"???", "???", 0xDF, 0},
  {"CPX", "CPX #$%02X", 0xE0, 1},
  {"SBC", "SBC ($%02X,X)", 0xE1, 0},
  {"???", "???", 0xE2, 0},
  {"???", "???", 0xE3, 0},
  {"CPX", "CPX $%02X", 0xE4, 1},
  {"SBC", "SBC $%02X", 0xE5, 1},
  {"INC", "INC $%02X", 0xE6, 1},
  {"???", "???", 0xE7, 0},
  {"INX", "INX", 0xE8, 0},
  {"SBC", "SBC #$%02X", 0xE9, 1},
  {"NOP", "NOP", 0xEA, 0},
  {"???", "???", 0xEB, 0},
  {"CPX", "CPX $%02X%02X", 0xEC, 2},
  {"SBC", "SBC $%02X%02X", 0xED, 2},
  {"INC", "INC $%02X%02X", 0xEE, 2},
  {"???", "???", 0xEF, 0},
  {"BEQ", "BEQ $%04X (_$%02X)", 0xF0, 3},
  {"SBC", "SBC ($%02X),Y", 0xF1, 1},
  {"SBC", "xSBC ($%02X)", 0xF2, 1},
  {"???", "???", 0xF3, 0},
  {"???", "???", 0xF4, 0},
  {"SBC", "SBC $%02X,X", 0xF5, 1},
  {"INC", "INC $%02X,X", 0xF6, 1},
  {"???", "???", 0xF7, 0},
  {"SED", "SED", 0xF8, 0},
  {"SBC", "SBC $%02X%02X,Y", 0xF9, 2},
  {"PLX", "xPLX", 0xFA, 0},
  {"???", "???", 0xFB, 0},
  {"???", "???", 0xFC, 0},
  {"SBC", "SBC $%02X%02X,X", 0xFD, 2},
  {"INC", "INC $%02X%02X,X", 0xFE, 2},
  {"???", "???", 0xFF, 0}

};

#endif /* APPLE_IIE */

struct opcode_struct opcodes_6502[256] =
{

  {"BRK", "BRK", 0x00, 0},
  {"ORA", "ORA ($%02X,X)", 0x01, 1},
  {"???", "???", 0x02, 0},
  {"???", "???", 0x03, 0},
  {"???", "???", 0x04, 0},
  {"ORA", "ORA $%02X", 0x05, 1},
  {"ASL", "ASL $%02X", 0x06, 1},
  {"???", "???", 0x07, 0},
  {"PHP", "PHP", 0x08, 0},
  {"ORA", "ORA #$%02X", 0x09, 1},
  {"ASL", "ASL", 0x0A, 0},
  {"???", "???", 0x0B, 0},
  {"???", "???", 0x0C, 0},
  {"ORA", "ORA $%02X%02X", 0x0D, 2},
  {"ASL", "ASL $%02X%02X", 0x0E, 2},
  {"???", "???", 0x0F, 0},
  {"BPL", "BPL $%04X (_$%02X)", 0x10, 3},
  {"ORA", "ORA ($%02X),Y", 0x11, 1},
  {"???", "???", 0x12, 0},
  {"???", "???", 0x13, 0},
  {"???", "???", 0x14, 0},
  {"ORA", "ORA $%02X,X", 0x15, 1},
  {"ASL", "ASL $%02X,X", 0x16, 1},
  {"???", "???", 0x17, 0},
  {"CLC", "CLC", 0x18, 0},
  {"ORA", "ORA $%02X%02X,Y", 0x19, 2},
  {"???", "???", 0x1A, 0},
  {"???", "???", 0x1B, 0},
  {"???", "???", 0x1C, 0},
  {"ORA", "ORA $%02X%02X,X", 0x1D, 2},
  {"ASL", "ASL $%02X%02X,X", 0x1E, 2},
  {"???", "???", 0x1F, 0},
  {"JSR", "JSR %02X%02X", 0x20, 2},
  {"AND", "AND ($%02X,X)", 0x21, 1},
  {"???", "???", 0x22, 0},
  {"???", "???", 0x23, 0},
  {"BIT", "BIT $%02X", 0x24, 1},
  {"AND", "AND $%02X", 0x25, 1},
  {"ROL", "ROL $%02X", 0x26, 1},
  {"???", "???", 0x27, 0},
  {"PLP", "PLP", 0x28, 0},
  {"AND", "AND #$%02X", 0x29, 1},
  {"ROL", "ROL", 0x2A, 0},
  {"???", "???", 0x2B, 0},
  {"BIT", "BIT $%02X%02X", 0x2C, 2},
  {"AND", "AND $%02X%02X", 0x2D, 2},
  {"ROL", "ROL $%02X%02X", 0x2E, 2},
  {"???", "???", 0x2F, 0},
  {"BMI", "BMI $%04X (_$%02X)", 0x30, 3},
  {"AND", "AND ($%02X),Y", 0x31, 1},
  {"???", "???", 0x32, 0},
  {"???", "???", 0x33, 0},
  {"???", "???", 0x34, 0},
  {"AND", "AND $%02X,X", 0x35, 1},
  {"ROL", "ROL $%02X,X", 0x36, 1},
  {"???", "???", 0x37, 0},
  {"SEC", "SEC", 0x38, 0},
  {"AND", "AND $%02X%02X,Y", 0x39, 2},
  {"???", "???", 0x3A, 0},
  {"???", "???", 0x3B, 0},
  {"???", "???", 0x3C, 0},
  {"AND", "AND $%02X%02X,X", 0x3D, 2},
  {"ROL", "ROL $%02X%02X,X", 0x3E, 2},
  {"???", "???", 0x3F, 0},
  {"RTI", "RTI", 0x40, 0},
  {"EOR", "EOR ($%02X,X)", 0x41, 1},
  {"???", "???", 0x42, 0},
  {"???", "???", 0x43, 0},
  {"???", "???", 0x44, 0},
  {"EOR", "EOR $%02X", 0x45, 1},
  {"LSR", "LSR $%02X", 0x46, 1},
  {"???", "???", 0x47, 0},
  {"PHA", "PHA", 0x48, 0},
  {"EOR", "EOR #$%02X", 0x49, 1},
  {"LSR", "LSR", 0x4A, 0},
  {"???", "???", 0x4B, 0},
  {"JMP", "JMP %02X%02X", 0x4C, 2},
  {"EOR", "EOR %02X%02X", 0x4D, 2},
  {"LSR", "LSR %02X%02X", 0x4E, 2},
  {"???", "???", 0x4F, 0},
  {"BVC", "BVC $%04X (_$%02X)", 0x50, 3},
  {"EOR", "EOR ($%02X),Y", 0x51, 1},
  {"???", "???", 0x52, 0},
  {"???", "???", 0x53, 0},
  {"???", "???", 0x54, 0},
  {"EOR", "EOR $%02X,X", 0x55, 1},
  {"LSR", "LSR $%02X,X", 0x56, 1},
  {"???", "???", 0x57, 0},
  {"CLI", "CLI", 0x58, 0},
  {"EOR", "EOR $%02X%02X,Y", 0x59, 2},
  {"???", "???", 0x5A, 0},
  {"???", "???", 0x5B, 0},
  {"???", "???", 0x5C, 0},
  {"EOR", "EOR $%02X%02X,X", 0x5D, 2},
  {"LSR", "LSR $%02X%02X,X", 0x5E, 2},
  {"???", "???", 0x5F, 0},
  {"RTS", "RTS", 0x60, 0},
  {"ADC", "ADC ($%02X,X)", 0x61, 1},
  {"???", "???", 0x62, 0},
  {"???", "???", 0x63, 0},
  {"???", "???", 0x64, 0},
  {"ADC", "ADC $%02X", 0x65, 1},
  {"ROR", "ROR $%02X", 0x66, 1},
  {"???", "???", 0x67, 0},
  {"PLA", "PLA", 0x68, 0},
  {"ADC", "ADC #$%02X", 0x69, 1},
  {"ROR", "ROR", 0x6A, 0},
  {"???", "???", 0x6B, 0},
  {"JMP", "JMP ($%02X%02X)", 0x6C, 2},
  {"ADC", "ADC $%02X%02X", 0x6D, 2},
  {"ROR", "ROR $%02X%02X", 0x6E, 2},
  {"???", "???", 0x6F, 0},
  {"BVS", "BVS $%04X (_$%02X)", 0x70, 3},
  {"ADC", "ADC ($%02X),Y", 0x71, 1},
  {"???", "???", 0x72, 0},
  {"???", "???", 0x73, 0},
  {"???", "???", 0x74, 0},
  {"ADC", "ADC $%02X,X", 0x75, 1},
  {"ROR", "ROR $%02X,X", 0x76, 1},
  {"???", "???", 0x77, 0},
  {"SEI", "SEI", 0x78, 0},
  {"ADC", "ADC $%02X%02X,Y", 0x79, 2},
  {"???", "???", 0x7A, 0},
  {"???", "???", 0x7B, 0},
  {"???", "???", 0x7C, 0},
  {"ADC", "ADC $%02X%02X,X", 0x7D, 2},
  {"ROR", "ROR $%02X%02X,X", 0x7E, 2},
  {"???", "???", 0x7F, 0},
  {"???", "???", 0x80, 0},
  {"STA", "STA ($%02X,X)", 0x81, 1},
  {"???", "???", 0x82, 0},
  {"???", "???", 0x83, 0},
  {"STY", "STY $%02X", 0x84, 1},
  {"STA", "STA $%02X", 0x85, 1},
  {"STX", "STX $%02X", 0x86, 1},
  {"???", "???", 0x87, 0},
  {"DEY", "DEY", 0x88, 0},
  {"???", "???", 0x89, 0},
  {"TXA", "TXA", 0x8A, 0},
  {"???", "???", 0x8B, 0},
  {"STY", "STY $%02X%02X", 0x8C, 2},
  {"STA", "STA $%02X%02X", 0x8D, 2},
  {"STX", "STX $%02X%02X", 0x8E, 2},
  {"???", "???", 0x8F, 0},
  {"BCC", "BCC $%04X (_$%02X)", 0x90, 3},
  {"STA", "STA ($%02X),Y", 0x91, 1},
  {"???", "???", 0x92, 0},
  {"???", "???", 0x93, 0},
  {"STY", "STY $%02X,X", 0x94, 1},
  {"STA", "STA $%02X,X", 0x95, 1},
  {"STX", "STX $%02X,Y", 0x96, 1},
  {"???", "???", 0x97, 0},
  {"TYA", "TYA", 0x98, 0},
  {"STA", "STA $%02X%02X,Y", 0x99, 2},
  {"TXS", "TXS", 0x9A, 0},
  {"???", "???", 0x9B, 0},
  {"???", "???", 0x9C, 0},
  {"STA", "STA $%02X%02X,X", 0x9D, 2},
  {"???", "???", 0x9E, 0},
  {"???", "???", 0x9F, 0},
  {"LDY", "LDY #$%02X", 0xA0, 1},
  {"LDA", "LDA ($%02X,X)", 0xA1, 1},
  {"LDX", "LDX #$%02X", 0xA2, 1},
  {"???", "???", 0xA3, 0},
  {"LDY", "LDY $%02X", 0xA4, 1},
  {"LDA", "LDA $%02X", 0xA5, 1},
  {"LDX", "LDX $%02X", 0xA6, 1},
  {"???", "???", 0xA7, 0},
  {"TAY", "TAY", 0xA8, 0},
  {"LDA", "LDA #$%02X", 0xA9, 1},
  {"TAX", "TAX", 0xAA, 0},
  {"???", "???", 0xAB, 0},
  {"LDY", "LDY $%02X%02X", 0xAC, 2},
  {"LDA", "LDA $%02X%02X", 0xAD, 2},
  {"LDX", "LDX $%02X%02X", 0xAE, 2},
  {"???", "???", 0xAF, 0},
  {"BCS", "BCS $%04X (_$%02X)", 0xB0, 3},
  {"LDA", "LDA ($%02X),Y", 0xB1, 1},
  {"???", "???", 0xB2, 0},
  {"???", "???", 0xB3, 0},
  {"LDY", "LDY $%02X,X", 0xB4, 1},
  {"LDA", "LDA $%02X,X", 0xB5, 1},
  {"LDX", "LDX $%02X,Y", 0xB6, 1},
  {"???", "???", 0xB7, 0},
  {"CLV", "CLV", 0xB8, 0},
  {"LDA", "LDA $%02X%02X,Y", 0xB9, 2},
  {"TSX", "TSX", 0xBA, 0},
  {"???", "???", 0xBB, 0},
  {"LDY", "LDY $%02X%02X,X", 0xBC, 2},
  {"LDA", "LDA $%02X%02X,X", 0xBD, 2},
  {"LDX", "LDX $%02X%02X,Y", 0xBE, 2},
  {"???", "???", 0xBF, 0},
  {"CPY", "CPY #$%02X", 0xC0, 1},
  {"CMP", "CMP ($%02X,X)", 0xC1, 1},
  {"???", "???", 0xC2, 0},
  {"???", "???", 0xC3, 0},
  {"CPY", "CPY $%02X", 0xC4, 1},
  {"CMP", "CMP $%02X", 0xC5, 1},
  {"DEC", "DEC $%02X", 0xC6, 1},
  {"???", "???", 0xC7, 0},
  {"INY", "INY", 0xC8, 0},
  {"CMP", "CMP #$%02X", 0xC9, 1},
  {"DEX", "DEX", 0xCA, 0},
  {"???", "???", 0xCB, 0},
  {"CPY", "CPY $%02X%02X", 0xCC, 2},
  {"CMP", "CMP $%02X%02X", 0xCD, 2},
  {"DEC", "DEC $%02X%02X", 0xCE, 2},
  {"???", "???", 0xCF, 0},
  {"BNE", "BNE $%04X (_$%02X)", 0xD0, 3},
  {"CMP", "CMP ($%02X),Y", 0xD1, 1},
  {"???", "???", 0xD2, 0},
  {"???", "???", 0xD3, 0},
  {"???", "???", 0xD4, 0},
  {"CMP", "CMP $%02X,X", 0xD5, 1},
  {"DEC", "DEC $%02X,X", 0xD6, 1},
  {"???", "???", 0xD7, 0},
  {"CLD", "CLD", 0xD8, 0},
  {"CMP", "CMP $%02X%02X,Y", 0xD9, 2},
  {"???", "???", 0xDA, 0},
  {"???", "???", 0xDB, 0},
  {"???", "???", 0xDC, 0},
  {"CMP", "CMP $%02X%02X,X", 0xDD, 2},
  {"DEC", "DEC $%02X%02X,X", 0xDE, 2},
  {"???", "???", 0xDF, 0},
  {"CPX", "CPX #$%02X", 0xE0, 1},
  {"SBC", "SBC ($%02X,X)", 0xE1, 0},
  {"???", "???", 0xE2, 0},
  {"???", "???", 0xE3, 0},
  {"CPX", "CPX $%02X", 0xE4, 1},
  {"SBC", "SBC $%02X", 0xE5, 1},
  {"INC", "INC $%02X", 0xE6, 1},
  {"???", "???", 0xE7, 0},
  {"INX", "INX", 0xE8, 0},
  {"SBC", "SBC #$%02X", 0xE9, 1},
  {"NOP", "NOP", 0xEA, 0},
  {"???", "???", 0xEB, 0},
  {"CPX", "CPX $%02X%02X", 0xEC, 2},
  {"SBC", "SBC $%02X%02X", 0xED, 2},
  {"INC", "INC $%02X%02X", 0xEE, 2},
  {"???", "???", 0xEF, 0},
  {"BEQ", "BEQ $%04X (_$%02X)", 0xF0, 3},
  {"SBC", "SBC ($%02X),Y", 0xF1, 1},
  {"???", "???", 0xF2, 0},
  {"???", "???", 0xF3, 0},
  {"???", "???", 0xF4, 0},
  {"SBC", "SBC $%02X,X", 0xF5, 1},
  {"INC", "INC $%02X,X", 0xF6, 1},
  {"???", "???", 0xF7, 0},
  {"SED", "SED", 0xF8, 0},
  {"SBC", "SBC $%02X%02X,Y", 0xF9, 2},
  {"???", "???", 0xFA, 0},
  {"???", "???", 0xFB, 0},
  {"???", "???", 0xFC, 0},
  {"SBC", "SBC $%02X%02X,X", 0xFD, 2},
  {"INC", "INC $%02X%02X,X", 0xFE, 2},
  {"???", "???", 0xFF, 0}

};

struct opcode_struct opcodes_undoc[256] =
{

  {"BRK", "BRK", 0x00, 0},
  {"ORA", "ORA ($%02X,X)", 0x01, 1},
  {"HANG", "HANG", 0x02, 0},
  {"LORX", "LORX $%02X", 0x03, 1},
  {"NOP2", "NOP2", 0x04, 0},
  {"ORA", "ORA $%02X", 0x05, 1},
  {"ASL", "ASL $%02X", 0x06, 1},
  {"LORZ", "LORZ $%02X", 0x07, 1},
  {"PHP", "PHP", 0x08, 0},
  {"ORA", "ORA #$%02X", 0x09, 1},
  {"ASL", "ASL", 0x0A, 0},
  {"ANA_", "ANA_ #$%02X", 0x0B, 1},
  {"NOP3", "NOP3", 0x0C, 0},
  {"ORA", "ORA $%02X%02X", 0x0D, 2},
  {"ASL", "ASL $%02X%02X", 0x0E, 2},
  {"LORa", "LORa $%02X%02X", 0x0F, 2},
  {"BPL", "BPL $%04X (_$%02X)", 0x10, 3},
  {"ORA", "ORA ($%02X),Y", 0x11, 1},
  {"HANG", "HANG", 0x12, 0},
  {"LORY", "LORY $%02X", 0x13, 1},
  {"NOP2", "NOP2", 0x14, 0},
  {"ORA", "ORA $%02X,X", 0x15, 1},
  {"ASL", "ASL $%02X,X", 0x16, 1},
  {"LORZX", "LORZX $%02X", 0x17, 1},
  {"CLC", "CLC", 0x18, 0},
  {"ORA", "ORA $%02X%02X,Y", 0x19, 2},
  {"NOP_", "NOP_", 0x1A, 0},
  {"LORy", "LORy $%02X%02X", 0x1B, 2},
  {"NOP3", "NOP3", 0x1C, 0},
  {"ORA", "ORA $%02X%02X,X", 0x1D, 2},
  {"ASL", "ASL $%02X%02X,X", 0x1E, 2},
  {"LORx", "LORx $%02X%02X", 0x1F, 2},
  {"JSR", "JSR %02X%02X", 0x20, 2},
  {"AND", "AND ($%02X,X)", 0x21, 1},
  {"HANG", "HANG", 0x22, 0},
  {"LANX", "LANX $%02X", 0x23, 1},
  {"BIT", "BIT $%02X", 0x24, 1},
  {"AND", "AND $%02X", 0x25, 1},
  {"ROL", "ROL $%02X", 0x26, 1},
  {"LANZ", "LANZ $%02X", 0x27, 1},
  {"PLP", "PLP", 0x28, 0},
  {"AND", "AND #$%02X", 0x29, 1},
  {"ROL", "ROL", 0x2A, 0},
  {"ANB_", "ANB_ #$%02X", 0x2B, 1},
  {"BIT", "BIT $%02X%02X", 0x2C, 2},
  {"AND", "AND $%02X%02X", 0x2D, 2},
  {"ROL", "ROL $%02X%02X", 0x2E, 2},
  {"LANa", "LANa $%02X%02X", 0x2F, 2},
  {"BMI", "BMI $%04X (_$%02X)", 0x30, 3},
  {"AND", "AND ($%02X),Y", 0x31, 1},
  {"HANG", "HANG", 0x32, 0},
  {"LANY", "LANY $%02X", 0x33, 1},
  {"NOP2", "NOP2", 0x34, 0},
  {"AND", "AND $%02X,X", 0x35, 1},
  {"ROL", "ROL $%02X,X", 0x36, 1},
  {"LANZX", "LANZX $%02X", 0x37, 1},
  {"SEC", "SEC", 0x38, 0},
  {"AND", "AND $%02X%02X,Y", 0x39, 2},
  {"NOP_", "NOP_", 0x3A, 0},
  {"LANy", "LANy $%02X%02X", 0x3B, 2},
  {"NOP3", "NOP3", 0x3C, 0},
  {"AND", "AND $%02X%02X,X", 0x3D, 2},
  {"ROL", "ROL $%02X%02X,X", 0x3E, 2},
  {"LANx", "LANx $%02X%02X", 0x3F, 2},
  {"RTI", "RTI", 0x40, 0},
  {"EOR", "EOR ($%02X,X)", 0x41, 1},
  {"HANG", "HANG", 0x42, 0},
  {"REOX", "REOX $%02X", 0x43, 1},
  {"NOP2", "NOP2", 0x44, 0},
  {"EOR", "EOR $%02X", 0x45, 1},
  {"LSR", "LSR $%02X", 0x46, 1},
  {"REOZ", "REOZ $%02X", 0x47, 1},
  {"PHA", "PHA", 0x48, 0},
  {"EOR", "EOR #$%02X", 0x49, 1},
  {"LSR", "LSR", 0x4A, 0},
  {"RAM_", "RAM_ #$%02X", 0x4B, 1},
  {"JMP", "JMP %02X%02X", 0x4C, 2},
  {"EOR", "EOR %02X%02X", 0x4D, 2},
  {"LSR", "LSR %02X%02X", 0x4E, 2},
  {"REOa", "REOa %02X%02X", 0x4F, 2},
  {"BVC", "BVC $%04X (_$%02X)", 0x50, 3},
  {"EOR", "EOR ($%02X),Y", 0x51, 1},
  {"HANG", "HANG", 0x52, 0},
  {"REOY", "REOY $%02X", 0x53, 1},
  {"NOP2", "NOP2", 0x54, 0},
  {"EOR", "EOR $%02X,X", 0x55, 1},
  {"LSR", "LSR $%02X,X", 0x56, 1},
  {"REOZX", "REOZX $%02X", 0x57, 1},
  {"CLI", "CLI", 0x58, 0},
  {"EOR", "EOR $%02X%02X,Y", 0x59, 2},
  {"NOP_", "NOP_", 0x5A, 0},
  {"REOy", "REOy $%02X%02X", 0x5B, 2},
  {"NOP3", "NOP3", 0x5C, 0},
  {"EOR", "EOR $%02X%02X,X", 0x5D, 2},
  {"LSR", "LSR $%02X%02X,X", 0x5E, 2},
  {"REOx", "REOx $%02X%02X", 0x5F, 2},
  {"RTS", "RTS", 0x60, 0},
  {"ADC", "ADC ($%02X,X)", 0x61, 1},
  {"HANG", "HANG", 0x62, 0},
  {"RADX", "RADX $%02X", 0x63, 1},
  {"NOP2", "NOP2", 0x64, 0},
  {"ADC", "ADC $%02X", 0x65, 1},
  {"ROR", "ROR $%02X", 0x66, 1},
  {"RADZ", "RADZ $%02X", 0x67, 1},
  {"PLA", "PLA", 0x68, 0},
  {"ADC", "ADC #$%02X", 0x69, 1},
  {"ROR", "ROR", 0x6A, 0},
  {"RBM_", "RBM_ #$%02X", 0x6B, 1},
  {"JMP", "JMP ($%02X%02X)", 0x6C, 2},
  {"ADC", "ADC $%02X%02X", 0x6D, 2},
  {"ROR", "ROR $%02X%02X", 0x6E, 2},
  {"RADa", "RADa $%02X%02X", 0x6F, 2},
  {"BVS", "BVS $%04X (_$%02X)", 0x70, 3},
  {"ADC", "ADC ($%02X),Y", 0x71, 1},
  {"HANG", "HANG", 0x72, 0},
  {"RADY", "RADY $%02X", 0x73, 1},
  {"NOP2", "NOP2", 0x74, 0},
  {"ADC", "ADC $%02X,X", 0x75, 1},
  {"ROR", "ROR $%02X,X", 0x76, 1},
  {"RADZX", "RADZX $%02X", 0x77, 1},
  {"SEI", "SEI", 0x78, 0},
  {"ADC", "ADC $%02X%02X,Y", 0x79, 2},
  {"NOP_", "NOP_", 0x7A, 0},
  {"RADy", "RADy $%02X%02X", 0x7B, 2},
  {"NOP3", "NOP3", 0x7C, 0},
  {"ADC", "ADC $%02X%02X,X", 0x7D, 2},
  {"ROR", "ROR $%02X%02X,X", 0x7E, 2},
  {"RADx", "RADx $%02X%02X", 0x7F, 2},
  {"NOP2", "NOP2", 0x80, 0},
  {"STA", "STA ($%02X,X)", 0x81, 1},
  {"NOP2", "NOP2", 0x82, 0},
  {"AAXX", "AAXX $%02X", 0x83, 1},
  {"STY", "STY $%02X", 0x84, 1},
  {"STA", "STA $%02X", 0x85, 1},
  {"STX", "STX $%02X", 0x86, 1},
  {"AAXZ", "AAXZ $%02X", 0x87, 1},
  {"DEY", "DEY", 0x88, 0},
  {"NOP2", "NOP2", 0x89, 0},
  {"TXA", "TXA", 0x8A, 0},
  {"XMA_", "XMA_ $%02X", 0x8B, 1},
  {"STY", "STY $%02X%02X", 0x8C, 2},
  {"STA", "STA $%02X%02X", 0x8D, 2},
  {"STX", "STX $%02X%02X", 0x8E, 2},
  {"AAXa", "AAXa $%02X%02X", 0x8F, 2},
  {"BCC", "BCC $%04X (_$%02X)", 0x90, 3},
  {"STA", "STA ($%02X),Y", 0x91, 1},
  {"HANG", "HANG", 0x92, 0},
  {"AAXY", "AAXY $%02X", 0x93, 1},
  {"STY", "STY $%02X,X", 0x94, 1},
  {"STA", "STA $%02X,X", 0x95, 1},
  {"STX", "STX $%02X,Y", 0x96, 1},
  {"AAXZY", "AAXZY $%02X", 0x97, 1},
  {"TYA", "TYA", 0x98, 0},
  {"STA", "STA $%02X%02X,Y", 0x99, 2},
  {"TXS", "TXS", 0x9A, 0},
  {"AXSa", "AXSa $%02X%02X", 0x9B, 2},
  {"TEYx", "TEYx $%02X%02X", 0x9C, 2},
  {"STA", "STA $%02X%02X,X", 0x9D, 2},
  {"TEXy", "TEXy $%02X%02X", 0x9E, 2},
  {"TEAy", "TEAy $%02X%02X", 0x9F, 2},
  {"LDY", "LDY #$%02X", 0xA0, 1},
  {"LDA", "LDA ($%02X,X)", 0xA1, 1},
  {"LDX", "LDX #$%02X", 0xA2, 1},
  {"LAXX", "LAXX $%02X", 0xA3, 1},
  {"LDY", "LDY $%02X", 0xA4, 1},
  {"LDA", "LDA $%02X", 0xA5, 1},
  {"LDX", "LDX $%02X", 0xA6, 1},
  {"LAXZ", "LAXZ $%02X", 0xA7, 1},
  {"TAY", "TAY", 0xA8, 0},
  {"LDA", "LDA #$%02X", 0xA9, 1},
  {"TAX", "TAX", 0xAA, 0},
  {"AMA_", "AMA_ #$%02X", 0xAB, 1},
  {"LDY", "LDY $%02X%02X", 0xAC, 2},
  {"LDA", "LDA $%02X%02X", 0xAD, 2},
  {"LDX", "LDX $%02X%02X", 0xAE, 2},
  {"LAXa", "LAXa $%02X%02X", 0xAF, 2},
  {"BCS", "BCS $%04X (_$%02X)", 0xB0, 3},
  {"LDA", "LDA ($%02X),Y", 0xB1, 1},
  {"HANG", "HANG", 0xB2, 0},
  {"LAXY", "LAXY $%02X", 0xB3, 1},
  {"LDY", "LDY $%02X,X", 0xB4, 1},
  {"LDA", "LDA $%02X,X", 0xB5, 1},
  {"LDX", "LDX $%02X,Y", 0xB6, 1},
  {"LAXZY", "LAXZY $%02X", 0xB7, 1},
  {"CLV", "CLV", 0xB8, 0},
  {"LDA", "LDA $%02X%02X,Y", 0xB9, 2},
  {"TSX", "TSX", 0xBA, 0},
  {"LASy", "LASy $%02X%02X", 0xBB, 2},
  {"LDY", "LDY $%02X%02X,X", 0xBC, 2},
  {"LDA", "LDA $%02X%02X,X", 0xBD, 2},
  {"LDX", "LDX $%02X%02X,Y", 0xBE, 2},
  {"LAXy", "LAXy $%02X%02X", 0xBF, 2},
  {"CPY", "CPY #$%02X", 0xC0, 1},
  {"CMP", "CMP ($%02X,X)", 0xC1, 1},
  {"NOP2", "NOP2", 0xC2, 0},
  {"DCPX", "DCPX $%02X", 0xC3, 1},
  {"CPY", "CPY $%02X", 0xC4, 1},
  {"CMP", "CMP $%02X", 0xC5, 1},
  {"DEC", "DEC $%02X", 0xC6, 1},
  {"DCPZ", "DCPZ $%02X", 0xC7, 1},
  {"INY", "INY", 0xC8, 0},
  {"CMP", "CMP #$%02X", 0xC9, 1},
  {"DEX", "DEX", 0xCA, 0},
  {"AXM_", "AXM_ #$%02X", 0xCB, 1},
  {"CPY", "CPY $%02X%02X", 0xCC, 2},
  {"CMP", "CMP $%02X%02X", 0xCD, 2},
  {"DEC", "DEC $%02X%02X", 0xCE, 2},
  {"DCPa", "DCPa $%02X%02X", 0xCF, 2},
  {"BNE", "BNE $%04X (_$%02X)", 0xD0, 3},
  {"CMP", "CMP ($%02X),Y", 0xD1, 1},
  {"HANG", "HANG", 0xD2, 0},
  {"DCPY", "DCPY $%02X", 0xD3, 1},
  {"NOP2", "NOP2", 0xD4, 0},
  {"CMP", "CMP $%02X,X", 0xD5, 1},
  {"DEC", "DEC $%02X,X", 0xD6, 1},
  {"DCPZX", "DCPZX $%02X", 0xD7, 1},
  {"CLD", "CLD", 0xD8, 0},
  {"CMP", "CMP $%02X%02X,Y", 0xD9, 2},
  {"NOP_", "NOP_", 0xDA, 0},
  {"DCPy", "DCPy $%02X%02X", 0xDB, 2},
  {"NOP3", "NOP3", 0xDC, 0},
  {"CMP", "CMP $%02X%02X,X", 0xDD, 2},
  {"DEC", "DEC $%02X%02X,X", 0xDE, 2},
  {"DCPx", "DCPx $%02X%02X", 0xDF, 2},
  {"CPX", "CPX #$%02X", 0xE0, 1},
  {"SBC", "SBC ($%02X,X)", 0xE1, 0},
  {"NOP2", "NOP2", 0xE2, 0},
  {"ISBx", "ISBx $%02X", 0xE3, 1},
  {"CPX", "CPX $%02X", 0xE4, 1},
  {"SBC", "SBC $%02X", 0xE5, 1},
  {"INC", "INC $%02X", 0xE6, 1},
  {"ISBZ", "ISBZ $%02X", 0xE7, 1},
  {"INX", "INX", 0xE8, 0},
  {"SBC", "SBC #$%02X", 0xE9, 1},
  {"NOP", "NOP", 0xEA, 0},
  {"ZBC_", "ZBC_ #$%02X", 0xEB, 1},
  {"CPX", "CPX $%02X%02X", 0xEC, 2},
  {"SBC", "SBC $%02X%02X", 0xED, 2},
  {"INC", "INC $%02X%02X", 0xEE, 2},
  {"ISBa", "ISBa $%02X%02X", 0xEF, 2},
  {"BEQ", "BEQ $%04X (_$%02X)", 0xF0, 3},
  {"SBC", "SBC ($%02X),Y", 0xF1, 1},
  {"HANG", "HANG", 0xF2, 0},
  {"ISBY", "ISBY $%02X", 0xF3, 1},
  {"NOP2", "NOP2", 0xF4, 0},
  {"SBC", "SBC $%02X,X", 0xF5, 1},
  {"INC", "INC $%02X,X", 0xF6, 1},
  {"ISBZX", "ISBZX $%02X", 0xF7, 1},
  {"SED", "SED", 0xF8, 0},
  {"SBC", "SBC $%02X%02X,Y", 0xF9, 2},
  {"NOP_", "NOP_", 0xFA, 0},
  {"ISBy", "ISBy $%02X%02X", 0xFB, 2},
  {"NOP3", "NOP3", 0xFC, 0},
  {"SBC", "SBC $%02X%02X,X", 0xFD, 2},
  {"INC", "INC $%02X%02X,X", 0xFE, 2},
  {"ISBx", "ISBx $%02X%02X", 0xFF, 2}

};
