/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
 
package xslp.formatters;

import com.jtauber.fop.apps.DOMProcessor;
import com.jtauber.fop.apps.FOPException;
import java.io.PrintWriter;
import org.w3c.dom.*;
import com.kvisco.xsl.Formatter;

/**
 * A Wrapper class for James Tauber's FOP (PDF Formatter)
 * FOP can be obtained at http://www.jtauber.com/fop
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class FOPFormatter extends Formatter {

    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates a new FOPFormatter
    **/
    public FOPFormatter() {
        super();
    } //-- FOPFormatter

      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Defined by Formatter. Processes the given set of nodes.
     * @param nodeList the set of nodes to process
     * @param output the PrintStream for IO during processing.
     * @see org.w3c.dom.NodeList
    **/
    public void process(Document document, PrintWriter output) {

        if (document == null) return;
        DOMProcessor domProcessor = new DOMProcessor(document);
        try {
            domProcessor.format(output);
        }
        catch(FOPException fopException) {
            System.out.println(fopException.getMessage());
        }
        
    } //-- process

} //-- FOPFormatter