/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.List;
import org.w3c.dom.Node;

/**
 * A implementation of the "substring-before" function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class SubstringBefore extends FunctionCall {
    
    /**
     * Creates a new SubstringBefore FunctionCall
    **/
    public SubstringBefore() {
        super(Names.SUBSTRING_BEFORE_FN);
    } //-- SubstringBefore
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a StringResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        List params = getParameterList();
        
        if (params.size() != 2)
            throw new InvalidExprException(INVALID_NUMBER_PARAMS+this);
            
        Expr expr1 = (Expr)params.get(0);
        Expr expr2 = (Expr)params.get(1);
        
        StringResult strResult1 = 
            StringExpr.toStringResult(expr1.evaluate(context, ps));
            
        StringResult strResult2 = 
            StringExpr.toStringResult(expr2.evaluate(context, ps));
            
       
        String contextStr = strResult1.getValue();
        String pattern = strResult2.getValue();
        
        int idx = contextStr.indexOf(pattern);
        
        if (idx < 0) return new StringResult("");
        
        return new StringResult(contextStr.substring(0,idx));
    } //-- evaluate
    
} //-- SubstringBefore

