/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.*;
import com.kvisco.xml.parser.DOMPackage;

import com.kvisco.net.URIUtils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;

import org.w3c.dom.Node;
import org.w3c.dom.Document;


/**
 * A class that represents the XSL document() function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class DocumentFunctionCall extends FunctionCall {
    
    /**
     * Creates a new Document() Function Call
    **/
    public DocumentFunctionCall() {
        super(Names.DOCUMENT_FN);
    } //-- DocumentFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context.
     * @exception InvalidExprException when the expression being
     * evaluated has an error.
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        
        List params = getParameterList();
        
        if ((params.size() < 1) || (params.size() > 2))
            throw new InvalidExprException(INVALID_NUMBER_PARAMS+this);
            
       
        ExprResult res1 = ((Expr)params.get(0)).evaluate(context, ps);
        
        //ExprResult res2 = ((Expr)params.get(1)).evaluate(context, ps);
        
        NodeSet nodeSet = new NodeSet();
        
        switch (res1.getResultType()) {
            case ExprResult.NODE_SET:
                NodeSet nodes = (NodeSet)res1;
                for (int i = 0; i < nodes.size(); i++) {
                    String href = XSLObject.getNodeValue(nodes.get(i));
                    Document doc = getDocument(href, ps);
                    if (doc != null) nodeSet.add(doc);
                }
                break;
            default:
                String href = StringExpr.toStringResult(res1).toString();
                Document doc = getDocument(href, ps);
                if (doc != null) nodeSet.add(doc);
                break;
        }
        return nodeSet;
    } //-- evaluate
    
    private Document getDocument(String href, ProcessorState ps) {
        
        if ((href == null) || (href.length() == 0))
            href = ps.getStylesheetHref();
            
        InputStream inStream = null;
        try {
            inStream = URIUtils.getInputStream(href, "");
        }
        catch(Exception ex) {
            //-- add error message
            return null;
        }
        InputStreamReader isReader = new InputStreamReader(inStream);
        DOMPackage  domPackage  = ps.getDOMPackage();
        //PrintWriter pw = new PrintWriter( new StringWriter() );
        PrintWriter pw = new PrintWriter( System.out, true );
        return domPackage.readDocument(isReader, href, pw);
        
    }
} //-- DocumentFunctionCall