/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * This class represents an xsl:call-template.
 * @author <a href="mailto:peterc@knowledgecite.com">Peter Ciuffetti</a> 
 * @since WD-xslt-19990421
**/
public class XSLCallTemplate extends XSLObject {

      //----------------/
     //- Constructors -/
    //----------------/

    /**
     * Creates a new XSLCallTemplate
    **/
    protected XSLCallTemplate(XSLStylesheet parentStylesheet, String templateName)
    {
        super(parentStylesheet,XSLObject.CALL_TEMPLATE);
        setTemplateName(templateName);
    } //-- XSLCallTemplate

      //------------------/
     //- Public Methods -/
    //------------------/

	public boolean appendAction(XSLObject xslObject) {
	    return super.appendAction(xslObject);
	} //-- appendAction
    
	/**
	 * Returns the name of the Template that this XSLCallTemplate references
	 * @return the name of the Template that this XSLCallTemplate references
	**/
	public String getTemplateName() {
	    return getAttribute(Names.NAME_ATTR);
	} //-- getAttributeSetName

	/**
	 * Sets the name of the Template that this XSLCallTemplate references
	 * @param name the name Template that this XSLCallTemplate references
	**/
	public void setTemplateName(String name) {
	    try {
	        setAttribute(Names.NAME_ATTR,name);
	    }
	    catch(XSLException xslException) {};
	} //-- setAttributeSetName

} //-- XSLCallTemplate