/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */
package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents an OrExpr
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class OrExpr implements Expr {

    
    private static String OR = " or ";
    private static String NULL = "null";
    
    private Expr leftExpr = null;
    private Expr rightExpr = null;
    
    
      //---------------/
     //- Constructor -/
    //---------------/
    
    public OrExpr(Expr leftSideExpr, Expr rightSideExpr) {
        leftExpr = leftSideExpr;
        rightExpr = rightSideExpr;
    } //-- OrExpr 
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Returns the type of Expr this Expr represents
     * @return the type of Expr this Expr represents
    **/
    public short getExprType() {
        return Expr.BOOLEAN;
    } //-- getExprType
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        
        ExprResult exprResult     = null;


        if (leftExpr != null) {
            exprResult = leftExpr.evaluate(context, ps);
            if (exprResult.booleanValue())
                return BooleanResult.TRUE_RESULT;
        }

        if (rightExpr != null) {
            exprResult = rightExpr.evaluate(context, ps);
            if (exprResult.booleanValue())
                return BooleanResult.TRUE_RESULT;
        }
        return BooleanResult.FALSE_RESULT;
        
    } //-- evaluate
    
    
    /**
     * Returns the String representation of this AndExpr
     * @return the String representation of this AndExpr
    **/
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (leftExpr != null) sb.append(leftExpr.toString());
        else sb.append(NULL);
        sb.append(OR);
        if (rightExpr != null) sb.append(rightExpr.toString());
        else sb.append(NULL);
        return sb.toString();
    } //-- toString
    /* */
} //-- OrExpr