/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.util.QuickStack;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.FilterBase;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PathExpr
extends List
implements Expr,
MatchExpr {
    public final int ABSOLUTE = 0;
    public final int RELATIVE = 1;

    public PathExpr() {
    }

    public PathExpr(FilterBase filterBase) {
        this.add(filterBase);
    }

    public void add(FilterBase filterBase) {
        super.add(filterBase);
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (node == null || this.size() == 0) {
            return new NodeSet(0);
        }
        NodeSet nodeSet = new NodeSet();
        if (this.isAbsolute() && node.getNodeType() != 9) {
            nodeSet.add(node.getOwnerDocument());
        } else {
            nodeSet.add(node);
        }
        boolean bl = false;
        QuickStack quickStack = processorState.getNodeSetStack();
        int n = 0;
        while (n < this.size()) {
            FilterBase filterBase = (FilterBase)this.get(n);
            int n2 = filterBase.getAncestryOp();
            bl = bl || n2 == 1;
            NodeSet nodeSet2 = new NodeSet();
            quickStack.push(nodeSet);
            int n3 = 0;
            while (n3 < nodeSet.size()) {
                Node node2 = nodeSet.get(n3);
                NodeSet nodeSet3 = filterBase.evaluate(node2, processorState);
                nodeSet2.add(nodeSet3);
                if (bl) {
                    nodeSet2.add(PathExpr.fromDescendants(filterBase, node2, processorState));
                }
                ++n3;
            }
            quickStack.pop();
            nodeSet = nodeSet2;
            ++n;
        }
        return nodeSet;
    }

    private static NodeSet fromDescendants(FilterBase filterBase, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                default: {
                    nodeSet.add(filterBase.evaluate(node2, processorState));
                    if (!node2.hasChildNodes()) break;
                    NodeSet nodeSet2 = PathExpr.fromDescendants(filterBase, node2, processorState);
                    nodeSet.add(nodeSet2);
                }
                case 6: 
                case 10: 
            }
            ++n;
        }
        return nodeSet;
    }

    public int getDefaultPriority() {
        if (this.size() > 1) {
            return 1;
        }
        return ((FilterBase)this.get(0)).getDefaultPriority();
    }

    public short getExprType() {
        return 2;
    }

    private static Node getParentNode(Node node, ProcessorState processorState) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return processorState.findParent((Attr)node);
        }
        return node.getParentNode();
    }

    public boolean isAbsolute() {
        if (this.size() > 0) {
            return ((FilterBase)this.get(0)).getAncestryOp() != 0;
        }
        return false;
    }

    private boolean matches(Node node, ProcessorState processorState, int n) throws InvalidExprException {
        if (node == null) {
            return false;
        }
        Node node2 = node;
        Node node3 = node;
        if (n > this.size() || n < 0) {
            return false;
        }
        int n2 = 0;
        FilterBase filterBase = (FilterBase)this.get(n);
        n2 = filterBase.getAncestryOp();
        if (n == 0) {
            if (n2 == 2 && PathExpr.getParentNode(node2, processorState) != node2.getOwnerDocument()) {
                return false;
            }
            return filterBase.matches(node2, node3, processorState);
        }
        if (filterBase.matches(node2, node3, processorState)) {
            if (n2 == 2) {
                return this.matches(PathExpr.getParentNode(node2, processorState), processorState, n - 1);
            }
            if (n2 == 1) {
                while ((node2 = PathExpr.getParentNode(node2, processorState)) != null) {
                    if (!this.matches(node2, processorState, n - 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        if (node == null) {
            return false;
        }
        return this.matches(node, processorState, this.size() - 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            FilterBase filterBase = (FilterBase)this.get(n);
            switch (filterBase.getAncestryOp()) {
                case 1: {
                    stringBuffer.append("//");
                    break;
                }
                case 2: {
                    stringBuffer.append("/");
                    break;
                }
            }
            stringBuffer.append(filterBase.toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

