/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.QuickStack;
import com.kvisco.xsl.AxisIdentifier;
import com.kvisco.xsl.FilterBase;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

class LocationStep
extends FilterBase {
    public static final short ANCESTORS_AXIS = 0;
    public static final short ANCESTORS_OR_SELF_AXIS = 1;
    public static final short ATTRIBUTES_AXIS = 2;
    public static final short CHILDREN_AXIS = 3;
    public static final short DESCENDANTS_AXIS = 4;
    public static final short DESCENDANTS_OR_SELF_AXIS = 5;
    public static final short FOLLOWING_AXIS = 6;
    public static final short FOLLOWING_SIBLINGS_AXIS = 7;
    public static final short PARENT_AXIS = 8;
    public static final short PRECEDING_AXIS = 9;
    public static final short PRECEDING_SIBLINGS_AXIS = 10;
    public static final short SELF_AXIS = 11;
    private static final String FROM_PREFIX = "from-";
    private short axisIdentifier = (short)3;
    private NodeExpr nodeExpr = null;

    protected LocationStep() {
    }

    protected LocationStep(short s) {
        this.axisIdentifier = s;
    }

    public NodeSet evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (node == null || this.nodeExpr == null) {
            return new NodeSet(0);
        }
        NodeSet nodeSet = null;
        Object var4_4 = null;
        switch (this.axisIdentifier) {
            case 0: {
                nodeSet = AxisIdentifier.fromAncestors(this.nodeExpr, node, processorState);
                break;
            }
            case 1: {
                nodeSet = AxisIdentifier.fromAncestorsOrSelf(this.nodeExpr, node, processorState);
                break;
            }
            case 2: {
                nodeSet = AxisIdentifier.fromAttributes(this.nodeExpr, node, processorState);
                break;
            }
            case 4: {
                nodeSet = AxisIdentifier.fromDescendants(this.nodeExpr, node, processorState);
                break;
            }
            case 5: {
                nodeSet = AxisIdentifier.fromDescendantsOrSelf(this.nodeExpr, node, processorState);
                break;
            }
            case 6: {
                nodeSet = AxisIdentifier.fromFollowing(this.nodeExpr, node, processorState);
                break;
            }
            case 7: {
                nodeSet = AxisIdentifier.fromFollowingSiblings(this.nodeExpr, node, processorState);
                break;
            }
            case 8: {
                nodeSet = AxisIdentifier.fromParent(this.nodeExpr, node, processorState);
                break;
            }
            case 9: {
                nodeSet = AxisIdentifier.fromPreceding(this.nodeExpr, node, processorState);
                break;
            }
            case 10: {
                nodeSet = AxisIdentifier.fromPrecedingSiblings(this.nodeExpr, node, processorState);
                break;
            }
            case 11: {
                nodeSet = AxisIdentifier.fromSelf(this.nodeExpr, node, processorState);
                break;
            }
            default: {
                nodeSet = AxisIdentifier.fromChildren(this.nodeExpr, node, processorState);
            }
        }
        QuickStack quickStack = processorState.getNodeSetStack();
        quickStack.push(nodeSet);
        this.evaluatePredicates(nodeSet, processorState);
        quickStack.pop();
        return nodeSet;
    }

    public short getAxisIdentifier() {
        return this.axisIdentifier;
    }

    public int getDefaultPriority() {
        if (this.nodeExpr == null) {
            return -1;
        }
        int n = -1;
        switch (this.nodeExpr.getNodeExprType()) {
            case 1: 
            case 2: {
                n = 0;
                break;
            }
        }
        if (this.getPredicates().size() > 0) {
            n = 1;
        }
        return n;
    }

    protected NodeExpr getNodeExpr() {
        return this.nodeExpr;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        if (this.nodeExpr == null) {
            return false;
        }
        if (this.nodeExpr.matches(node, node2, processorState)) {
            NodeSet nodeSet = new NodeSet(1);
            nodeSet.add(node);
            this.evaluatePredicates(nodeSet, processorState);
            return nodeSet.size() == 1;
        }
        return false;
    }

    public void setAxisIdentifier(short s) {
        this.axisIdentifier = s;
    }

    protected void setNodeExpr(NodeExpr nodeExpr) {
        this.nodeExpr = nodeExpr;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(FROM_PREFIX);
        switch (this.axisIdentifier) {
            case 0: {
                stringBuffer.append("ancestors");
                break;
            }
            case 1: {
                stringBuffer.append("ancestors-or-self");
                break;
            }
            case 2: {
                stringBuffer.append("attributes");
                break;
            }
            case 4: {
                stringBuffer.append("descendants");
                break;
            }
            case 5: {
                stringBuffer.append("descendants-or-self");
                break;
            }
            case 6: {
                stringBuffer.append("following");
                break;
            }
            case 7: {
                stringBuffer.append("siblings");
                break;
            }
            case 8: {
                stringBuffer.append("parent");
                break;
            }
            case 9: {
                stringBuffer.append("preceding");
                break;
            }
            case 10: {
                stringBuffer.append("preceding-siblings");
                break;
            }
            case 11: {
                stringBuffer.append("self");
                break;
            }
            default: {
                stringBuffer.append("children");
            }
        }
        stringBuffer.append("(");
        if (this.nodeExpr == null) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(this.nodeExpr.toString());
            stringBuffer.append(super.toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

