/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.QuickStack;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.FilterBase;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.PrimaryExpr;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.TreeFragmentResult;
import org.w3c.dom.Node;

class FilterExpr
extends FilterBase {
    PrimaryExpr primaryExpr = null;

    protected FilterExpr() {
    }

    public NodeSet evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (this.primaryExpr == null) {
            return new NodeSet(0);
        }
        ExprResult exprResult = this.primaryExpr.evaluate(node, processorState);
        NodeSet nodeSet = null;
        switch (exprResult.getResultType()) {
            case 2: {
                nodeSet = (NodeSet)exprResult;
                break;
            }
            case 4: {
                nodeSet = new NodeSet(1);
                nodeSet.add(((TreeFragmentResult)exprResult).getValue());
                break;
            }
            default: {
                throw new InvalidExprException("expecting NodeSet or TreeFragment as the result of the expression: " + this.primaryExpr);
            }
        }
        QuickStack quickStack = processorState.getNodeSetStack();
        quickStack.push(nodeSet);
        this.evaluatePredicates(nodeSet, processorState);
        quickStack.pop();
        return nodeSet;
    }

    public int getDefaultPriority() {
        return 1;
    }

    public PrimaryExpr getPrimaryExpr() {
        return this.primaryExpr;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = this.evaluate(node, processorState);
        this.evaluatePredicates(nodeSet, processorState);
        return nodeSet.contains(node);
    }

    protected void setPrimaryExpr(PrimaryExpr primaryExpr) {
        this.primaryExpr = primaryExpr;
    }

    public String toString() {
        if (this.primaryExpr == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.primaryExpr.toString());
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

