/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.functions.FalseFunctionCall;
import com.kvisco.xsl.functions.TrueFunctionCall;
import org.w3c.dom.Node;

public class BooleanExpr
implements Expr {
    private Expr expr;

    protected BooleanExpr() {
        this(null);
    }

    protected BooleanExpr(Expr expr) {
        this.expr = expr;
    }

    protected BooleanExpr(boolean bl) {
        this.expr = bl ? new TrueFunctionCall() : new FalseFunctionCall();
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (this.expr != null) {
            return new BooleanResult(this.expr.evaluate(node, processorState));
        }
        return new BooleanResult();
    }

    public short getExprType() {
        return 1;
    }

    public String toString() {
        if (this.expr != null) {
            return this.expr.toString();
        }
        return "false()";
    }
}

