/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class AdditiveExpr
implements Expr {
    public static final short ADD = 0;
    public static final short SUBTRACT = 1;
    private Expr leftExpr = null;
    private Expr rightExpr = null;
    private short additiveOp = 0;
    private static Hashtable additiveOps = null;

    static {
        additiveOps = new Hashtable(2);
        additiveOps.put("+", new Short(0));
        additiveOps.put("-", new Short(1));
    }

    public AdditiveExpr(Expr expr, Expr expr2) {
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public AdditiveExpr(Expr expr, Expr expr2, String string) throws InvalidExprException {
        Short s;
        this.additiveOp = (short)-1;
        if (string != null && (s = (Short)additiveOps.get(string)) != null) {
            this.additiveOp = s;
        }
        if (this.additiveOp < 0 || this.additiveOp > additiveOps.size()) {
            throw new InvalidExprException("invalid operator for additive expression");
        }
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public AdditiveExpr(Expr expr, Expr expr2, short s) throws InvalidExprException {
        this.leftExpr = expr;
        this.rightExpr = expr2;
        if (s < 0 || s > additiveOps.size()) {
            throw new InvalidExprException("invalid operator for additive expression");
        }
        this.additiveOp = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        double d = 0.0;
        if (this.leftExpr == null || this.rightExpr == null) {
            return new NumberResult(Double.NaN);
        }
        ExprResult exprResult = null;
        ExprResult exprResult2 = null;
        exprResult2 = this.leftExpr.evaluate(node, processorState);
        exprResult = this.rightExpr.evaluate(node, processorState);
        boolean bl = false;
        d = exprResult.numberValue();
        if (this.additiveOp == 1) {
            d = -d;
        }
        d = exprResult2.numberValue() + d;
        return new NumberResult(d);
    }

    public short getExprType() {
        return 3;
    }

    public static boolean isAdditiveOperator(String string) {
        if (string == null) {
            return false;
        }
        return additiveOps.get(string) != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" ");
        if (this.additiveOp == 1) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        stringBuffer.append(" ");
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

