/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.StringTokenizer;
import org.openxml.util.Resources;
import org.openxml.x3p.Publisher;
import org.openxml.x3p.StreamFormat;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.openxml.x3p.publishers.StreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class StreamPublisher
implements Publisher {
    private StringBuffer _textLine = new StringBuffer(80);
    private StringBuffer _textWord = new StringBuffer(20);
    private int _whiteSpaces;
    private int _thisIndent;
    private int _nextIndent;
    private Writer _writer;
    private StreamFormat _format;

    protected StreamPublisher(StreamPublisherTarget streamPublisherTarget) throws IOException {
        if (streamPublisherTarget == null) {
            throw new NullPointerException(Resources.format("Error001", "target"));
        }
        this._format = streamPublisherTarget.getFormat();
        OutputStream outputStream = streamPublisherTarget.getOutputStream();
        this._writer = outputStream != null ? new StreamWriter(outputStream, this.getFormat().getEncoding()) : new BufferedWriter(streamPublisherTarget.getWriter());
        if (this._writer == null) {
            throw new IllegalArgumentException(Resources.format("Error003", "target"));
        }
    }

    protected final StringBuffer appendLiteral(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("&#22;");
            } else if (string.charAt(n) > '\u007f') {
                stringBuffer.append("&#").append(String.valueOf(string.charAt(n))).append(';');
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    protected final void breakLine() throws IOException {
        while (this._whiteSpaces > 0) {
            this._textLine.append(' ');
            --this._whiteSpaces;
        }
        this._textLine.append((Object)this._textWord);
        this._textWord.setLength(0);
        this.flushLine();
    }

    public final synchronized void close() {
        try {
            this._writer.close();
        }
        catch (IOException iOException) {}
    }

    protected final String encode(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    String string2 = this.getCharacterRef(c);
                    if (string2 == null) {
                        if (c < ' ' || c >= '\u007f') {
                            stringBuffer.append("&#").append(Integer.toString(c)).append(';');
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append('&').append(string2).append(';');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected final void flush() throws IOException {
        this._writer.flush();
    }

    protected final void flushLine() throws IOException {
        if (this._textLine.length() > 0) {
            block7: {
                int n = this._thisIndent;
                if (n > 40) {
                    n = 40;
                }
                while (n-- > 0) {
                    this._writer.write(32);
                }
                this._thisIndent = this._nextIndent;
                try {
                    this._writer.write(this._textLine.toString());
                    while (this._whiteSpaces > 1) {
                        this._writer.write(32);
                        --this._whiteSpaces;
                    }
                    if (this.getFormat().getLineSeparator() == null) {
                        this._writer.write(10);
                        break block7;
                    }
                    this._writer.write(this.getFormat().getLineSeparator());
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this._whiteSpaces = 0;
                    this._textLine.setLength(0);
                    throw throwable;
                }
            }
            Object var3_2 = null;
            this._whiteSpaces = 0;
            this._textLine.setLength(0);
        }
    }

    protected abstract String getCharacterRef(char var1);

    protected final String getEncoding() {
        if (this._writer instanceof StreamWriter) {
            return ((StreamWriter)this._writer).getEncoding();
        }
        return this._format.getEncoding();
    }

    protected final StreamFormat getFormat() {
        return this._format;
    }

    protected final Writer getWriter() {
        return this._writer;
    }

    protected void indent() {
        this.indent(this.getFormat().getIndentSpaces());
    }

    protected final void indent(int n) {
        if (!this.getFormat().isCompact()) {
            this._nextIndent += n;
            if (this._nextIndent < 0) {
                this._nextIndent = 0;
            }
            if (n < 0 && this._textLine.length() + this._whiteSpaces + this._textWord.length() == 0) {
                this._thisIndent = this._nextIndent;
            }
        }
    }

    protected final void printBreak() {
        if (this._textWord.length() > 0) {
            while (this._whiteSpaces > 0) {
                this._textLine.append(' ');
                --this._whiteSpaces;
            }
            this._textLine.append((Object)this._textWord);
            this._textWord.setLength(0);
        }
    }

    protected abstract void printElement(Element var1, StringBuffer var2, boolean var3) throws IOException;

    protected final boolean printNode(Node node, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        switch (node.getNodeType()) {
            case 4: {
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                this.indent();
                String string = node.getNodeValue();
                int n = string.indexOf("]]>");
                if (n >= 0) {
                    stringBuffer.append("<![CDATA[").append(string.substring(0, n)).append("]]>");
                } else {
                    stringBuffer.append("<![CDATA[").append(string).append("]]>");
                }
                this.printWords(stringBuffer, true);
                this.unindent();
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                return this.getFormat().isPretty();
            }
            case 8: {
                if (!this.getFormat().isCompact()) {
                    if (this.getFormat().isPretty()) {
                        this.breakLine();
                    }
                    this.indent();
                    String string = node.getNodeValue();
                    int n = string.indexOf("--");
                    if (n >= 0) {
                        stringBuffer.append("<!--").append(string.substring(0, n)).append("-->");
                    } else {
                        stringBuffer.append("<!--").append(string).append("-->");
                    }
                    this.printWords(stringBuffer, this.getFormat().isPretty());
                    this.unindent();
                    if (this.getFormat().isPretty()) {
                        this.breakLine();
                    }
                    return this.getFormat().isPretty();
                }
                return false;
            }
            case 5: {
                stringBuffer.append('&').append(node.getNodeName()).append(';');
                this.printPart(stringBuffer);
                return false;
            }
            case 7: {
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                this.indent();
                String string = node.getNodeName();
                int n = string.indexOf("?>");
                if (n >= 0) {
                    stringBuffer.append("<?").append(string.substring(0, n));
                } else {
                    stringBuffer.append("<?").append(string);
                }
                stringBuffer.append(' ');
                string = node.getNodeValue();
                n = string.indexOf("?>");
                if (n >= 0) {
                    stringBuffer.append(string.substring(0, n)).append("?>");
                } else {
                    stringBuffer.append(string).append("?>");
                }
                this.printWords(stringBuffer, true);
                this.unindent();
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                return this.getFormat().isPretty();
            }
            case 3: {
                this.printWords(this.encode(node.getNodeValue(), bl), bl);
                return false;
            }
            case 1: {
                this.printElement((Element)node, stringBuffer, bl);
                return false;
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.printNode(node2, bl);
            node2 = node2.getNextSibling();
        }
        return false;
    }

    protected final void printPart(char c) throws IOException {
        this._textWord.append(c);
        this.wrapLine();
    }

    protected final void printPart(String string) throws IOException {
        this._textWord.append(string);
        this.wrapLine();
    }

    protected final void printPart(StringBuffer stringBuffer) throws IOException {
        this._textWord.append((Object)stringBuffer);
        this.wrapLine();
    }

    protected final void printSpace() {
        this.printBreak();
        if (this._whiteSpaces == 0 || !this.getFormat().isCompact()) {
            ++this._whiteSpaces;
        }
    }

    protected final void printWords(String string, boolean bl) throws IOException {
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \f\t\n\r", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (string2.charAt(0)) {
                    case '\t': {
                        this.printPart('\t');
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        this.breakLine();
                        break;
                    }
                    case ' ': {
                        this.printSpace();
                        break;
                    }
                    default: {
                        this.printPart(string2);
                        break;
                    }
                }
            }
        } else {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " \f\t\n\r", false);
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                this.printPart(string3);
            }
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                this.printSpace();
                this.printPart(string3);
            }
        }
    }

    protected final void printWords(StringBuffer stringBuffer, boolean bl) throws IOException {
        this.printWords(stringBuffer.toString(), bl);
    }

    public abstract void publish(Document var1) throws IOException;

    public synchronized void publish(Node node) throws IOException {
        this.printNode(node, this.getFormat().isPreserveSpace());
        this.breakLine();
        this.flush();
    }

    protected void unindent() {
        this.indent(-this.getFormat().getIndentSpaces());
    }

    protected final void wrapLine() throws IOException {
        if (this.getFormat().isPretty() && this.getFormat().getLineWrap() > 0 && this._thisIndent + this._textLine.length() + this._whiteSpaces + this._textWord.length() > this.getFormat().getLineWrap()) {
            this.flushLine();
        }
    }
}

