/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom.iterator;

import org.openxml.dom.NodeImpl;
import org.openxml.dom.iterator.InnerIterator;
import org.openxml.dom.iterator.ListInnerIterator;
import org.openxml.dom.iterator.TreeInnerIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.fi.NodeFilter;
import org.w3c.dom.fi.NodeIterator;

public final class NodeIteratorImpl
implements NodeIterator,
NodeList {
    private NodeFilter _filter;
    private InnerIterator _inner;

    public NodeIteratorImpl(NodeImpl nodeImpl, boolean bl, int n, NodeFilter nodeFilter) {
        this._inner = bl ? new TreeInnerIterator(nodeImpl, n) : new ListInnerIterator(nodeImpl, n);
        this._filter = nodeFilter;
    }

    public InnerIterator asInnerIterator() {
        return this._inner;
    }

    protected void finalize() {
        this._inner.destroy();
        this._inner = null;
        this._filter = null;
    }

    public synchronized int getLength() {
        this._inner.reset();
        int n = 0;
        while (this.nextNode() != null) {
            ++n;
        }
        return n;
    }

    public synchronized Node item(int n) {
        if (n < 0) {
            return null;
        }
        this._inner.reset();
        Node node = this.nextNode();
        while (node != null && n > 0) {
            node = this.nextNode();
            --n;
        }
        return node;
    }

    public synchronized Node nextNode() {
        Node node = this._inner.nextNode();
        if (this._filter != null) {
            while (node != null && !this._filter.acceptNode(node)) {
                node = this._inner.nextNode();
            }
        }
        return node;
    }

    public synchronized Node prevNode() {
        Node node = this._inner.prevNode();
        if (this._filter != null) {
            while (node != null && !this._filter.acceptNode(node)) {
                node = this._inner.prevNode();
            }
        }
        return node;
    }
}

