package com.jtauber.fop.fo.flow;

// FOP
import com.jtauber.fop.fo.*;
import com.jtauber.fop.fo.properties.*;
import com.jtauber.fop.layout.Area;
import com.jtauber.fop.layout.BlockArea;
import com.jtauber.fop.layout.ImageArea;
import com.jtauber.fop.layout.FontState;
import com.jtauber.fop.apps.FOPException;

// Java
import java.util.Enumeration;
import java.util.Hashtable;
import java.net.URL;
import java.awt.image.*;

public class DisplayGraphic extends FObj {
    public static class Maker extends FObj.Maker { 
	public FObj make(FObj parent, PropertyList propertyList)
	    throws FOPException {
	    return new DisplayGraphic(parent, propertyList);
	}
    }

    public static FObj.Maker maker() {
	return new DisplayGraphic.Maker();
    }

    /* it seems silly that I have to do this */
    public static class DGConsumer implements ImageConsumer {
	int width = -1;
	int height = -1;
	public void imageComplete(int status) {}
	public void setColorModel(ColorModel model) {}
	public void setDimensions(int width, int height) {
	    this.width = width;
	    this.height = height;
	}
	public void setHints(int hintflags) {}
	public void setPixels(int x, int y, int w, int h,
			      ColorModel model, byte[] pixels,
			      int off, int scansize) {}
	public void setPixels(int x, int y, int w, int h,
			      ColorModel model, int[] pixels,
			      int off, int scansize) {}
	public void setProperties(Hashtable props) {}
	public int getWidth() { return this.width; }
	public int getHeight() { return this.height; }
    }
    
    public DisplayGraphic(FObj parent, PropertyList propertyList) {
	super(parent, propertyList);
	this.name = "fo:display-graphic";
    }

    public int layout(Area area) throws FOPException {
	// FIXME: doesn't check to see if the image will fit

	int h = 1;
	int w = 1;
	int[] pixels = new int[] { 0xFFFFFF };

	String fontFamily = this.properties.get("font-family").getString();
	String fontStyle = this.properties.get("font-style").getString();
	String fontWeight = this.properties.get("font-weight").getString();
	int fontSize = this.properties.get("font-size").getLength().mvalue();
		
	FontState fs = new FontState(area.getFontInfo(), fontFamily,
				     fontStyle, fontWeight, fontSize); 

	String href = this.properties.get("href").getString();

	try {
	    URL url = new URL(href);
	    ImageProducer ip = (ImageProducer)url.getContent();
	    DGConsumer consumer = new DGConsumer();
	    ip.startProduction(consumer);
	    while ((h = consumer.getHeight())==-1) {}
	    while ((w = consumer.getWidth())==-1) {}
	    pixels = new int[h*w];
	    PixelGrabber pg = new PixelGrabber(ip, 0, 0, w, h, pixels,
					       0, w);
	    pg.grabPixels();
	} catch (ClassCastException e) {
	    System.err.println("Image format not supported: " + href);
	} catch (Exception e) {
	    System.err.println("Error loading image " + href + " : " +
			       e);
	}
	if (area instanceof BlockArea) {
	    area.end();
	}
	ImageArea imageArea = new ImageArea(fs, w/2, h/2, w, h,
					    pixels);
	imageArea.start();
	imageArea.end();
	area.addChild(imageArea);
	area.increaseHeight(imageArea.getHeight());
	if (area instanceof BlockArea) {
	    area.start();
	}
	return OK;
    }
}
