/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.fo.pagination;

import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.fo.FObj;
import com.jtauber.fop.fo.PropertyList;
import com.jtauber.fop.fo.flow.Flow;
import com.jtauber.fop.fo.flow.StaticContent;
import com.jtauber.fop.fo.pagination.LayoutMasterSet;
import com.jtauber.fop.fo.pagination.Root;
import com.jtauber.fop.fo.pagination.SequenceSpecification;
import com.jtauber.fop.layout.AreaContainer;
import com.jtauber.fop.layout.AreaTree;
import com.jtauber.fop.layout.Page;
import com.jtauber.fop.layout.PageMaster;
import com.jtauber.fop.layout.PageMasterFactory;

public class PageSequence
extends FObj {
    protected Root root;
    protected SequenceSpecification sequenceSpecification;
    protected Flow flow;
    protected StaticContent staticBefore;
    protected StaticContent staticAfter;
    protected LayoutMasterSet layoutMasterSet;
    protected Page currentPage;
    protected int currentPageNumber = 0;

    protected PageSequence(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:page-sequence";
        if (!fObj.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + fObj.getName());
        }
        this.root = (Root)fObj;
        this.root.addPageSequence(this);
        this.layoutMasterSet = this.root.getLayoutMasterSet();
    }

    public void format(AreaTree areaTree) throws FOPException {
        int n = 1;
        do {
            AreaContainer areaContainer;
            ++this.currentPageNumber;
            this.currentPage = this.makePage(areaTree);
            System.err.print(" [" + this.currentPageNumber);
            if (this.staticBefore != null && this.currentPage.getBefore() != null) {
                areaContainer = this.currentPage.getBefore();
                this.staticBefore.layout(areaContainer);
            }
            if (this.staticAfter != null && this.currentPage.getAfter() != null) {
                areaContainer = this.currentPage.getAfter();
                this.staticAfter.layout(areaContainer);
            }
            if (!(n == 5 && this.currentPageNumber % 2 == 1 || n == 6 && this.currentPageNumber % 2 == 0)) {
                areaContainer = this.currentPage.getBody();
                n = this.flow.layout(areaContainer);
            }
            System.err.print("]");
            areaTree.addPage(this.currentPage);
        } while (n != 1);
        System.err.println();
    }

    protected Page makePage(AreaTree areaTree) throws FOPException {
        if (this.sequenceSpecification == null) {
            throw new FOPException("page-sequence is missing an sequence-specification");
        }
        PageMasterFactory pageMasterFactory = this.sequenceSpecification.getFirstPageMasterFactory();
        PageMaster pageMaster = pageMasterFactory.getNextPageMaster();
        while (pageMaster == null) {
            if ((pageMasterFactory = pageMasterFactory.getNext()) == null) {
                throw new FOPException("out of sequence specifiers (FOP will eventually allow this)");
            }
            pageMaster = pageMasterFactory.getNextPageMaster();
        }
        return pageMaster.makePage(areaTree);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    protected void setSequenceSpecification(SequenceSpecification sequenceSpecification) {
        this.sequenceSpecification = sequenceSpecification;
        sequenceSpecification.setLayoutMasterSet(this.layoutMasterSet);
    }

    public void setStaticContent(String string, StaticContent staticContent) {
        if (string.equals("xsl-before")) {
            this.staticBefore = staticContent;
        } else if (string.equals("xsl-after")) {
            this.staticAfter = staticContent;
        } else {
            System.err.println("WARNING: this version of FOP only supports static-content in region-before and region-after");
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageSequence(fObj, propertyList);
        }
    }
}

