/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	header.h

	variable definitions and function declarations

*/


#define MAINTITLE	"GXAnim 0.50\0"

/* misc. portability defines */
 
#define I8	unsigned short int
#define I16	unsigned int
#define I32 unsigned long int
#define _NULL (void *)0


/* 
	play states.  these are the values used in control->play->playing to indicate
	the status of the play window.  (note: this is being used to control the
	play process as well as maintain it - setting to AUTOPLAY will attempt to play
	the current selection on the next done_check cycle.)
*/

#define STOPPED 0	/* stopped and waiting to clear into IDLE */
#define PLAYING 1	/* currently playing and open for commands */
#define IDLE 2	/* not playing at all */

/* play commands */

#define NOOP 0	/* null operation */
#define AUTOPLAY 1	/* start playing on next cycle of done_check */


/* 
	the data point where the main play window is stored.  this is the reference that
	the xanim playing clip is projected onto.
*/

#define MOVIE	control->moviewin->screen


/* gtk libraries */

#include <gdk/gdkprivate.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

/* local system libraries */

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <sys/shm.h>

/* X-Windows libraries */

#include <X11/Xlib.h>
#include <X11/Xatom.h>

/* Other GXAnim headers */

#include "gtkmovie.h"
#include "config.h"
#include "windows.h"


/* vars, structs and typedefs */

typedef struct d {
	char *name;

	I8 holdonend;
	I8 floydstein;
	I8 syncframe;
	I8 playonstart;
	I8 verbose;
	I8 volume;

	float scale;
	float gamma;	

	char *rcfile;
	char *xanimprog;
	char *defdir;
} defaults_type;

typedef struct {
	I8 playing;
	I8 playset;
} play;

typedef struct {
	char *type;

	I16 size_x;	
	I16 size_y;
	I16 frames;

	char *version;
} stats;

typedef struct  {

	stats *stats;	/* movie file information */

	defaults_type *movie;  /* movie configuration */
	defaults_type *defaults;	/* program defaults */
	
	/* shared memory */

	key_t shmkey;
	I32 shmid;	/* shared memory id */
	play *play;	/* shared memory segment */
	
	/* shared controls */

	main_win *main;
	prefs_win *pref;
	about_win *about;
	screen_win *moviewin;

	GtkWidget *filew;
	
} xcontrol;


/* function decs */


/* main */

I8 runxanim (xcontrol *control);
void stopxanim (GtkWidget *widget, xcontrol *control);
I8 setxanim (xcontrol *control, char *command);

void quit_event (GtkWidget *widget, xcontrol *control);
void play_event(xcontrol *control);


/* config */

I8 get_config (xcontrol *control);
I8 save_config (GtkWidget *window, xcontrol *control);


/* files */

void showfile (GtkWidget *widget, xcontrol *control);
void getfile (GtkWidget *widget, xcontrol *control);


/* utilities */

void *extr_string (void *line, const char *lvalue, const char *rvalue);
void *val_xanim_file (xcontrol *control);
void *file_only (char *line);
void set_defaults(GtkWidget *widget, xcontrol *control);
void get_prefs (GtkWidget *widget, xcontrol *control);
void exit_pref(GtkWidget *widget, xcontrol *control);
void move_defaults (xcontrol *control);
char *find_home_path (char *buf, char *fname);
void *nospace (char *buf);


/* history functions */

GList *save_history (GList *list, gpointer name);
GList *load_history(GList *list);
void agtk_combo_set_popdown_strings (GtkCombo * combo, GList * strings);

/* x windows functions */

I32 get_xwindow(GtkWidget *widget);
void raise_window(GtkWidget *widget);
void show_window (GtkWidget *widget, GtkWidget *showwidget);
gint hide_window_action (GtkWidget *widget, GtkWidget *hidewidget);
gint hide_window_event (GtkWidget *widget, GdkEvent *event,  GtkWidget *hidewidget);
void size_window(GtkWidget *widget, I16 size_x, I16 size_y);
void move_window(GtkWidget *widget, I16 move_x, I16 move_y);


/* memory */

void *dalloc(void *block, I32 size);
I8 dfree(void *block);


/* control */

void set_play(GtkWidget *widget, xcontrol *control);
void pause_frame (GtkWidget *widget, xcontrol *control);
void frame_up (GtkWidget *widget, xcontrol *control); 
void frame_back (GtkWidget *widget, xcontrol *control);
void mute_sound (GtkWidget *widget, xcontrol *control);
void set_volume (GtkWidget *widget, xcontrol *control);


/* windows */

void make_top_win (main_win *window, xcontrol *control);
GtkWidget *make_filesel (GtkWidget *window, xcontrol *control);
GtkWidget *make_screen (screen_win *window, xcontrol *control);
void make_prefs(prefs_win *window, xcontrol *control);

