/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sarien.h"
#include "gfx.h"
#include "keyboard.h"
#include "menu.h"

AGI_MENU *menu,	*master_menu;

extern UINT16 console_y;
extern UINT8 clock_enabled;


void draw_horizontal_menu_bar (UINT cur_menu, UINT max_menu)
{
	AGI_MENU *men;
	UINT cx, cy, z;

	/* draw our empty title bar */
	for (cy=0; cy < 8; cy++)
		for (cx=0; cx<GFX_WIDTH; cx++)
			put_pixel (cx, cy, MENU_BG);

	/* draw menu titles */
	men = master_menu->next;

	cx = 8;
	for (z = 0; men; z++, men = men->next) {
		if (men->text) {
			if(z == cur_menu) {
				print_text (men->text, 0, cx, 0, 40,
					MENU_BG, MENU_FG);
			} else {
				print_text (men->text, 0, cx, 0, 40,
					MENU_FG, MENU_BG);
			}
			cx += (1 + strlen ((char*)men->text)) * 8;
		}
	}

	gfx->put_block (0, 0, 320, 8);
}


void draw_vertical_menu(UINT h_menu, UINT cur_men, UINT max_men)
{
	/* draw box and verticle pulldowns. */
	UINT cx, cy, x, y, z, l;
	UINT len;
	AGI_MENU *men=master_menu->next;
	AGI_MENU *down;
	UINT8	menu[64];

	/* find which vertical menu it is */
	for (cx = x = 0; x < h_menu; x++) {
		if (men->text && *men->text)
			cx += 1 + strlen ((char*)men->text);
		men = men->next;
	}

	down = men->down;

	len = 0;
	men = down;
	/* scan size of this vertical menu */
	while (men) {
		if (men->text) {
			x = strlen ((char*)men->text);
			if (len < x)
				len = x;
		}
		men=men->down;
	}

	if (len > 40)
		len = 38;
	if (cx + len > 40 && len < 40)
		cx = 38 - len;

	cx *= 8;
	cy = 8;
	draw_box (cx, cy, cx + (8 * (2 + len)), 8 * (2 + max_men),
		MENU_BG, MENU_LINE, LINES);

	men = down;
	x = cx + 8;
	y = cy + 8;

	for (z = 0; men; z++, y += 8, men = men->down) {
		l = strlen ((char*)men->text);
		memmove ((char*)menu, (char*)men->text, l);
		memset ((char*)menu + l, ' ', len - l);
		menu[len] = 0;

		if (z == cur_men)
			print_text (menu, 0, x, y, len + 2, MENU_BG, MENU_FG);
		else
			print_text (menu, 0, x, y, len + 2, MENU_FG, MENU_BG);
	}

	gfx->put_block (cx, cy, cx + (8 * (2 + len)), 8 * (2 + max_men));
}


void init_menus ()
{
	menu = (AGI_MENU*)calloc (1, sizeof (AGI_MENU));
	master_menu = NULL;
}


void deinit_menus ()
{
	/* AGI_MENU *m0, *m1, *m2; */

	/* free all down's then all next's */

	/* FR
	 * Fatal error while freeing the memory
	 */
/*
	while ((m0 = menu->next)) {
		while ((m1 = m0->down)) {
			m2 = m1->down;
			if (m1->text)
				free (m1->text);
			free (m1);
			m1 = m2;
		}
		m1 = m0->next;
		if (m0->text)
			free (m0->text);
		free (m0);
		m0 = m1;
	}
*/
	free (menu);
}


void add_menu (UINT8 *message)
{
	AGI_MENU *m1=menu;

	while (m1->next != NULL)
		m1 = m1->next;

	m1->next = (AGI_MENU*)calloc (1, sizeof(AGI_MENU));
	m1 = m1->next;

	m1->enabled = __TRUE;
	m1->event = 0xFF;
	m1->text = (UINT8*)strdup ((char*)message);
}


void add_menu_item (UINT8 *message, UINT8 code)
{
	AGI_MENU *m1;

	for (m1 = menu; m1->next; m1 = m1->next);
	for (; m1->down; m1 = m1->down);

	m1->down = (AGI_MENU*)calloc (1, sizeof(AGI_MENU));
	m1 = m1->down;

	m1->enabled = __TRUE;
	m1->event = code;
	m1->text = (UINT8*)strdup((char*)message);
}


void submit_menu ()
{
	master_menu = menu;
}


void do_menus(void)
{
	UINT h_cur_menu = 0;
	UINT h_max_menu = 0;
	UINT v_cur_menu = 0;
	UINT v_max_menu = 0;
	UINT x;
	AGI_MENU *men;
	UINT8 clock_val;

	clock_val = clock_enabled;
	clock_enabled = __FALSE;

	save_screen ();
	redraw_sprites ();
	gfx->put_block (0, 0, 319, console_y);

	/* calc size of horizontal menu */
	for (men = master_menu->next; men; h_max_menu++, men=men->next);

 	/* calc size of vertical menus */
   	for (x = 0, men = master_menu->next; x < h_cur_menu; x++)
   		men = men->next;
   	for (v_max_menu = 0; men; v_max_menu++, men = men->down);

   	draw_horizontal_menu_bar (h_cur_menu, h_max_menu);
   	draw_vertical_menu (h_cur_menu, v_cur_menu, v_max_menu);

	while (42)
	{
		main_cycle (__FALSE);

    		switch (key) {
    		case KEY_ESCAPE:
			goto exit_menu;
    		case KEY_ENTER:
    			men = master_menu->next;
    			for (x = 0; x < h_cur_menu; x++, men = men->next);
    			men = men->down;
    			for (x = 0; x < v_cur_menu; x++, men=men->down);
    			if (men->enabled) {
    				events[men->event].occured = __TRUE;
				goto exit_menu;
    			}
    			break;
    		case KEY_DOWN:
    			if (1 + v_cur_menu >= v_max_menu - 1)
				break;
    		    	v_cur_menu++;
			draw_vertical_menu (h_cur_menu, v_cur_menu, v_max_menu);
    			break;
    		case KEY_UP:
    			if(v_cur_menu <= 0)
				break;
    			v_cur_menu--;
    			draw_vertical_menu (h_cur_menu, v_cur_menu, v_max_menu);
    			break;
    		case KEY_RIGHT:
    			if (1 + h_cur_menu >= h_max_menu)
				break;
    			h_cur_menu++;
			release_sprites ();
			restore_screen_area ();
			redraw_sprites ();
			gfx->put_block (0, 0, 319, console_y);
			/* calc size of vertical menus */
			for(x = 0, men = master_menu->next; x<h_cur_menu; x++)
				men=men->next;
			for (v_max_menu = 0; men; v_max_menu++, men=men->down);
			v_cur_menu = 0;
			draw_horizontal_menu_bar (h_cur_menu, h_max_menu);
    			draw_vertical_menu (h_cur_menu, v_cur_menu, v_max_menu);
    			break;
    		case KEY_LEFT:
    			if (h_cur_menu <= 0)
				break;
    			h_cur_menu--;
			release_sprites ();
			restore_screen_area ();
			redraw_sprites ();
			gfx->put_block (0, 0, 319, console_y);
			/* calc size of vertical menus */
			for (x = 0, men = master_menu->next; x<h_cur_menu; x++)
				men=men->next;
			for (v_max_menu = 0; men; v_max_menu++, men=men->down);
			v_cur_menu = 0;
			draw_horizontal_menu_bar (h_cur_menu, h_max_menu);
    			draw_vertical_menu (h_cur_menu, v_cur_menu, v_max_menu);
    			break;
    		}
    	}
exit_menu:

	release_sprites ();
	restore_screen ();

	setvar (V_key, 0);
	clock_enabled = clock_val;
}

