#ifndef CW_WINDOW_H
#define CW_WINDOW_H

#include <string>
#include <gtk--/window.h>

class CWText;
class Gtk_VBox;
class Gtk_HBox;
class Gtk_Button;

class CWWindow : public Gtk_Window
{
public:

  CWWindow();
  virtual ~CWWindow();

protected:

  virtual void RewCB();
  virtual void PrevCB();
  virtual void NextCB();
  virtual void FfCB();
  virtual void AboutCB();
  virtual void ExitCB();

  virtual void FileLoadedCB(const string& fileName);

  virtual gint delete_event_impl(GdkEventAny* p1);

private:

  void GetCraftyLogPath();
  void GlobForMaxMin();
  int GetFileNumber(const string& fileName);
  gint InitialLoadFileCB();
  void LoadFile(const string& fileName, bool waitUntilAtEnd = false);

  string CreateFileName(int n);
  string GetBaseName(const string& baseName);


  gint TickCB();
  void CheckForNewFile();
  void RugPulledOutFromUnder();


  // gui
  Gtk_VBox* _vbox;
  CWText* _text;
  Gtk_HBox* _buttonBox;
  Gtk_Button* _rewButton;
  Gtk_Button* _prevButton;
  Gtk_Button* _nextButton;
  Gtk_Button* _ffButton;
  Gtk_Button* _aboutButton;
  Gtk_Button* _exitButton;

  string _craftyLogPath;
  string _baseStr;
  string _globPattern;
  string _newFileName;

  int _n;      // Current file number
  int _nMax;   // Max file number
  int _nMin;   // Min file number

  Connection _tick;
};

#endif  /*  CW_WINDOW_H  */
