/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Protocol;

public class Jdebug
extends Thread
implements Protocol {
    public static final Integer my_id = new Integer(-1);
    BufferedReader in;
    PrintWriter out = new PrintWriter(System.out);
    Map applications;
    private Collection pendingCommands;

    private void setSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(true);
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            StreamTokenizer st = new StreamTokenizer(this.in);
            this.setSyntax(st);
            int ttype = st.nextToken();
            while (ttype != -1) {
                try {
                    ArrayList<String> commandLine = new ArrayList<String>();
                    while (ttype != 10) {
                        if (ttype == -1) {
                            throw new IOException("I/O EOF occured");
                        }
                        if (ttype == -3) {
                            commandLine.add(st.sval);
                        } else if (ttype == 34 || ttype == 39) {
                            commandLine.add(st.sval);
                        } else {
                            commandLine.add(String.valueOf((char)ttype));
                        }
                        ttype = st.nextToken();
                    }
                    if (commandLine.size() < 3) {
                        if (commandLine.size() > 0) {
                            this.signalCommandError(my_id, new Integer(-1), "Malformed command");
                        }
                        ttype = st.nextToken();
                        continue;
                    }
                    Integer app_id = Integer.valueOf(commandLine.get(0).toString());
                    Integer cmd_id = Integer.valueOf(commandLine.get(1).toString());
                    String command = commandLine.get(2).toString().toLowerCase();
                    List arguments = commandLine.subList(3, commandLine.size());
                    Jdebug jdebug = this;
                    if (jdebug == null) {
                        throw null;
                    }
                    Thread thread = new Thread(jdebug, app_id, cmd_id, command, arguments, "Executing (" + app_id + "," + cmd_id + ")"){
                        private final /* synthetic */ Jdebug this$0;
                        private final /* synthetic */ Integer val$app_id;
                        private final /* synthetic */ Integer val$cmd_id;
                        private final /* synthetic */ String val$command;
                        private final /* synthetic */ List val$arguments;

                        public void run() {
                            if (this.val$app_id.equals(my_id)) {
                                Jdebug.access$0(this.this$0, this.val$cmd_id, this.val$command, this.val$arguments);
                            } else {
                                Jdebug.access$1(this.this$0, this.val$app_id, this.val$cmd_id, this.val$command, this.val$arguments);
                            }
                        }
                        {
                            this.val$app_id = val$app_id;
                            this.val$cmd_id = val$cmd_id;
                            this.val$command = val$command;
                            this.val$arguments = val$arguments;
                            this.this$0 = this$0;
                            this.constructor$0(this$0, $1);
                        }

                        private final void constructor$0(Jdebug jdebug, String $1) {
                        }
                    };
                    thread.start();
                }
                catch (IOException ex) {
                }
                catch (Exception ex) {
                    this.signalCommandError(my_id, new Integer(-1), "Malformed command: " + ex.toString());
                }
                ttype = st.nextToken();
            }
            Object var2_14 = null;
            try {
                this.shutdown();
            }
            catch (Exception exception) {}
            break block21;
            {
                catch (IOException ex) {
                    Object var2_15 = null;
                    try {
                        this.shutdown();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var2_16 = null;
                try {
                    this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void handleGeneralCommand(Integer cmd_id, String command, List arguments) {
        Collection collection;
        Collection collection2 = this.pendingCommands;
        synchronized (collection2) {
            if (this.pendingCommands.contains(cmd_id)) {
                this.signalCommandError(my_id, new Integer(-1), "Duplicate cmd_id '" + cmd_id + "'");
                Object var5_6 = null;
                return;
            }
            this.pendingCommands.add(cmd_id);
        }
        try {
            block24: {
                if (command.equals("launch")) {
                    this.doLaunch(cmd_id, arguments);
                    break block24;
                }
                if (command.equals("attach_socket")) {
                    this.doAttach(command, cmd_id, arguments);
                    break block24;
                }
                if (command.equals("attach_shmem")) {
                    this.doAttach(command, cmd_id, arguments);
                    break block24;
                }
                if (command.equals("listen_socket")) {
                    this.doListen(command, cmd_id, arguments);
                    break block24;
                }
                if (command.equals("listen_shmem")) {
                    this.doListen(command, cmd_id, arguments);
                    break block24;
                }
                if (command.equals("quit") || command.equals("exit")) {
                    this.doQuit(cmd_id, arguments);
                    break block24;
                }
                this.signalCommandError(my_id, cmd_id, "'" + command + "' is not supported");
            }
            Object var5_7 = null;
            collection = this.pendingCommands;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            Collection collection3 = this.pendingCommands;
            synchronized (collection3) {
                this.pendingCommands.remove(cmd_id);
            }
            throw throwable;
        }
        synchronized (collection) {
            this.pendingCommands.remove(cmd_id);
        }
        {
            catch (JDEException ex) {
                this.signalCommandError(my_id, cmd_id, ex.getMessage());
                Object var5_8 = null;
                Collection collection4 = this.pendingCommands;
                synchronized (collection4) {
                    this.pendingCommands.remove(cmd_id);
                }
                return;
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.signalCommandError(my_id, cmd_id, "Unspecified error: " + ex.toString());
                Object var5_9 = null;
                Collection collection5 = this.pendingCommands;
                synchronized (collection5) {
                    this.pendingCommands.remove(cmd_id);
                }
                return;
            }
        }
    }

    private void handleAppCommand(Integer app_id, Integer cmd_id, String command, List arguments) {
        Application app;
        Map map = this.applications;
        synchronized (map) {
            if (!this.applications.containsKey(app_id)) {
                this.signalCommandError(my_id, cmd_id, "Application ID '" + app_id + "' does not exist");
                Object var7_6 = null;
                return;
            }
        }
        map = this.applications;
        synchronized (map) {
            app = (Application)this.applications.get(app_id);
            if (app == null) {
                this.signalCommandError(my_id, cmd_id, "Application ID '" + app_id + "' does not correspond to a valid application");
            }
        }
        app.handleCommand(cmd_id, command, arguments);
    }

    private void initApplication(String category, Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing application ID");
        }
        Integer app_id = new Integer(Etc.safeGetint(args.remove(0), "application ID"));
        if (app_id.equals(my_id)) {
            throw new JDEException("Invalid Application ID");
        }
        Map map = this.applications;
        synchronized (map) {
            if (this.applications.containsKey(app_id)) {
                throw new JDEException("Application ID is duplicate");
            }
        }
        Application app = new Application(this, app_id);
        int port = app.initialize(category, args);
        map = this.applications;
        synchronized (map) {
            if (this.applications.containsKey(app_id)) {
                app.shutdown();
                throw new JDEException("A new application with the same ID exists: things will go miserably wrong!");
            }
            this.applications.put(app_id, app);
        }
        this.signalCommandResult(my_id, cmd_id, new Integer(port));
    }

    private void doLaunch(Integer cmd_id, List args) throws JDEException {
        this.initApplication("launch", cmd_id, args);
    }

    private void doAttach(String type, Integer cmd_id, List args) throws JDEException {
        this.initApplication(type, cmd_id, args);
    }

    private void doListen(String type, Integer cmd_id, List args) throws JDEException {
        this.initApplication(type, cmd_id, args);
    }

    private void doQuit(Integer cmd_id, List arguments) throws JDEException {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.signalCommandResult(my_id, cmd_id);
        System.exit(0);
    }

    public void removeApplication(Integer app_id) {
        Map map = this.applications;
        synchronized (map) {
            this.applications.remove(app_id);
        }
    }

    private void shutdown() throws JDEException {
        Map map = this.applications;
        synchronized (map) {
            Iterator iterator = this.applications.values().iterator();
            while (iterator.hasNext()) {
                ((Application)iterator.next()).shutdown();
                iterator.remove();
            }
        }
    }

    public String stringRep(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return "\"" + obj.toString() + "\"";
        }
        if (obj instanceof List) {
            StringBuffer returnString = new StringBuffer("");
            Iterator it = ((List)obj).iterator();
            while (it.hasNext()) {
                returnString.append(this.stringRep(it.next()) + " ");
            }
            return Protocol.BR + returnString.toString().trim();
        }
        return obj.toString();
    }

    public synchronized void signal(Integer app_id, String type, Object obj) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            this.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + ")" + Protocol.BR);
        } else {
            String temp = "(jde-dbo-" + type + Protocol.BR + app_id + " " + this.stringRep(obj) + ")";
            if (temp.length() <= 80) {
                this.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + " " + this.stringRep(obj) + ")" + Protocol.BR);
            } else {
                this.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        this.out.flush();
    }

    private synchronized void signalReply(Integer app_id, Integer cmd_id, Object obj, String type) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            this.out.println(Protocol.BR + "(" + type + " " + cmd_id + ")" + Protocol.BR);
        } else {
            String temp = "(" + type + Protocol.BR + cmd_id + " " + strRep + ")";
            if (temp.length() <= 80) {
                this.out.println(Protocol.BR + "(" + type + " " + cmd_id + " " + strRep + ")" + Protocol.BR);
            } else {
                this.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        this.out.flush();
    }

    public void signalCommandResult(Integer app_id, Integer cmd_id) {
        this.signalCommandResult(app_id, cmd_id, null);
    }

    public synchronized void signalCommandResult(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-result");
    }

    public synchronized void signalCommandError(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-error");
    }

    static /* synthetic */ void access$0(Jdebug jdebug, Integer n, String string, List list) {
        jdebug.handleGeneralCommand(n, string, list);
    }

    static /* synthetic */ void access$1(Jdebug jdebug, Integer n, Integer n2, String string, List list) {
        jdebug.handleAppCommand(n, n2, string, list);
    }

    public Jdebug() throws IOException {
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.applications = Collections.synchronizedMap(new HashMap());
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
    }
}

