/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.Etc;
import jde.debugger.LispForm;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.ThreadCommands;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.WatchpointSpec;

public class EventHandler
implements Runnable,
Protocol {
    boolean connected = true;
    final Application app;
    final Integer my_id;
    final Thread thread;
    boolean completed = false;
    boolean resumeApp;

    public void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        EventQueue queue = this.app.getEventQueue();
        while (this.connected) {
            try {
                String suspendStateString;
                EventSet eventSet = queue.remove();
                this.resumeApp = true;
                ArrayList<LispForm> events = new ArrayList<LispForm>();
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    LispForm sendLispForm = this.handleEvent(it.nextEvent());
                    if (sendLispForm == null) continue;
                    events.add(sendLispForm);
                }
                if (events.size() == 0) {
                    eventSet.resume();
                    continue;
                }
                if (this.resumeApp) {
                    suspendStateString = "none";
                    eventSet.resume();
                } else {
                    switch (eventSet.suspendPolicy()) {
                        case 2: {
                            suspendStateString = "all";
                            break;
                        }
                        case 1: {
                            suspendStateString = "thread";
                            break;
                        }
                        case 0: {
                            suspendStateString = "none";
                            eventSet.resume();
                            break;
                        }
                        default: {
                            suspendStateString = "invalid";
                            break;
                        }
                    }
                }
                String eventSetString = "\"" + suspendStateString + "\"";
                ThreadReference eventThread = this.getCurrentThread(eventSet);
                eventSetString = eventThread == null ? eventSetString + " nil" : eventSetString + Protocol.BR + Rep.getThreadRep(eventThread, this.app.getStore());
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    eventSetString = eventSetString + Protocol.BR + iter.next();
                }
                this.app.signal("event-set", new LispForm(eventSetString));
            }
            catch (InterruptedException ex) {
            }
            catch (VMDisconnectedException ex) {
                Debug.printIf(ex);
                this.handleDisconnectedException();
            }
        }
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private LispForm handleEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent((BreakpointEvent)event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent((StepEvent)event);
        }
        if (event instanceof WatchpointEvent) {
            return this.watchpointEvent((WatchpointEvent)event);
        }
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent((ExceptionEvent)event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.threadStartEvent((ThreadStartEvent)event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.threadDeathEvent((ThreadDeathEvent)event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.methodEntryEvent((MethodEntryEvent)event);
        }
        if (event instanceof MethodExitEvent) {
            return this.methodExitEvent((MethodExitEvent)event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent((ClassPrepareEvent)event);
        }
        if (event instanceof VMStartEvent) {
            return this.vmStartEvent((VMStartEvent)event);
        }
        if (event instanceof VMDeathEvent) {
            return this.vmDeathEvent((VMDeathEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            return this.vmDisconnectEvent((VMDisconnectEvent)event);
        }
        return this.otherEvent(event);
    }

    private LispForm otherEvent(Event event) {
        this.resumeApp &= true;
        return new LispForm("(list 'jde-dbo-event-other)");
    }

    private void handleDisconnectedException() {
        EventQueue queue = this.app.getEventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    Event evt = (Event)iter.next();
                    if (evt instanceof VMDeathEvent) {
                        this.vmDeathEvent(evt);
                        continue;
                    }
                    if (!(evt instanceof VMDisconnectEvent)) continue;
                    this.vmDisconnectEvent(evt);
                }
            }
            catch (InterruptedException ex) {
                Debug.printIf(ex);
            }
        }
    }

    private ThreadReference getCurrentThread(EventSet eventSet) {
        ThreadReference thread;
        if (eventSet.size() > 0) {
            Event event = (Event)eventSet.iterator().next();
            ThreadReference threadReference = this.getEventThread(event);
        } else {
            thread = null;
        }
        return thread;
    }

    private ThreadReference getEventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private String threadMatch(Event event) {
        Object thread = event.request().getProperty(EventRequestSpec.threadKey);
        if (thread == null) {
            return "nil";
        }
        if (thread instanceof Long) {
            ThreadReference t = this.getEventThread(event);
            if (t.uniqueID() == ((Long)thread).longValue()) {
                return "(list \"on_thread_id\" " + t.uniqueID() + ")";
            }
            return null;
        }
        if (thread instanceof String) {
            ThreadReference tRef = ThreadCommands.getThread(this.app.getVM(), thread.toString());
            ThreadReference t = this.getEventThread(event);
            if (t.equals(tRef)) {
                return "(list \"on_thread_name\"" + " \"" + thread.toString() + "\")";
            }
            return null;
        }
        return "\"Error matching thread\"";
    }

    private String expressionSuccess(Event event) {
        Object exprObject = event.request().getProperty(EventRequestSpec.expressionKey);
        if (exprObject != null) {
            String expr = exprObject.toString();
            try {
                StackFrame frame = this.getEventThread(event).frame(0);
                Value val = Etc.evaluate(expr, frame);
                if (!val.type().name().equals("boolean")) {
                    return "\"Expression evaluates to non-boolean\"";
                }
                BooleanValue boolValue = (BooleanValue)val;
                if (boolValue.value()) {
                    return "(list \"" + expr + "\")";
                }
                return null;
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                return "\"Expression didn't evaluate correctly\"";
            }
        }
        return "nil";
    }

    private String objectIDMatches(WatchpointEvent event) {
        Object idObject = event.request().getProperty(WatchpointSpec.objectIDKey);
        if (idObject == null) {
            return "nil";
        }
        if (idObject instanceof Long) {
            Long id = (Long)idObject;
            if (event.object() == null) {
                return "(list " + id + ")";
            }
            if (event.object().uniqueID() == id.longValue()) {
                return "(list " + id + ")";
            }
            return null;
        }
        return "\"Object ID was not a Long\"";
    }

    private LispForm breakpointEvent(BreakpointEvent event) {
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        String threadString = this.threadMatch(event);
        if (threadString == null) {
            this.resumeApp &= true;
            return null;
        }
        String exprString = this.expressionSuccess(event);
        if (exprString == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-breakpoint-hit-event " + specID + Protocol.BR + Rep.getLocationRep(event.location()) + " " + threadString + " " + exprString + ")");
    }

    private LispForm stepEvent(StepEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-step-event " + Rep.getLocationRep(event.location()) + ")");
    }

    private LispForm watchpointEvent(WatchpointEvent event) {
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        String threadString = this.threadMatch(event);
        if (threadString == null) {
            this.resumeApp &= true;
            return null;
        }
        String exprString = this.expressionSuccess(event);
        if (exprString == null) {
            this.resumeApp &= true;
            return null;
        }
        String objectIDString = this.objectIDMatches(event);
        if (objectIDString == null) {
            this.resumeApp &= true;
            return null;
        }
        String fieldValueString = Rep.getFieldValueRep(event.field(), event.valueCurrent(), this.app.getStore()).toString();
        String objectString = Rep.getObjectRep(event.object(), this.app.getStore()).toString();
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-watchpoint-hit-event " + specID + Protocol.BR + objectString + Protocol.BR + fieldValueString + Protocol.BR + Rep.getLocationRep(event.location()) + Protocol.BR + objectIDString + " " + threadString + " " + exprString + ")");
    }

    private LispForm exceptionEvent(ExceptionEvent event) {
        if (event.request() == null) {
            this.resumeApp &= true;
            return null;
        }
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        ExceptionRequest request = (ExceptionRequest)event.request();
        String threadString = this.threadMatch(event);
        if (threadString == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-exception-event " + specID + Protocol.BR + Rep.getObjectRep(event.exception(), this.app.getStore()) + Protocol.BR + threadString + ")");
    }

    private LispForm methodEntryEvent(MethodEntryEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-method-entry-event" + Protocol.BR + Rep.getMethodRep(event.method()) + ")");
    }

    private LispForm methodExitEvent(MethodExitEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-method-exit-event" + Protocol.BR + Rep.getMethodRep(event.method()) + ")");
    }

    private LispForm threadStartEvent(ThreadStartEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-thread-start-event" + Protocol.BR + Rep.getThreadRep(event.thread(), this.app.getStore()) + ")");
    }

    private LispForm threadDeathEvent(ThreadDeathEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-thread-death-event" + Protocol.BR + Rep.getThreadRep(event.thread(), this.app.getStore()) + ")");
    }

    private LispForm classPrepareEvent(ClassPrepareEvent event) {
        this.app.resolve(event.referenceType());
        EventRequest request = event.request();
        if (request.getProperty("default") == null) {
            this.resumeApp &= false;
            return new LispForm("(list 'jde-dbo-class-prepare-event \"" + event.referenceType().name() + "\")");
        }
        this.resumeApp &= true;
        return null;
    }

    private LispForm classUnloadEvent(ClassUnloadEvent event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-class-unload-event \"" + event.className() + "\")");
    }

    private LispForm vmStartEvent(Event event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-vm-start-event)");
    }

    private LispForm vmDeathEvent(Event event) {
        this.resumeApp &= true;
        return new LispForm("(list 'jde-dbo-vm-death-event)");
    }

    private LispForm vmDisconnectEvent(Event event) {
        this.connected = false;
        this.resumeApp &= true;
        this.app.shutdown();
        return new LispForm("(list 'jde-dbo-vm-disconnected-event)");
    }

    public EventHandler(Application app) {
        this.app = app;
        this.my_id = app.getId();
        this.thread = new Thread((Runnable)this, "Event Handler for App #" + this.my_id);
        this.thread.start();
    }
}

