//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//
#include "termmeter.h"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

//------------------  term stuff  -----------------------------------------
#define I_CTYPE
#define I_MEMORY
#define I_TIMES
#define I_TTY
#define I_TYPE
#define I_SYS
#define I_STAT
#define I_SIGNAL
#define I_PARAM

extern "C"
{
#include "includes.h"
#include "client.h"
}

#ifndef HZ
#define HZ 60
#endif


#define NULLS ((char *)0)

//---------------------------- end term stuff ---------------------------


// I am not sure what all of these are for but they should probably be
// moved into functions as local variables, turned into data members or
// static data members.
unsigned int scale;
unsigned long packet_timeout;
int last_recv = -1, last_ack = -1, last_in, last_out = -1;
int max_cps, window_size;
float dtim;
struct tms Tbuf;



// static data bound to a TermMeter ( used by child classes )
float TermMeter::incoming_[2];
float TermMeter::outgoing_[2];
Timer TermMeter::timer_( 1 );
int TermMeter::index_ = 0;
int TermMeter::termsocket_ = 0;
float TermMeter::lastinterval_;



// -----------------------------------------------------------------------
//  I think that the following code is meant to find the maximum value
//  in characters per second.  If so, It should probably be moved into
//  a function such as :
//  float TermMeter::maxcps( void );  // returns max char / sec
// 
//  which then could be used by TermInMeter and TermOutMeter to set their
//  maxpackets_ data member.  It may be that one can not find out the
//  max char / sec from term.  In this case I could have this value read in
//  as a command line argument such as is done for the netmeters.
//------------------------------------------------------------------------
// #ifdef TERM
//       STAT ( 1, -5);
//       sscanf(command_result,"%u %d %lu",&max_cps,&window_size,&packet_timeout);
//       netmax_ = max_cps + 10;
//       scale = max_cps + 10;
// 
// /* get the last_recv/last_ack etc data */
//       STAT ( 1, -3);
//       sscanf ( command_result, "%d %d %d %d", &last_recv, &last_ack,
// 	       &last_in, &last_out );
//       stim=times(&Tbuf);
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Constructor.
// run when any TermMeter is brought into being.
// This function should run once for a TermInMeter and once for a
// TermOutMeter so we will only try and connect to term once.
//-----------------------------------------------------------------------
TermMeter::TermMeter( void ){
  // is term running?
  // if term is running but not connected itself then connect_server()
  // will call exit() :-(
  // if termsocket_ != 0 we assume that a connection has allready been made
  if ( !termsocket_ )
    if (!(termsocket_ = connect_server(term_server)))
      cout << "Failed to open term connection." << endl;
    else
      cout << "Using term connection." << endl;

  // initialize incoming_ and outgoing_ by calling checkevent four times.
  for ( int i = 0 ; i < 4 ; i++ )
    checkevent();
}

TermMeter::~TermMeter( void ){
}


// used to be a MACRO now we have some stronger type checking
void TermMeter::stat( int local, int st ){
  if (send_command(termsocket_, (int) C_STATS, local, "%d", st)< 0) {
    cerr <<"C_STATS command failed. Abort." <<endl;
    exit( 1 );
  }
}
     
void TermMeter::checkevent( void ){
  static int pass = 0;
  static int stim, ttim;
  
  // only run every other cycle in the loop
  // (TermInMeter and TermOutMeter will use the same numbers)
  pass = (pass + 1)%2;
  if ( !pass )
    return;
  
  if (termsocket_)  // check for a valid term "socket"
    {
      int  d1, d2, d3, d4;  

      stat( 1, -3);
      sscanf ( command_result, "%d %d %d %d", &d1, &d2, &d3, &d4);

      ttim=times(&Tbuf); 
      dtim=((float)(ttim-stim) * HZ ) / 10000.0; 
      stim=ttim; 

      // find interval in usec since last time we fetched data.
      timer_.stop();
      lastinterval_ = timer_.report();  // interval in usec.
      timer_.start();

      // incoming_ and outgoing_ are arrays which each contain two
      // elements.  The current and previous total number of packets
      // were stored in these in the NetMeter class.  index_ was used to
      // "shift" the meaning of each element from current to previous.
      // for example, the first time this function runs index_ will be
      // set to 0.  This makes incoming_[0] the current total number of
      // recieved packets to date and incoming_[1] the previous total
      // number of packets to date.  index_ is then set to 1 which will
      // "reverse" the situation on the next pass through this code.
      // the two functions incoming() and outgoing() then can use these
      // values to calculate the number of packets per second recieved durring
      // the lastinterval_.
      // If term can tell you directly the number of chars per second then
      // this class really only needs to have the two functions incoming()
      // and outgoing() return the appropriate values.  So it may be possible
      // that this function is not needed at all.
      incoming_[index_]=(int)((d1-last_recv)/dtim);
      outgoing_[index_]=(int)((d2-last_ack)/dtim);
      index_ = (index_ + 1) % 2;
      last_recv=d1;last_ack=d2;last_in=d3;last_out=d4;
    }
}


