/*--------------------------------*-C-*---------------------------------*
 * File:	graphics.h
 *
 * function declarations for graphics.c, only to be included by the rxvt
 * source itself.
 * To use graphics in external programs only include "rxvt_graphics.h"
 *----------------------------------------------------------------------*/
#ifndef _GRAPHICS_H
#define _GRAPHICS_H

#include "rxvt_grx.h"		/* text alignment */

extern int graphics_up;

#ifdef __cplusplus
extern "C" {
#endif
   extern void	Gr_do_graphics (char c, int nargs, long *args, unsigned char *text);
   extern void	Gr_ButtonReport (char ch, int x, int y);
#define Gr_ReportButtonRelease(x,y)	Gr_ButtonReport('R',(x),(y))
#define Gr_ReportButtonPress(x,y)	Gr_ButtonReport('P',(x),(y))
   extern void	Gr_scroll (int count);
   extern void	Gr_ChangeScreen (void);
   extern void	Gr_ClearScreen (void);
   extern void	Gr_reset (void);
   extern void	Gr_expose (Window win);
   extern void	Gr_Resize (int w, int h);
#ifdef __cplusplus
}
#endif
#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
