#! /bin/sh
##  $Revision: 1.6 $
##  Script to make INN directories.

##  Some systems don't support -x, so we have to use -f.
CHOWN=chown
if [ ${CHOWN} = chown ] ; then
    if [ -f /etc/chown ] ; then
	CHOWN=/etc/chown
    else
	if [ -f /usr/etc/chown ] ; then
	    CHOWN=/usr/etc/chown
	fi
    fi
fi

##  =()<MAN1=$prefix@<MAN1>@>()=
MAN1=$prefix/usr/local/man/man1
##  =()<MAN3=$prefix@<MAN3>@>()=
MAN3=$prefix/usr/local/man/man3
##  =()<MAN5=$prefix@<MAN5>@>()=
MAN5=$prefix/usr/local/man/man5
##  =()<MAN8=$prefix@<MAN8>@>()=
MAN8=$prefix/usr/local/man/man8

##  =()<SPOOL=$prefix@<_PATH_SPOOL>@>()=
SPOOL=$prefix/news/spool
##  =()<ARCHIVEDIR=$prefix@<_PATH_ARCHIVEDIR>@>()=
ARCHIVEDIR=$prefix/news/spool/news.archive
##  =()<BATCHDIR=$prefix@<_PATH_BATCHDIR>@>()=
BATCHDIR=$prefix/news/spool/out.going
##  =()<MOST_LOGS=$prefix@<_PATH_MOST_LOGS>@>()=
MOST_LOGS=$prefix/var/log/news
## =()<PATH_AUTHDIR=$prefix@<_PATH_AUTHDIR>@>()=
PATH_AUTHDIR=$prefix/news/bin/auth.dir
##  =()<SPOOLNEWS=$prefix@<_PATH_SPOOLNEWS>@>()=
SPOOLNEWS=$prefix/var/spool/rnews
##  =()<BADNEWS=$prefix@<_PATH_BADNEWS>@>()=
BADNEWS=$prefix/var/spool/rnews/bad
##  =()<SPOOLTEMP=$prefix@<_PATH_SPOOLTEMP>@>()=
SPOOLTEMP=$prefix/var/spool/rnews/tmp

##  =()<NEWSLIB=$prefix@<_PATH_NEWSLIB>@>()=
NEWSLIB=$prefix/news/lib
##  =()<NEWSBIN=$prefix@<_PATH_NEWSBIN>@>()=
NEWSBIN=$prefix/news/bin
##  =()<CONTROLPROGS=$prefix@<_PATH_CONTROLPROGS>@>()=
CONTROLPROGS=$prefix/news/bin/control
##  =()<RNEWSPROGS=$prefix@<_PATH_RNEWSPROGS>@>()=
RNEWSPROGS=$prefix/news/bin/rnews
##  =()<INNDDIR=$prefix@<_PATH_INNDDIR>@>()=
INNDDIR=$prefix/news/lib/innd
##  =()<LOCKSDIR=$prefix@<_PATH_LOCKS>@>()=
LOCKSDIR=$prefix/news/lib
## =()<MOST_LOGS=$prefix@<_PATH_MOST_LOGS>@>()=
MOST_LOGS=$prefix/var/log/news

##  =()<NEWSUSER=@<NEWSUSER>@>()=
NEWSUSER=news
##  =()<NEWSGROUP=@<NEWSGROUP>@>()=
NEWSGROUP=news

PFLAG="$1"
umask 0
set -x

for F in \
${MAN1} ${MAN3} ${MAN5} ${MAN8} \
${SPOOL} ${ARCHIVEDIR} ${BATCHDIR} ${MOST_LOGS} ${MOST_LOGS}/OLD \
${SPOOLNEWS} ${BADNEWS} ${SPOOLTEMP} \
${NEWSLIB} ${INNDDIR} ${LOCKSDIR} \
${NEWSBIN} ${CONTROLPROGS} ${RNEWSPROGS} \
${PATH_AUTHDIR} ; do

    if [ ! -d ${F} ] ; then
	mkdir ${PFLAG} ${F} || exit 1
	${CHOWN} ${NEWSUSER} ${F} || exit 1
	chgrp ${NEWSGROUP} ${F} || exit 1
	case ${F} in
	${INNDDIR})
	    chmod 0770 ${F} || exit 1
	    ;;
	*)
	    chmod 0775 ${F} || exit 1
	    ;;
	esac
    fi

done

exit 0
