#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/misc.tcl,v $
# $Date: 1996/03/21 12:38:37 $
# $Revision: 1.16.1.24 $
#
proc credits {} {
    global zircon tk_patchLevel
    mkInfoBox {} .@credits "Zircon Credits" "The Zircon IRC Client
Version $zircon(version) Patchlevel: $zircon(patchlevel)

Brought to you by Lindsay (from an original idea by Jimbles)

Thanks to:

Sorry, too many people to mention. You know who you are and I
appreciate all your help.

e-mail for problems : zircon@catless.ncl.ac.uk

To join mailing list : zircon-request@newcastle.ac.uk

Web Page : http://catless.ncl.ac.uk/Programs/Zircon

tcl Version [info patchlevel]
tk Version $tk_patchLevel
[version]" {Dismiss {}}
}
#
proc doLimit {net chan string} {
    if {$string == {0}} { unlimit $net $chan } { $net MODE $chan +l $string}
}
#
proc unlimit {net chan args} { $net MODE ${chan} -l }
#
proc channel_setLimit {this} {
    set chan [$this name]
    set net [$this net]
    mkEntryBox .@limit "Limit" "Enter limit value for $chan:" {{Limit {}}}\
      "Set {doLimit $net $chan}" "Unlimit {unlimit $net $chan}" {Cancel {}}
}
#
proc channel_kick {this usr} {
    set chan [$this name]
    set who [$usr name]
    mkDialog {} .@kick {Kick} "Really kick $who from channel $chan?" \
      {{Message {}}} "OK {[$this net] KICK {$chan} {$who}}" {Cancel {}}
}
#
proc channel_banKick {this usr} {
    global banInfo
    set banInfo [list $usr $this]
    [$this net] USERHOST [$usr name]
}
#
proc channel_banList {this args} { [$this net] MODE [$this name] +b }
#
proc doBan {net op chan string} { 
    if ![string match {} $string] { $net MODE $chan ${op}b $string }
}
#
proc channel_setBan {this} {
    set chan [$this name]
    set net [$this net]
    if [$this operator] {
	mkEntryBox .@ban$this {Ban} \
	  "Enter name to be banned/unbanned from $chan." {{Pattern {}}}\
	  "Ban {doBan $net + $chan}" "Unban {doBan $net - $chan}" \
	  "List {$this banList}" {Cancel {}}
    } {
	$this banList
    }
}
#
proc doKey {chid string} {
    if [string match {} $string] {
	clearKey ${chid}
    } {
	mkDialog SETKEY .@[newName key] {Set Key} \
	  "Really set key for channel [$chid name]?" {} \
	  "OK {doSetKey $chid {$string}}" {Cancel {}}
    }
}
#
proc doSetKey {chid string} {
    if ![string match {} [$chid key]] { doClearKey $chid }
    $chid configure -key $string
    [$chid net] MODE [$chid name] +k $string
}
#
proc clearKey {chid args} {
    if [string match {} [$chid key]] { return }
    mkDialog CLEARKEY .@[newName key] {Clear Key} \
      "Really clear key for channel [$chid name]?" {} \
      "OK {doClearKey $chid}" {Cancel {}}
}
#
proc doClearKey {chid args} {
    [$chid net] MODE [$chid name] -k [$chid key]
    $chid configure -key {}
}
#
proc setKey {chan} {
    set chid [Channel :: find ${chan}]
    mkEntryBox .@[newName key] Key "Enter key for ${chan}:" \
      "{Key [$chid key]}" \
      "Set {doKey $chid}" "Clear {clearKey $chid}" {Cancel {}}
}
#
proc finger {net nk} {
    if ![string match {} $nk] {
	global fingerInfo
	$net USERHOST [set fingerInfo [string range [cleanup $nk] 0 8]]
    }
}
#
proc doBanKick {net who chan msg ptr} {
    $net MODE $chan +b $ptr
    $net KICK $chan $who $msg
}
#
proc irc302 {net prefix param pargs} {
    global banInfo ignoreInfo fingerInfo signInfo
    if ![regexp {^(.*)(\*?)=([+-])(.*)$} $param match nk op away uh] {
	if [info exists fingerInfo] { set nk $fingerInfo } \
	elseif {[info exists banInfo]} { set nk $banInfo } \
	elseif {[info exists ignoreInfo]} { set nk $ignoreInfo} { set nk {} }
	catch {unset banInfo ignoreInfo fingerInfo}
	mkInfoBox ERROR .@bifinfo {Nickerr} "No such nick as $nk!" {Dismiss {}}
	return
    }
    set usr [User :: make $nk]
    if {[info exists banInfo] && [lindex $banInfo 0] == $usr} {
	set chan [[lindex $banInfo 1] name]
	set who [$usr name]
	mkEntryBox .@[newName kick] "Ban+Kick" \
	  "Really ban and kick $who ($uh) from channel ${chan}?" \
	  [list {Message {}} [list Pattern "*!*$uh"]] \
	  "OK {doBanKick $net {$who} {$chan}}" {Cancel {}}
	unset banInfo
    } \
    elseif {[info exists ignoreInfo]} {
	unset ignoreInfo
    } \
    elseif {[info exists signInfo] && [set x [lsearch $signInfo $usr]] >= 0} {
	if [string match [$usr id] $uh] {
	    global friendsOn signOns
	    append signOns "$nk ($uh) "
	    set frnd [[$net control] friends]
	    if {$friendsOn && [$usr isFriend]} { $frnd add $usr }
	    $frnd mark $usr ison
	}
        listdel signInfo $x
	if [string match {} $signInfo] {
	    if [info exists signOns] {
		mkInfoBox ISON .@[newName isonw] Notify \
		  "[getDate] :\nSignon by $signOns" {Dismiss {}} \
		  "WHOIS {who303 $net $signOns}"
	    }
	    catch {unset signInfo signOns}
	}
    } \
    elseif {[info exists fingerInfo]} {
	unset fingerInfo
	regexp {^~?([^@]*)@(.*)$} $uh match user host
	if ![catch {connect $host 79} sock] {
		set w .@[newName fng]
		fileevent $sock readable "handleFinger $net $sock $w"
		toplevel $w -class Zircon
		wm title $w "Finger [$usr name]"
		wm protocol $w WM_DELETE_WINDOW "
		    destroy $w
		    catch {close $sock}
		"

		set oft [frame $w.oFrm]
		scrollbar $oft.vscroller -command "$oft.text yview"
		text $oft.text -yscrollcommand "$oft.vscroller set"
		pack $oft.text -side left -fill both -expand 1
		pack $oft.vscroller -side right -fill y
		button $w.ok -text Dismiss -command "
		    destroy $w
		    catch {close $sock}
		"
		pack $w.oFrm -expand 1 -fill x
		pack $w.ok -fill x
		puts $sock $user@$host
	} {
	    $net display @ERROR "Finger Error $uh : $sock"
	}
    } {
	$net display {} "$nk is $uh (${op}${away})"
    }
}
#
proc handleFinger {net conn w} {
    if {[catch {gets $conn} msg] || $msg == {}} {
	catch {clearHandler $conn}
	catch {close $conn}
    } \
    elseif {[winfo exists $w]} {
	regsub -all "\r" $msg {} msg
	$w.oFrm.text insert end $msg\n
    }
}
#
proc irc311 {net prefix param pargs} {
    global whois
    regsub -all {\\} $pargs {\\\\} pargs
    set whois(info0) [lindex $pargs 1]
    set whois(info1) [lindex $pargs 2]
    set whois(info2) [lindex $pargs 3]
    set whois(info3) $param
}
#
proc irc312 {net prefix param pargs} {
    global whois
    regsub -all {\\} $pargs {\\\\} pargs
    set whois(info4) [lindex $pargs 2]
    set whois(info5) $param
}
#
proc irc313 {net prefix param pargs} { global whois ; set whois(ircop) 1 }
#
proc irc314 {net prefix param pargs} {
    global whois whowas
    if [info exists whois(info0)] {
	if [info exists whowas] { append whowas "\n\n" }
	append whowas "Name: $whois(info1)@$whois(info2) ($whois(info3))\n\
Server: $whois(info4) ($whois(info5))"
	unset whois
    }
    irc311 $net $prefix $param $pargs
}
#
proc irc317 {net prefix param pargs} {
    global whois
    regsub -all {\\} $pargs {\\\\} pargs
    set val [lindex $pargs 2]
    if {$val == 1} {
	set whois(time) "1 second"
    } {
	if {$val >= 60} {
	    if {$val < 120} {
		set whois(time) "1 minute"
	    } {
		set whois(time) "[expr {$val / 60}] minutes"
	    }
	} {
	    set whois(time) "$val seconds"
	}
    }
}

proc max {a b} { return [expr $a > $b ? $a : $b] }

proc irc318 {net prefix param pargs} {
    global whois
    if ![info exists whois] return
    if ![info exists whois(info0)] return
    set who $whois(info0)
    set usr [User :: make $who]

    set txt "Name: $whois(info1)@$whois(info2) ($whois(info3))"
    set st "Server: $whois(info4) ($whois(info5))"
    set wd [max [string length $txt] [string length $st]]
    append txt "\n$st\n"
    if [info exists whois(time)] { append txt "Idle: $whois(time)\n" }
    if [info exists whois(ircop)] { append txt "$who is an IRC operator.\n" }
    if [info exists whois(away)] {
	set wd [max $wd [string length $whois(away)]]
	append txt "Away: $whois(away)\n"
    }
    set w .@whois$usr
    catch "destroy $w"
    toplevel $w -class Zircon
    wm title $w "WHOIS $who"
    wm protocol $w WM_DELETE_WINDOW "destroy $w"
    frame $w.f1 -borderwidth 0
    text $w.f1.t -relief raised -height 5 -width $wd
    $w.f1.t insert end $txt
    frame $w.f1.b -relief raised
    pack $w.f1.b -fill x -side bottom
    pack $w.f1.t -expand 1 -fill both -side top
    button $w.f1.b.ok -text Dismiss -command "destroy $w"
    button $w.f1.b.msg -text Message -command "doMsg $net {$who}"
    pack $w.f1.b.ok $w.f1.b.msg -expand 1 -side left -fill x
    pack $w.f1 -fill both -expand 1 -side left
    if {[info exists whois(channels)] && $whois(channels) != {}} {
	button $w.f1.b.all -text {Join All} \
	  -command "joinAll $net $whois(channels) ; destroy $w"
	pack $w.f1.b.all -expand 1 -side left -fill x
	makeLB $w.f2
	foreach chn $whois(channels) { $w.f2.l insert end $chn }
	bind $w.f2.l <Double-Button-1> { joinAll [%W get [%W nearest %y]] }
	pack $w.f2 -side right -fill both -expand 1
    }
    unset whois
}
#
proc joinAll {net args} {
    foreach ch $args { regsub {^@} $ch {} ch ; channelJoin $net $ch }
}
#
proc irc319 {net prefix param pargs} {
    global whois ; append whois(channels) " $param"
}
#
proc irc369 {net prefix param pargs} {
    global whois whowas
    if [info exists whois(err)] {
	set txt "There was no such user as $whois(err)."
    } {
	if [info exists whowas] { append whowas "\n\n" } { set whowas {} }
	set txt "${whowas}Name: $whois(info1)@$whois(info2) ($whois(info3))\n\
Server: $whois(info4) ($whois(info5))"
    }
    mkInfoBox WHOWAS .@whowas Whowas "$txt" {Dismiss {}}
    unset whois
    catch {unset whowas}
}
#
proc irc341 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [string match {nil} [set id [Channel :: find [set chan [lindex $pargs 2]]]]] {
	set id [$net info]
    }
    $id addText {} "*** Inviting [lindex $pargs 1] to channel ${chan}"
}
#
proc irc342 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    $net display {} "*** Summoning [lindex $pargs 1] to IRC"
}
#
proc irc315 {net prefix param pargs} {
    global whoTxt
    if {[info exists whoTxt] && [string match {.@who*} $whoTxt] &&
      [winfo exists $whoTxt]} {$whoTxt yview 0}
    catch {unset whoTxt}
}
#
proc irc352 {net prefix param pargs} {
    global whoTxt
    set fmt "%-9s\t%-14s\t%-3s\t%s@%s (%s)\n" 
    regsub -all {\\} $pargs {\\\\} pargs
    set txt [format $fmt [lindex $pargs 1] \
      [lindex $pargs 5] [lindex $pargs 6] [lindex $pargs 2] \
      [lindex $pargs 3] $param]
    if ![info exists whoTxt] {
	set whoTxt [mkInfoBox WHO .@[newName who] "Who [getDate]" {} {Dismiss {}}]
	$whoTxt configure -tabs {1i 2i 3i}
    }
    if ![winfo exists $whoTxt] return
    $whoTxt configure -state normal
    insertText [$net info] $whoTxt $txt {}
    $whoTxt configure -state disabled
    set ln [lindex [split [$whoTxt index end] .] 0]
    if {$ln < 24 && $ln > 10} {
	$whoTxt conf -height $ln
    }
    $whoTxt see end
}
#
proc irc367 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    set chan [lindex $pargs 1]
    set ban [lindex $pargs 2]
    if {![string match {nil} [set chn [Channel :: find $chan]]] && [$chn active]} {
	$chn addText @BAN "**> $ban is banned."
    } {
	$net display @BAN "Channel $chan bans $ban"
    }
}
#
proc irc368 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    set chan [lindex $pargs 1]
    if {![string match {nil} [set chn [Channel :: find $chan]]] && [$chn active]} {
	$chn addText @BAN "**> $param"
    } {
	$net display @BAN "Channel $chan $param"
    }
}
#
proc handleURL {net url} {
    global zircon
    if [info exists zircon(cciport)] {
	if {$zircon(cciport) == {netscape}} {
	    exec netscape -remote openurl($url,newwindow) &
	} \
	elseif {[catch {connect localhost $zircon(cciport)} ccisock]} {
	    $net display {} "*** Cannot connect to WWW viewer ($val)"
	} {
	    set url [string trim $url]
	    gets $ccisock res
	    puts $ccisock "GET URL <$url> OUTPUT NEW\r"
	    gets $ccisock res
	    puts $ccisock "DISCONNECT\r"
	    close $ccisock
	    return
	}
    }
    if [info exists zircon(wwwclient)] { exec $zircon(wwwclient) $url & }
}

#
proc doExec {where} {
    mkDialog EXEC .@e$where {Execute command} {Enter command to be executed} \
	{{Command {}}} "{OK} {runCmd $where}" {Cancel {}}
}
#
proc runCmd {where cmd} {
    if ![string match {} $cmd] {
	if [catch {open "|$cmd 2>&1" r} ip] {
	    mkInfoBox ERROR .@xcerr {Execerr} \
	      "Error executing \"$cmd\" - $ip" {Dismiss {}}
	} {
	    fileevent $ip readable "execOP $where {$cmd} $ip"
	}
    }
}
#
proc net_exec {this} { doExec [$this info] }
#
proc execOP {where cmd fd} {
    if [catch {gets $fd} data] {
	mkInfoBox ERROR .@xcerr {Execerr} \
	  "Error executing \"$cmd\" - $data" {Dismiss {}}
    } \
    elseif {[eof $fd]} {
	if [catch {close $fd} msg] {
	    mkInfoBox ERROR .@xcerr {Execerr} \
	      "Error executing \"$cmd\" - $msg" {Dismiss {}}
	}
    } \
    elseif {[string match {info*} $where]} {
	$where display EXEC $data
    } {
	$where send $data
    }
}
#
proc doScript {where} {
}
#
proc findURL {win x y net} {
    set ls [$win index "@$x,$y linestart"]
    set txt [$win get $ls "@$x,$y lineend"]
    if [regexp -nocase -indices \
      "((http|gopher|ftp|wais|telnet)://\[^ \t\)>\",;&\]+)" \
      $txt url mt] {
	$win tag remove sel 0.0 end
	set se [expr [lindex $mt 1] + 1]
	$win tag add sel "$ls +[lindex $mt 0] chars" "$ls +$se chars"
	handleURL $net [$win get sel.first sel.last]
    }
    notIdle %W
}
