# include <stdlib.h>
# include <string.h>

# include "hfs.h"
# include "glob.h"

typedef struct {
  char *mem;
  size_t memsz;
  char **eltend;
  char *strs;
} dlist;

typedef struct {
  char *str;
  int len;
  size_t space;
  char sbuf[50];
} dstring;

/* List Routines =========================================================== */

/*
 * NAME:	listinit()
 * DESCRIPTION:	initialize a new dynamic list
 */
static
int listinit(dlist *list)
{
  list->memsz = 100;
  list->mem   = malloc(list->memsz);
  if (list->mem == 0)
    return -1;

  list->eltend = (char **) list->mem;
  list->strs   = list->mem + list->memsz;

  return 0;
}

/*
 * NAME:	listfree()
 * DESCRIPTION:	free a dynamic list
 */
static
void listfree(dlist *list)
{
  free(list->mem);
}

/*
 * NAME:	listappend()
 * DESCRIPTION:	insert a string to the end of a list
 */
static
int listappend(dlist *list, char *str)
{
  int len;

  len = strlen(str) + 1;

  /* make sure there is room */

  if (sizeof(char *) + len > list->strs - (char *) list->eltend)
    {
      dlist newlist;
      size_t strsz;
      char **elt;

      strsz = (list->mem + list->memsz) - list->strs;

      newlist.memsz = list->memsz * 2 + sizeof(char *) + len;
      newlist.mem   = malloc(newlist.memsz);
      if (newlist.mem == 0)
	return -1;

      newlist.eltend = (char **) newlist.mem;
      newlist.strs   = newlist.mem + newlist.memsz - strsz;

      memcpy(newlist.strs, list->strs, strsz);

      for (elt = (char **) list->mem; elt < list->eltend; ++elt)
	*newlist.eltend++ = newlist.strs + (*elt - list->strs);

      free(list->mem);

      *list = newlist;
    }

  list->strs -= len;
  strcpy(list->strs, str);

  *list->eltend++ = list->strs;

  return 0;
}

/* String Routines ========================================================= */

# if 0

/*
 * NAME:	strinit()
 * DESCRIPTION:	initialize a new dynamic string
 */
static
void strinit(dstring *string)
{
  string->str     = string->sbuf;
  string->len     = 0;
  string->space   = sizeof(string->sbuf);
  string->sbuf[0] = 0;
}

/*
 * NAME:	strappend()
 * DESCRIPTION:	append to a dynamic string
 */
static
int strappend(dstring *string, char *str, int len)
{
  int newlen;

  if (len < 0)
    len = strlen(str);

  newlen = string->len + len;

  /* make sure there is room */

  if (newlen >= string->space)
    {
      char *new;

      string->space = newlen * 2;

      new = malloc(string->space);
      if (new == 0)
	return -1;

      memcpy(new, string->str, string->len);

      if (string->str != string->sbuf)
	free(string->str);

      string->str = new;
    }

  /* append the string */

  memcpy(string->str + string->len, str, len);

  string->len += len;
  string->str[string->len] = 0;

  return 0;
}

/*
 * NAME:	strfree()
 * DESCRIPTION:	free a dynamic string
 */
static
void strfree(dstring *string)
{
  if (string->str != string->sbuf)
    free(string->str);
}

# endif

/* Glob Routines =========================================================== */

/*
 * NAME:	globpath()
 * DESCRIPTION:	perform filename globbing for a single path
 */
static
int globpath(hfsvol *vol, dlist *list, char *pathname)
{
  /* not yet implemented */

  return listappend(list, pathname);
}

/* Interface Routine ======================================================= */

/*
 * NAME:	hfs->glob()
 * DESCRIPTION:	perform glob pattern matching
 */
char **hfs_glob(hfsvol *vol, int argc, char *argv[], int *nelts)
{
  dlist list;
  int i;

  if (listinit(&list) < 0)
    return 0;

  for (i = 0; i < argc; ++i)
    {
      if (globpath(vol, &list, argv[i]) < 0)
	{
	  listfree(&list);
	  return 0;
	}
    }

  *nelts = list.eltend - (char **) list.mem;

  return (char **) list.mem;
}
