/* 
Copyright notice:

This is mine.  I'm only letting you use it.  Period.  Feel free to rip off
any of the code you see fit, but have the courtesy to give me credit.
Otherwise great hairy beasties will rip your eyes out and eat your flesh
when you least expect it.

Jonny Goldman <jgoldman@parc.xerox.com>

Tue Jul 17 1990
*/

/* main.c -- create our windows and initialize things. */

#define MAIN
#include "vaders.h"
#ifndef X11R3
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#else
#include <X11/IntrinsicP.h>
#include <X11/Label.h>
#include <X11/VPaned.h>
#endif
static int width, height;		/* Size of window. */

#ifdef XFILESEARCHPATH
static void AddPathToSearchPath();
#endif

static XrmOptionDescRec table[] = {
    {"-debug",	"*debug",	XrmoptionNoArg,	NULL},
};

static XtResource resources[] = {
    {XtNwidth, XtCWidth, XtRInt, sizeof(int),
	 (Cardinal)&width, XtRImmediate, (caddr_t) VWIDTH},
    {XtNheight, XtCHeight, XtRInt, sizeof(int),
	 (Cardinal)&height, XtRImmediate, (caddr_t) VHEIGHT},
    {"debug", "Debug", XtRBoolean, sizeof(Boolean),
	 (Cardinal)&debug, XtRString, "off"},
    {"bitdir", "BitmapDirectory", XtRString, sizeof(String),
	 (Cardinal)&bitdir, XtRString, (String)"./"},
    {"scale", "Scale", XtRInt, sizeof(int),
	 (Cardinal)&scale, XtRImmediate, (caddr_t) 1 },
    {"basewait", "BaseWait", XtRInt, sizeof(int),
	 (Cardinal)&basewait, XtRImmediate, (caddr_t) 10},
    {"vaderwait", "VaderWait", XtRInt, sizeof(int),
	 (Cardinal)&vaderwait, XtRImmediate, (caddr_t) 300},
    {"spacerwait", "SpacerWait", XtRInt, sizeof(int),
	 (Cardinal)&spacerwait, XtRImmediate, (caddr_t) 50},
    {"shotwait", "ShotWait", XtRInt, sizeof(int),
	 (Cardinal)&shotwait, XtRImmediate, (caddr_t) 10},
    {"vshotwait", "VshotWait", XtRInt, sizeof(int),
	 (Cardinal)&vshotwait, XtRImmediate, (caddr_t) 30},
    {"basecolor", "BaseColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&basepixel, XtRString, "cyan"},
    {"spacercolor", "SpacerColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&spacerpixel, XtRString, "gray"},
    {"buildingcolor", "BuildingColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&buildingpixel, XtRString, "yellow"},
    {"vader1color", "Vader1Color", XtRPixel, sizeof(Pixel),
	 (Cardinal)&vader1pixel, XtRString, "blue"},
    {"vader2color", "Vader2Color", XtRPixel, sizeof(Pixel),
	 (Cardinal)&vader2pixel, XtRString, "green"},
    {"vader3color", "Vader3Color", XtRPixel, sizeof(Pixel),
	 (Cardinal)&vader3pixel, XtRString, "red"},
    {"shotcolor", "ShotColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&shotpixel, XtRString, "lavender"},
    {"vshotcolor", "VshotColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&vshotpixel, XtRString, "orange"},
    {"scorecolor", "ScoreColor", XtRPixel, sizeof(Pixel),
	 (Cardinal)&scorepixel, XtRString, "white"},
    {"maxshots", "MaxShots", XtRInt, sizeof(int),
	 (Cardinal) &maxshots, XtRImmediate, (caddr_t) 1},
    {"maxvshots", "MaxVshots", XtRInt, sizeof(int),
	 (Cardinal) &maxvshots, XtRImmediate, (caddr_t) 6},
    {"defaultfore", "DefaultFore", XtRPixel, sizeof(Pixel),
	 (Cardinal) &defaultfore, XtRString, "white"},
    {"defaultback", "DefaultBack", XtRPixel, sizeof(Pixel),
	 (Cardinal) &defaultback, XtRString, "black"},
};


static void CvtStringToFloat(args, num_args, fromVal, toVal)
ArgList args;
Cardinal num_args;
XrmValue    *fromVal;
XrmValue    *toVal;
{
    static float  i;

    if (sscanf((char *)fromVal->addr, "%f", &i) == 1) {
	toVal->size = sizeof(float);
	toVal->addr = (caddr_t) &i;
    } else {
	toVal->size = 0;
	toVal->addr = NULL;
    }
}

static void AddResource(r, p)
char *r;
Pixel *p;
{
    XrmValue value;
    XrmDatabase db = XtDatabase(dpy);
    value.size = sizeof(Pixel);
    value.addr = (caddr_t) p;
    XrmPutResource(&db, r, XtRPixel, &value);
}

main(argc, argv)
Cardinal argc;
char **argv;
{
    static Arg args[] = {
	{XtNwidth, NULL},
	{XtNheight, NULL},
    };
    static Arg scoreargs[] = {
	{XtNforeground, NULL},
    };
    Widget pane;
    extern WidgetClass labelwidgetclass;
    srandom(time(0));
#ifdef XFILESEARCHPATH
    AddPathToSearchPath(XFILESEARCHPATH);
#endif
    toplevel = XtInitialize(argv[0], "Vaders", table, XtNumber(table),
			    &argc, argv);
    dpy = XtDisplay(toplevel);
    XtAddConverter(XtRString, XtRFloat, CvtStringToFloat, NULL, 0);
    XtGetApplicationResources(toplevel, (caddr_t) NULL, 
			      resources, XtNumber(resources),
			      NULL, (Cardinal) 0);
    AddResource("*background", &defaultback);
    if (DisplayCells(dpy, DefaultScreen(dpy)) <= 2)
       {
	basepixel = defaultfore;
	buildingpixel = defaultfore;
	vader1pixel = defaultfore;
	vader2pixel = defaultfore;
	vader3pixel = defaultfore;
	shotpixel = defaultfore;
	vshotpixel = defaultfore;
	scorepixel = defaultfore;
    }
    if (scale<1) scale = 1;
    if (scale>2) scale = 2;
    width = scale*VWIDTH;
    height = scale*VHEIGHT;
    args[0].value = (XtArgVal) width;
    args[1].value = (XtArgVal) height;
#ifndef X11R3
    pane = XtCreateWidget("pane", panedWidgetClass, toplevel,
			  args, XtNumber(args));
#else
    pane = XtCreateWidget("pane", vPanedWidgetClass, toplevel,
			   args, XtNumber(args));
#endif
    XtManageChild(pane);
    gamewidget = (VadersWidget)
	XtCreateWidget("field", vadersWidgetClass, pane, NULL, 0);
    XtManageChild(gamewidget);
    XtRealizeWidget(toplevel);
    spacer_counter = 1000;
    XtMainLoop();
}


Punt(msg)
{
    fprintf(stderr, "%s\n", msg);
    exit(1);
}


#ifdef XFILESEARCHPATH
static void
AddPathToSearchPath(path)
char *path;
{
     char *old, *new;
     extern char *getenv();
     
     old = getenv("XFILESEARCHPATH");
     if (old) {
#if defined(mips) || defined(hpux) || defined(sun)
	  /* +1 for =, +2 for :, +3 for null */
	  new = XtMalloc((Cardinal) (strlen("XFILESEARCHPATH") +
				     strlen(old) +
				     strlen(path) + 3));
	  (void) strcpy(new, "XFILESEARCHPATH");
	  (void) strcat(new, "=");
	  (void) strcat(new, old);
	  (void) strcat(new, ":");
	  (void) strcat(new, path);
	  putenv(new);
#else
	  /* +1 for colon, +2 for null */
	  new = XtMalloc((Cardinal) (strlen(old) + strlen(path) + 2));
	  (void) strcpy(new, old);
	  (void) strcat(new, ":");
	  (void) strcat(new, path);
	  setenv("XFILESEARCHPATH", new, 1);
#endif
     }
     else {
#if defined(mips) || defined(hpux) || defined(sun)
	  new = XtMalloc((Cardinal) (strlen("XFILESEARCHPATH") +
				     strlen(path) + 2));
	  (void) strcpy(new, "XFILESEARCHPATH");
	  (void) strcat(new, "=");
	  (void) strcat(new, path);
	  putenv(new);
#else
	  setenv("XFILESEARCHPATH", path, 1);
#endif
     }
}
#endif
