
/* Feel free to remove any of these entries if the keysym is not
   defined in your header files..
*/
static struct keycode {
	KeySym key;
	KeySym shift;
	char  *name;
	char  *ascii;
	} keycodes[] = {
		{ XK_Escape,	XK_Escape,	"Escape", "\033" },
		{ XK_F1,	XK_F11,		"F1",	"\033[11~" },
		{ XK_F2,	XK_F12,		"F2",	"\033[12~" },
		{ XK_F3,	XK_F13,		"F3",	"\033[13~" },
		{ XK_F4,	XK_F14,		"F4",	"\033[14~" },
		{ XK_F5,	XK_F15,		"F5",	"\033[15~" },
		{ XK_F6,	XK_F16,		"F6",	"\033[17~" },
		{ XK_F7,	XK_F17,		"F7",	"\033[18~" },
		{ XK_F8,	XK_F18,		"F8",	"\033[19~" },
		{ XK_F9,	XK_F19,		"F9",	"\033[20~" },
		{ XK_F10,	XK_F20,		"F10",	"\033[21~" },
		{ XK_F11,	XK_F11,		"F11",	"\033[23~" },
		{ XK_F12,	XK_F12,		"F12",	"\033[24~" },
		{ XK_grave,	XK_asciitilde,	"`",	"`" },
		{ XK_1,		XK_exclam,	"1",	"1" },
		{ XK_2,		XK_at,		"2",	"2" },
		{ XK_3,		XK_numbersign,	"3",	"3" },
		{ XK_4,		XK_dollar,	"4",	"4" },
		{ XK_5,		XK_percent,	"5",	"5" },
		{ XK_6,		XK_asciicircum,	"6",	"6" },
		{ XK_7,		XK_ampersand,	"7",	"7" },
		{ XK_8,		XK_asterisk,	"8",	"8" },
		{ XK_9,		XK_parenleft,	"9",	"9" },
		{ XK_0,		XK_parenright,	"0",	"0" },
		{ XK_minus,	XK_underscore,	"-",	"-" },
		{ XK_equal,	XK_plus,	"=",	"=" },
		{ XK_backslash,	XK_bar,		"\\",	"\\" },
		{ XK_BackSpace,	XK_BackSpace,	"Backspace", "\b" },
		{ XK_Tab,	XK_Tab,		"Tab",	"\011" },
		{ XK_q,		XK_Q,		"Q",	"q" },
		{ XK_w,		XK_W,		"W",	"w" },
		{ XK_e,		XK_E,		"E",	"e" },
		{ XK_r,		XK_R,		"R",	"r" },
		{ XK_t,		XK_T,		"T",	"t" },
		{ XK_y,		XK_Y,		"Y",	"y" },
		{ XK_u,		XK_U,		"U",	"u" },
		{ XK_i,		XK_I,		"I",	"i" },
		{ XK_o,		XK_O,		"O",	"o" },
		{ XK_p,		XK_P,		"P",	"p" },
		{ XK_bracketleft, XK_braceleft,	"[",	"[" },
		{ XK_bracketright, XK_braceright, "]",	"]" },
		{ XK_Return,	XK_Return,	"Return", "\r" },
		{ XK_a,		XK_A,		"A",	"a" },
		{ XK_s,		XK_S,		"S",	"s" },
		{ XK_d,		XK_D,		"D",	"d" },
		{ XK_f,		XK_F,		"F",	"f" },
		{ XK_g,		XK_G,		"G",	"g" },
		{ XK_h,		XK_H,		"H",	"h" },
		{ XK_j,		XK_J,		"J",	"j" },
		{ XK_k,		XK_K,		"K",	"k" },
		{ XK_l,		XK_L,		"L",	"l" },
		{ XK_semicolon, XK_colon,	";",	";" },
		{ XK_apostrophe, XK_quotedbl,	"'",	"'" },
		{ XK_z,		XK_Z,		"Z",	"z" },
		{ XK_x,		XK_X,		"X",	"x" },
		{ XK_c,		XK_C,		"C",	"c" },
		{ XK_v,		XK_V,		"V",	"v" },
		{ XK_b,		XK_B,		"B",	"b" },
		{ XK_n,		XK_N,		"N",	"n" },
		{ XK_m,		XK_M,		"M",	"m" },
		{ XK_comma,	XK_less,	",",	"," },
		{ XK_period,	XK_greater,	".",	"." },
		{ XK_slash,	XK_question,	"/",	"/" },
		{ XK_space,	XK_space,	"Space", " " },
		{ XK_Pause,	XK_Pause,	"Pause", "" },
		{ XK_Insert,	XK_Insert,	"Insert",	"\033[2~" },
		{ XK_Home,	XK_Home,	"Home",		"\033[H" },
		{ XK_Prior,	XK_Prior,	"Page Up",	"\033[5~" },
		{ XK_Delete,	XK_Delete,	"Delete",	"\0177" },
		{ XK_End,	XK_End,		"End",		"\033Ow" },
		{ XK_Next,	XK_Next,	"Page Down",	"\033[6~" },
		{ XK_Up,	XK_Up,		"Up Arrow",	"\033[A" },
		{ XK_Down,	XK_Down,	"Down Arrow",	"\033[B" },
		{ XK_Left,	XK_Left,	"Left Arrow",	"\033[D" },
		{ XK_Right,	XK_Right,	"Right Arrow",	"\033[C" },
		{ XK_Num_Lock,	XK_Num_Lock,	"Num Lock",	"" },
		{ XK_KP_Divide,	XK_KP_Divide,	"[/]",	"/" },
		{ XK_KP_Multiply, XK_KP_Multiply, "[*]",	"*" },
		{ XK_KP_Subtract, XK_KP_Subtract, "[-]",	"\033Om" },
		{ XK_KP_7,	XK_KP_7,	"[7]",	"\033[H" },
		{ XK_KP_8,	XK_KP_8,	"[8]",	"\033OA" },
		{ XK_KP_9,	XK_KP_9,	"[9]",	"\033[5~" },
		{ XK_KP_Add,	XK_KP_Add,	"[+]",	"+" },
		{ XK_KP_4,	XK_KP_4,	"[4]",	"\033OD" },
		{ XK_KP_5,	XK_KP_5,	"[5]",	"" },
		{ XK_KP_6,	XK_KP_6,	"[6]",	"\033OC" },
		{ XK_KP_1,	XK_KP_1,	"[1]",	"\033Ow" },
		{ XK_KP_2,	XK_KP_2,	"[2]",	"\033OB" },
		{ XK_KP_3,	XK_KP_3,	"[3]",	"\033[6~" },
		{ XK_KP_Enter,	XK_KP_Enter,	"Enter",	"\r" },
		{ XK_KP_0,	XK_KP_0,	"[0]",	"\033[2~" },
		{ XK_KP_Decimal, XK_KP_Decimal, "[.]",	"\0177" },
		{ XK_Shift_L,	XK_Shift_L,	"Left Shift",	"" },
		{ XK_Shift_R,	XK_Shift_R,	"Right Shift",	"" },
		{ XK_Control_L,	XK_Control_L,	"Left Control",	"" },
		{ XK_Control_R,	XK_Control_R,	"Right Control", "" },
		{ XK_Caps_Lock,	XK_Caps_Lock,	"Caps Lock",	"" },
		{ XK_Alt_L,	XK_Alt_L,	"Left Alt",	"" },
		{ XK_Alt_R,	XK_Alt_R,	"Right Alt",	"" },
		{ XK_Meta_L,	XK_Meta_L,	"Left Meta",	"" },
		{ XK_Meta_R,	XK_Meta_R,	"Right Meta",	"" },
		{ 0,		0,		NULL,	"" }
	};

