/*
Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilucaobject.c,v 1.8 1996/02/13 03:19:20 janssen Exp $
*/

/* from ILU */
#include "iluxport.h"

/* local */
#include "python.h"
#include "ilucaobject.h"

static void
iluca_dealloc(PyObject *o)
{
  IlucaObject * v	= (IlucaObject *) o;

  ILU_HANDLED(v->err);
  PyMem_DEL(o);
}

PyObject *
iluca_FromCall(ilu_Call call)
{
  IlucaObject *	v	= PyObject_NEW(IlucaObject, &Iluca_Type);

  if (v == 0)
    return 0;
  v->call = call;
  ILU_CLER(v->err);
  v->conn_disabled = ilu_TRUE;
  return (PyObject *) v;
}

PyTypeObject	Iluca_Type =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"ilu_Call",
	sizeof(IlucaObject),
	0,
	iluca_dealloc,		/*tp_dealloc*/
	0,			/*tp_print*/
	0,			/*tp_getattr*/
	0,			/*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};
