/* fprog.c */
/* $Id: fprog.c,v 1.4 1995/12/18 21:10:26 spreitze Exp $ */
/* Last edited by Mike Spreitzer December 18, 1995 12:53 pm PST */

#include <stdio.h>

#include "Fibber.h"

typedef
ilu_cardinal(*Proc) (ILU_C_OBJECT, ilu_cardinal, ilu_cardinal, ILU_C_OBJECT, ILU_C_ENVIRONMENT *);

static          ilu_boolean
DoCall(Fibber_T ask,
       ilu_cardinal d,
       ilu_cardinal n,
       Fibber_T self,
       ilu_cardinal * ans,
       ILU_C_ENVIRONMENT * Env)
{
  ILU_C_ENVIRONMENT lenv;
  Fibber_StringSeq ss, *ssp;
  ILU_C_SET_SUCCESSFUL(Env);
  *ans = Fibber_T_Calc(ask, d, n, self, &lenv);
  switch (lenv._major) {
  case ILU_C_NO_EXCEPTION:
    return ilu_TRUE;
  case ILU_C_USER_EXCEPTION:
    if (ILU_C_EXCEPTION_ID(&lenv) == ex_Fibber_Failed) {
      char            buf[30];
      sprintf(buf, "Fib(%lu) =>", n);
      ss = *(Fibber_StringSeq *) lenv.ptr;
      Fibber_StringSeq_Push(&ss, (Fibber_String) ILU_C_Strdup(buf));
    } else {
      ss = Fibber_StringSeq_Create(2, NULL);
      Fibber_StringSeq_Append(&ss,
	(Fibber_String) ILU_C_Strdup("Unexpected user exception"));
      Fibber_StringSeq_Append(&ss,
	  (Fibber_String) ILU_C_Strdup(ILU_C_EXCEPTION_ID(&lenv)));
    }
    break;
  case ILU_C_SYSTEM_EXCEPTION:{
      ILU_C_SYSEXN_BODY *sysExn;
      char            buf[200];
      sysExn = (ILU_C_SYSEXN_BODY *) ILU_C_EXCEPTION_VALUE(&lenv);
      sprintf(buf, "%s(minor=%lu, completed=%d)",
	      ILU_C_EXCEPTION_ID(&lenv), sysExn->minor,
	      sysExn->completed);
      ss = Fibber_StringSeq_Create(2, NULL);
      Fibber_StringSeq_Append(&ss,
		 (Fibber_String) ILU_C_Strdup("system exception"));
      Fibber_StringSeq_Append(&ss, (Fibber_String) ILU_C_Strdup(buf));
      break;
    }
  default:
    ss = Fibber_StringSeq_Create(1, NULL);
    Fibber_StringSeq_Append(&ss,
	   (Fibber_String) ILU_C_Strdup("Unexpected lenv._major"));
  }
  ssp = (Fibber_StringSeq *) ilu_must_malloc(sizeof(*ssp));
  *ssp = ss;
  Env->_major = ILU_C_USER_EXCEPTION;
  Env->returnCode = ex_Fibber_Failed;
  Env->ptr = (void *) ssp;
  Env->freeRoutine = 0;
  return ilu_FALSE;
}

ilu_cardinal
server_Fibber_T_Calc(Fibber_T self,
		     ilu_cardinal d,
		     ilu_cardinal n,
		     Fibber_T ask,
		     ILU_C_ENVIRONMENT * Env)
{
  ilu_cardinal    f1, f2, ans;
  ILU_C_SET_SUCCESSFUL(Env);
  if (n < 2)
    ans = 1;
  else {
    printf("fib(%d, %d, 1)\n", d, n);
    if (!DoCall(ask, d + 1, n - 1, self, &f1, Env))
      return 0;
    printf("fib(%d, %d, 2)\n", d, n);
    if (!DoCall(ask, d + 1, n - 2, self, &f2, Env))
      return 0;
    ans = f1 + f2;
  }
  printf("fib(%d, %d) => %d\n", d, n, ans);
  return (ans);
}

#define TISIZE 10

static char    *pinfo = NULL;
static char    *tinfo[TISIZE] = {"sunrpcrm", "tcp_0_0", ILU_NIL};
static ilu_Server s;
static ILU_C_OBJECT mine;
static ilu_string sbh;

static void 
Export(char *sid)
{
  s = ILU_C_InitializeServer(sid, NULL, pinfo, tinfo, ilu_TRUE);
  if (s == NULL) {
    fprintf(stderr, "Unable to create my ILU server!\n");
    exit(1);
  }
  mine = Fibber_T__CreateTrue("it", s, NULL);
  if (mine == NULL) {
    fprintf(stderr, "Unable to create my ILU object!\n");
    exit(1);
  }
  sbh = ILU_C_SBHOfObject(mine);
  printf("my SBH = '%s'\n", sbh);
}

int
main(int argc, char **argv)
{
  char           *progname = argv[0];

  argv++;
  argc--;
  while (argc > 1) {
    if (strcmp(argv[0], "-c") == 0)
      break;
    if (strcmp(argv[0], "-p") == 0)
      pinfo = argv[1];
    else if (strcmp(argv[0], "-t") == 0) {
      int             j = 1;
      while ((j < argc) && (j < TISIZE) && (argv[j][0] != '-')) {
	tinfo[j - 1] = argv[j];
	j++;
      }
      tinfo[j - 1] = ILU_NIL;
      argv += j;
      argc -= j;
      continue;
    } else
      goto usage;
    argv += 2;
    argc -= 2;
  }
  if (argc < 1)
    goto usage;
  Fibber__Initialize();
  Fibber__InitializeServer();
  if (strcmp(argv[0], "-c") == 0) {
    Fibber_T        peer;
    ILU_C_ENVIRONMENT env;
    ilu_cardinal    n, ans, i;
    Fibber_StringSeq *ss;
    if (argc != 2)
      goto usage;
    Export(NULL);
    n = atoi(argv[1]);
    peer = ILU_C_LookupObject("Fibber-Test-Server", "it",
			      Fibber_T__MSType);
    if (peer == NULL) {
      fprintf(stderr, "Unable to import peer!\n");
      exit(1);
    }
    ans = Fibber_T_Calc(peer, 1, n, mine, &env);
    switch (env._major) {
    case ILU_C_NO_EXCEPTION:
      printf("Fib(%lu) = %lu\n", n, ans);
      break;
    case ILU_C_USER_EXCEPTION:
      if (ILU_C_EXCEPTION_ID(&env) == ex_Fibber_Failed) {
	ss = (Fibber_StringSeq *) ILU_C_EXCEPTION_VALUE(&env);
	printf("Fib(%lu) => Failed %d", n, ss->_length);
	for (i = 0; i < ss->_length; i++)
	  printf(" \"%s\"", ss->_buffer[i]);
	printf("\n");
      } else {
	printf("Fib(%lu) => %s\n", n, ILU_C_EXCEPTION_ID(&env));
      }
      break;
    case ILU_C_SYSTEM_EXCEPTION:{
	CORBA_ex_body  *sysExn;
	sysExn = (CORBA_ex_body *) CORBA_exception_value(&env);
	printf("Fib(%lu) => SYSTEM %s(%lu, %d)\n", n,
	       ILU_C_EXCEPTION_ID(&env),
	       sysExn->minor, sysExn->completed);
	break;
      }
    default:
      printf("Fib(%lu) => Unexpected _major!\n", n);
    }
    return 0;
  } else if (strcmp(argv[0], "-s") == 0) {
    int             i;
    if (argc > 1)
      goto usage;
    Export("Fibber-Test-Server");
    if (ILU_C_PublishObject(mine) == NULL) {
      fprintf(stderr, "Can't publish object!\n");
      exit(1);
    }
    printf("Serving...\n");
    ILU_C_Run();
  } else
    goto usage;
usage:
  fprintf(stderr,
	"Usage: %s [-p pinfo] [-t tinfo [tinfo...]] (-s | -c n)\n",
	  progname);
  return 1;
}
