/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"




PROC (s_vector_p, "vector?", 1, 0, 0, scm_vector_p);
#ifdef __STDC__
SCM
scm_vector_p(SCM x)
#else
SCM
scm_vector_p(x)
     SCM x;
#endif
{
  if IMP(x) return BOOL_F;
  return VECTORP(x) ? BOOL_T : BOOL_F;
}

PROC (s_vector_length, "vector-length", 1, 0, 0, scm_vector_length);
#ifdef __STDC__
SCM
scm_vector_length(SCM v)
#else
SCM
scm_vector_length(v)
     SCM v;
#endif
{
  ASSERT(NIMP(v) && VECTORP(v), v, ARG1, s_vector_length);
  return MAKINUM(LENGTH(v));
}

PROC (s_list_to_vector, "list->vector", 1, 0, 0, scm_vector);
PROC (s_vector, "vector", 0, 0, 1, scm_vector);
#ifdef __STDC__
SCM
scm_vector(SCM l)
#else
SCM
scm_vector(l)
     SCM l;
#endif
{
  SCM res;
  register SCM *data;
  long i = scm_ilength(l);
  ASSERT(i >= 0, l, ARG1, s_vector);
  res = scm_make_vector(MAKINUM(i), UNSPECIFIED, SCM_UNDEFINED);
  data = VELTS(res);
  for(;NIMP(l);l = CDR(l)) *data++ = CAR(l);
  return res;
}

PROC (s_vector_ref, "vector-ref", 2, 0, 0, scm_vector_ref);
#ifdef __STDC__
SCM
scm_vector_ref(SCM v, SCM k)
#else
SCM
scm_vector_ref(v, k)
     SCM v;
     SCM k;
#endif
{
  ASSERT(NIMP(v) && VECTORP(v), v, ARG1, s_vector_ref);
  ASSERT(INUMP(k), k, ARG2, s_vector_ref);
  ASSERT((INUM(k) < LENGTH(v)) && (INUM(k) >= 0), k, OUTOFRANGE, s_vector_ref);
  return VELTS(v)[((long) INUM(k))];
}


PROC (s_vector_set_x, "vector-set!", 3, 0, 0, scm_vector_set_x);
#ifdef __STDC__
SCM
scm_vector_set_x(SCM v, SCM k, SCM obj)
#else
SCM
scm_vector_set_x(v, k, obj)
     SCM v;
     SCM k;
     SCM obj;
#endif
{
  ASSERT(NIMP(v) && VECTORP(v), v, ARG1, s_vector_set_x);
  ASSERT(INUMP(k), k, ARG2, s_vector_set_x);
  ASSERT((INUM(k) < LENGTH(v)) && (INUM(k) >= 0), k, OUTOFRANGE, s_vector_set_x);
  VELTS(v)[((long) INUM(k))] = obj;
#ifdef GUILE 
  return obj;
#else
  return UNSPECIFIED;
#endif
}


PROC (s_make_vector, "make-vector", 1, 2, 0, scm_make_vector);
#ifdef __STDC__
SCM
scm_make_vector(SCM k, SCM fill, SCM multip)
#else
SCM
scm_make_vector(k, fill, multip)
     SCM k;
     SCM fill;
     SCM multip;
#endif
{
  SCM v;
  int multi;
  register long i;
  register long j;
  register SCM *velts;

  ASSERT(INUMP(k) && (0 <= INUM (k)), k, ARG1, s_make_vector);
  if (UNBNDP(fill))
    fill = UNSPECIFIED;
  multi = !(UNBNDP(multip) || FALSEP(multip));
  i = INUM(k);
  NEWCELL(v);
  DEFER_INTS;
  SETCHARS(v, scm_must_malloc(i?(long)(i*sizeof(SCM)):1L, s_vector));
  SETLENGTH(v, i, tc7_vector);
  velts = VELTS(v);
  j = 0;
  if (multi)
    {
      while ((fill != EOL) && (j < i))
	{
	  (velts)[j++] = CAR (fill);
	  fill = CDR (fill);
	}
    }
  while(--i >= j) (velts)[i] = fill;
  ALLOW_INTS;
  return v;
}


PROC (s_vector_to_list, "vector->list", 1, 0, 0, scm_vector_to_list);
#ifdef __STDC__
SCM
scm_vector_to_list(SCM v)
#else
SCM
scm_vector_to_list(v)
     SCM v;
#endif
{
  SCM res = EOL;
  long i;
  SCM *data;
  ASSERT(NIMP(v) && VECTORP(v), v, ARG1, s_vector_to_list);
  data = VELTS(v);
  for(i = LENGTH(v)-1;i >= 0;i--) res = scm_cons(data[i], res);
  return res;
}


PROC (s_vector_fill_x, "vector-fill!", 2, 0, 0, scm_vector_fill_x);
#ifdef __STDC__
SCM
scm_vector_fill_x(SCM v, SCM fill_x)
#else
SCM
scm_vector_fill_x(v, fill_x)
     SCM v;
     SCM fill_x;
#endif
{
  register long i;
  register SCM *data;
  ASSERT(NIMP(v) && VECTORP(v), v, ARG1, s_vector_fill_x);
  data = VELTS(v);
  for(i = LENGTH(v)-1;i >= 0;i--) data[i] = fill_x;
  return UNSPECIFIED;
}


#ifdef __STDC__
SCM
scm_vector_equal_p(SCM x, SCM y)
#else
SCM
scm_vector_equal_p(x, y)
     SCM x;
     SCM y;
#endif
{
  long i;
  for(i = LENGTH(x)-1;i >= 0;i--)
    if (FALSEP(scm_equal_p(VELTS(x)[i], VELTS(y)[i])))
      return BOOL_F;
  return BOOL_T;
}


#ifdef __STDC__
void
scm_init_vectors (void)
#else
void
scm_init_vectors ()
#endif
{
#include "vectors.x"
}

