/* classes: src_files */

/*	Copyright (C) 1994 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */



#include <stdio.h>
#include "_scm.h"



#ifdef __STDC__
int
scm_i_index (SCM * str, SCM chr, int pos, int pos2, char * why)
#else
int
scm_i_index (str, chr, pos, pos2, why)
     SCM * str;
     SCM chr;
     int pos;
     int pos2;
     char * why;
#endif
{
  char * p;
  ASSERT (NIMP (*str) && ROSTRINGP (*str), *str, pos, why);
  ASSERT (ICHRP (chr), chr, pos2, why);
  p = index (CHARS (*str), ICHR (chr));
  return (p
	  ? p - CHARS (*str)
	  : -1);
}

#ifdef __STDC__
int
scm_i_rindex (SCM * str, SCM chr, int pos, int pos2, char * why)
#else
int
scm_i_rindex (str, chr, pos, pos2, why)
     SCM * str;
     SCM chr;
     int pos;
     int pos2;
     char * why;
#endif
{
  char * p;
  ASSERT (NIMP (*str) && ROSTRINGP (*str), *str, pos, why);
  ASSERT (ICHRP (chr), chr, pos2, why);
  p = rindex (CHARS (*str), ICHR (chr));
  return (p
	  ? p - CHARS (*str)
	  : -1);
}


PROC (s_string_index, "string-index", 2, 0, 0, scm_string_index);
#ifdef __STDC__
SCM 
scm_string_index (SCM str, SCM chr)
#else
SCM 
scm_string_index (str, chr)
     SCM str;
     SCM chr;
#endif
{
  int pos;
  pos = scm_i_index (&str, chr, ARG1, ARG2, s_string_index);
  return (pos < 0
	  ? BOOL_F
	  : MAKINUM (pos));
}


PROC (s_string_rindex, "string-rindex", 2, 0, 0, scm_string_rindex);
#ifdef __STDC__
SCM 
scm_string_rindex (SCM str, SCM chr)
#else
SCM 
scm_string_rindex (str, chr)
     SCM str;
     SCM chr;
#endif
{
  int pos;
  pos = scm_i_rindex (&str, chr, ARG1, ARG2, s_string_rindex);
  return (pos < 0
	  ? BOOL_F
	  : MAKINUM (pos));
}

 
PROC (s_substring_move_left_x, "substring-move-left!", 2, 0, 1, scm_substring_move_left_x);
#ifdef __STDC__
SCM
scm_substring_move_left_x (SCM str1, SCM start1, SCM args)
#else
SCM
scm_substring_move_left_x (str1, start1, args)
     SCM str1;
     SCM start1;
     SCM args;
#endif
{
  SCM end1, str2, start2;
  long i, j, e;
  ASSERT (3==scm_ilength (args), args, WNA, s_substring_move_left_x);
  end1 = CAR (args); args = CDR (args);
  str2 = CAR (args); args = CDR (args);
  start2 = CAR (args);
  ASSERT (NIMP (str1) && STRINGP (str1), str1, ARG1, s_substring_move_left_x);
  ASSERT (INUMP (start1), start1, ARG2, s_substring_move_left_x);
  ASSERT (INUMP (end1), end1, ARG3, s_substring_move_left_x);
  ASSERT (NIMP (str2) && STRINGP (str2), str2, ARG4, s_substring_move_left_x);
  ASSERT (INUMP (start2), start2, ARG5, s_substring_move_left_x);
  i = INUM (start1), j = INUM (start2), e = INUM (end1);
  ASSERT (i <= LENGTH (str1) && i >= 0, start1, OUTOFRANGE, s_substring_move_left_x);
  ASSERT (j <= LENGTH (str2) && j >= 0, start2, OUTOFRANGE, s_substring_move_left_x);
  ASSERT (e <= LENGTH (str1) && e >= 0, end1, OUTOFRANGE, s_substring_move_left_x);
  ASSERT (e-i+j <= LENGTH (str2), start2, OUTOFRANGE, s_substring_move_left_x);
  while (i<e) CHARS (str2)[j++] = CHARS (str1)[i++];
  return UNSPECIFIED;
}


PROC (s_substring_move_right_x, "substring-move-right!", 2, 0, 1, scm_substring_move_right_x);
#ifdef __STDC__
SCM
scm_substring_move_right_x (SCM str1, SCM start1, SCM args)
#else
SCM
scm_substring_move_right_x (str1, start1, args)
     SCM str1;
     SCM start1;
     SCM args;
#endif
{
  SCM end1, str2, start2;
  long i, j, e;
  ASSERT (3==scm_ilength (args), args, WNA, s_substring_move_right_x);
  end1 = CAR (args); args = CDR (args);
  str2 = CAR (args); args = CDR (args);
  start2 = CAR (args);
  ASSERT (NIMP (str1) && STRINGP (str1), str1, ARG1, s_substring_move_right_x);
  ASSERT (INUMP (start1), start1, ARG2, s_substring_move_right_x);
  ASSERT (INUMP (end1), end1, ARG3, s_substring_move_right_x);
  ASSERT (NIMP (str2) && STRINGP (str2), str2, ARG4, s_substring_move_right_x);
  ASSERT (INUMP (start2), start2, ARG5, s_substring_move_right_x);
  i = INUM (start1), j = INUM (start2), e = INUM (end1);
  ASSERT (i <= LENGTH (str1) && i >= 0, start1, OUTOFRANGE, s_substring_move_right_x);
  ASSERT (j <= LENGTH (str2) && j >= 0, start2, OUTOFRANGE, s_substring_move_right_x);
  ASSERT (e <= LENGTH (str1) && e >= 0, end1, OUTOFRANGE, s_substring_move_right_x);
  ASSERT ((j = e-i+j) <= LENGTH (str2), start2, OUTOFRANGE, s_substring_move_right_x);
  while (i<e) CHARS (str2)[--j] = CHARS (str1)[--e];
  return UNSPECIFIED;
}


PROC (s_substring_fill_x, "substring-fill!", 2, 0, 1, scm_substring_fill_x);
#ifdef __STDC__
SCM
scm_substring_fill_x (SCM str, SCM start, SCM args)
#else
SCM
scm_substring_fill_x (str, start, args)
     SCM str;
     SCM start
     SCM args;
#endif
{
  SCM end, fill;
  long i, e;
  char c;
  ASSERT (2==scm_ilength (args), args, WNA, s_substring_fill_x);
  end = CAR (args); args = CDR (args);
  fill = CAR (args);
  ASSERT (NIMP (str) && STRINGP (str), str, ARG1, s_substring_fill_x);
  ASSERT (INUMP (start), start, ARG2, s_substring_fill_x);
  ASSERT (INUMP (end), end, ARG3, s_substring_fill_x);
  ASSERT (ICHRP (fill), fill, ARG4, s_substring_fill_x);
  i = INUM (start), e = INUM (end);c = ICHR (fill);
  ASSERT (i <= LENGTH (str) && i >= 0, start, OUTOFRANGE, s_substring_fill_x);
  ASSERT (e <= LENGTH (str) && e >= 0, end, OUTOFRANGE, s_substring_fill_x);
  while (i<e) CHARS (str)[i++] = c;
  return UNSPECIFIED;
}


PROC (s_string_null_p, "string-null?", 1, 0, 0, scm_string_null_p);
#ifdef __STDC__
SCM
scm_string_null_p (SCM str)
#else
SCM
scm_string_null_p (str)
     SCM str;
#endif
{
  ASSERT (NIMP (str) && ROSTRINGP (str), str, ARG1, s_string_null_p);
  return (LENGTH (str)
	  ? BOOL_F
	  : BOOL_T);
}


PROC (s_string_to_list, "string->list", 1, 0, 0, scm_string_to_list);
#ifdef __STDC__
SCM
scm_string_to_list (SCM str)
#else
SCM
scm_string_to_list (str)
     SCM str;
#endif
{
  long i;
  SCM res = EOL;
  unsigned char *src;
  ASSERT (NIMP (str) && STRINGP (str), str, ARG1, s_string_to_list);
  src = UCHARS (str);
  for (i = LENGTH (str)-1;i >= 0;i--) res = scm_cons ((SCM)MAKICHR (src[i]), res);
  return res;
}



PROC (s_string_copy, "string-copy", 1, 0, 0, scm_string_copy);
#ifdef __STDC__
SCM
scm_string_copy (SCM str)
#else
SCM
scm_string_copy (str)
     SCM str;
#endif
{
  ASSERT (NIMP (str) && STRINGP (str), str, ARG1, s_string_copy);
  return scm_makfromstr (CHARS (str), (sizet)LENGTH (str), 0);
}


PROC (s_string_fill_x, "string-fill!", 2, 0, 0, scm_string_fill_x);
#ifdef __STDC__
SCM
scm_string_fill_x (SCM str, SCM chr)
#else
SCM
scm_string_fill_x (str, chr)
     SCM str;
     SCM chr;
#endif
{
  register char *dst, c;
  register long k;
  ASSERT (NIMP (str) && STRINGP (str), str, ARG1, s_string_fill_x);
  ASSERT (ICHRP (chr), chr, ARG2, s_string_fill_x);
  c = ICHR (chr);
  dst = CHARS (str);
  for (k = LENGTH (str)-1;k >= 0;k--) dst[k] = c;
  return UNSPECIFIED;
}


#ifdef __STDC__
void
scm_init_strop (void)
#else
void
scm_init_strop ()
#endif
{
#include "strop.x"
}

