/* classes: h_files */

#ifndef _SCMH
#define _SCMH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */



/* This file is the private, general purpose include file for
 * the library sources.  It defines traditional SCM names for
 * many low-level macros.
 *
 */


#define DIGITS '0':case '1':case '2':case '3':case '4':\
 case '5':case '6':case '7':case '8':case '9'

/* LINE_INCREMENTORS are the characters which cause the line count to
 * be incremented for the purposes of error reporting.  This feature
 * is only used for scheme code loaded from files.
 *
 * WHITE_SPACES are other characters which should be treated like spaces
 * in programs.
 */

#define LINE_INCREMENTORS  '\n'
#define TAB '\t'
#ifdef MSDOS
# define SINGLE_SPACES  ' ':case '\r':case '\f':case 26
#else
# define SINGLE_SPACES  ' ':case '\r':case '\f'
#endif /* def MSDOS */
#define WHITE_SPACES  SINGLE_SPACES:case TAB

#ifdef _DCC
# define ASCII
#else
# if (('\n'=='\025') && (' '=='\100') && ('a'=='\201') && ('A'=='\301'))
#  define EBCDIC
# endif /*  (('\n'=='\025') && (' '=='\100') && ('a'=='\201') && ('A'=='\301')) */
# if (('\n'=='\012') && (' '=='\040') && ('a'=='\141') && ('A'=='\101'))
#  define ASCII
# endif /*  (('\n'=='\012') && (' '=='\040') && ('a'=='\141') && ('A'=='\101')) */
#endif /* def _DCC */




#ifdef STDC_HEADERS
# include <stdlib.h>
# ifdef AMIGA
#  include <stddef.h>
# endif /* def AMIGA */
# define sizet size_t
#else
# ifdef _SIZE_T
#  define sizet size_t
# else
#  define sizet unsigned int
# endif /* def _SIZE_T */
#endif /* def STDC_HEADERS */


#include "__scm.h"

#define tc3_cons		scm_tc3_cons
#define tc3_cons_gloc		scm_tc3_cons_gloc
#define tc3_closure		scm_tc3_closure

#define tc7_ssymbol		scm_tc7_ssymbol
#define tc7_msymbol		scm_tc7_msymbol
#define tc7_string		scm_tc7_string
#define tc7_bvect		scm_tc7_bvect
#define tc7_vector		scm_tc7_vector
#define tc7_lvector		scm_tc7_lvector
#define tc7_byvect		scm_tc7_byvect
#define tc7_ivect		scm_tc7_ivect
#define tc7_uvect		scm_tc7_uvect
#define tc7_svect		scm_tc7_svect
#define tc7_llvect		scm_tc7_llvect
#define tc7_wvect		scm_tc7_wvect
#define tc7_fvect		scm_tc7_fvect
#define tc7_dvect		scm_tc7_dvect
#define tc7_cvect		scm_tc7_cvect
#define tc7_port		scm_tc7_port
#define tc7_contin		scm_tc7_contin
#define tc7_cclo		scm_tc7_cclo
/* spare 69 71 77 79 */
#define tc7_subr_0		scm_tc7_subr_0
#define tc7_subr_1		scm_tc7_subr_1
#define tc7_cxr			scm_tc7_cxr
#define tc7_subr_3		scm_tc7_subr_3
#define tc7_subr_2		scm_tc7_subr_2
#define tc7_asubr		scm_tc7_asubr
#define tc7_subr_1o		scm_tc7_subr_1o
#define tc7_subr_2o		scm_tc7_subr_2o
#define tc7_lsubr_2		scm_tc7_lsubr_2
#define tc7_lsubr		scm_tc7_lsubr
#define tc7_rpsubr		scm_tc7_rpsubr

#define tc7_smob		scm_tc7_smob
#define tc_free_cell		scm_tc_free_cell

#define tc16_flo		scm_tc16_flo
#define tc_flo			scm_tc_flo

#define REAL_PART		SCM_REAL_PART
#define IMAG_PART		SCM_IMAG_PART
#define tc_dblr			scm_tc_dblr
#define tc_dblc			scm_tc_dblc

#define tc16_bigpos		scm_tc16_bigpos
#define tc16_bigneg		scm_tc16_bigneg

#define tc16_fport		scm_tc16_fport
#define tc16_pipe		scm_tc16_pipe
#define tc16_strport		scm_tc16_strport
#define tc16_sfport		scm_tc16_sfport



/* For cons pairs with immediate values in the CAR */
#define tcs_cons_imcar		scm_tcs_cons_imcar

/* For cons pairs		pairs with non-immediate values in the CAR */
#define tcs_cons_nimcar		scm_tcs_cons_nimcar

/* A CONS_GLOC occurs in code.  It's CAR is a pointer to the
 * CDR of a variable.  The low order bits of the CAR are 001.
 * The CDR of the gloc is the code continuation.
 */
#define tcs_cons_gloc		scm_tcs_cons_gloc

#define tcs_closures		scm_tcs_closures
#define tcs_subrs		scm_tcs_subrs
#define tcs_symbols		scm_tcs_symbols
#define tcs_bignums		scm_tcs_bignums



/* Extracting Tag Bits, With or Without GC Safety and Optional Bits
 */
#define TYP3		SCM_TYP3
#define TYP7		SCM_TYP7
#define TYP7S		SCM_TYP7S
#define TYP16		SCM_TYP16
#define TYP16S		SCM_TYP16S
#define GCTYP16		SCM_GCTYP16


/* Heap Pairs and the Empty List Predicates
 */
#define NULLP		SCM_NULLP
#define NNULLP		SCM_NNULLP
#define CELLP		SCM_CELLP
#define NCELLP		SCM_NCELLP

#define MOST_POSITIVE_FIXNUM	SCM_MOST_POSITIVE_FIXNUM
#define MOST_NEGATIVE_FIXNUM	SCM_MOST_NEGATIVE_FIXNUM
#define CHAR_CODE_LIMIT		SCM_CHAR_CODE_LIMIT

/* Testing and Changing GC Marks in Various Standard Positions
 */
#define GCMARKP		SCM_GCMARKP
#define GC8MARKP	SCM_GC8MARKP
#define SETGCMARK	SCM_SETGCMARK
#define CLRGCMARK	SCM_CLRGCMARK
#define SETGC8MARK	SCM_SETGC8MARK
#define CLRGC8MARK	SCM_CLRGC8MARK


#ifdef STACK_LIMIT
# define CHECK_STACK {scm_stack_check();}
#else
# define CHECK_STACK /**/
#endif /* def STACK_LIMIT */



#include "error.h"

#ifdef SCM_POINTERS_MUNGED
#define POINTERS_MUNGED
#endif

#define DEFER_INTS	SCM_DEFER_INTS
#define ALLOW_INTS	SCM_ALLOW_INTS
#define REDEFER_INTS	SCM_REDEFER_INTS
#define REALLOW_INTS	SCM_REALLOW_INTS
#define POLL		SCM_POLL

#define ASSERT		SCM_ASSERT
#define ASRTGO		SCM_ASRTGO

#define ARGn		SCM_ARGn
#define ARG1		SCM_ARG1
#define ARG2		SCM_ARG2
#define ARG3		SCM_ARG3
#define ARG4		SCM_ARG4
#define ARG5		SCM_ARG5
#define ARG6		SCM_ARG6
#define ARG7		SCM_ARG7
#define ARGERR		SCM_ARGERR

#define WNA		SCM_WNA
#define OVFLOW		SCM_OVFLOW
#define OUTOFRANGE	SCM_OUTOFRANGE
#define NALLOC		SCM_NALLOC
#define EXIT		SCM_EXIT
#define HUP_SIGNAL	SCM_HUP_SIGNAL
#define INT_SIGNAL	SCM_INT_SIGNAL
#define FPE_SIGNAL	SCM_FPE_SIGNAL
#define BUS_SIGNAL	SCM_BUS_SIGNAL
#define SEGV_SIGNAL	SCM_SEGV_SIGNAL
#define ALRM_SIGNAL	SCM_ALRM_SIGNAL



#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS SCM_EXIT_SUCCESS
#define EXIT_FAILURE SCM_EXIT_FAILURE
#endif

/* On VMS, GNU C's errno.h contains a special hack to get link attributes
 * for errno correct for linking to the C RTL.
 */
#include <errno.h>

/* SYSCALL retries system calls that have been interrupted (EINTR) */
#ifdef vms
# ifndef __GNUC__
#  include <ssdef.h>
#  define SYSCALL(line) do{errno = 0;line;} \
	while(EVMSERR==errno && (vaxc$errno>>3)==(SS$_CONTROLC>>3))
# endif /* ndef __GNUC__ */
#endif /* def vms */

#ifndef SYSCALL
# ifdef EINTR
#  if (EINTR > 0)
#   define SYSCALL(line) do{errno = 0;line;}while(EINTR==errno)
#  endif /*  (EINTR > 0) */
# endif /* def EINTR */
#endif /* ndef SYSCALL */

#ifndef SYSCALL
# define SYSCALL(line) {line;}
#endif /* ndef SYSCALL */

#ifndef MSDOS
# ifdef ARM_ULIB
    extern volatile int errno;
# else
    extern int errno;
# endif /* def ARM_ULIB */
#endif /* ndef MSDOS */
#ifdef __TURBOC__
# if (__TURBOC__==1)
 /* Needed for TURBOC V1.0 */
 extern int errno;
# endif /*  (__TURBOC__==1) */
#endif /* def __TURBOC__ */



#define SMOBNUM		SCM_SMOBNUM
#define PTOBNUM		SCM_PTOBNUM


#define ILOCP	SCM_ILOCP
#define ILOC00	SCM_ILOC00
#define IDINC	SCM_IDINC
#define ICDR	SCM_ICDR
#define IFRINC	SCM_IFRINC
#define IDSTMSK	SCM_IDSTMSK
#define IFRAME	SCM_IFRAME
#define IDIST	SCM_IDIST
#define ICDRP	SCM_ICDRP



#define ISYMP		SCM_ISYMP
#define IFLAGP		SCM_IFLAGP
#define ISYMNUM		SCM_ISYMNUM
#define ISYMCHARS	SCM_ISYMCHARS
#define MAKSPCSYM	SCM_MAKSPCSYM
#define MAKISYM		SCM_MAKISYM
#define MAKIFLAG	SCM_MAKIFLAG


#define IM_AND		SCM_IM_AND
#define IM_BEGIN	SCM_IM_BEGIN
#define IM_CASE		SCM_IM_CASE
#define IM_COND		SCM_IM_COND
#define IM_DO		SCM_IM_DO
#define IM_IF		SCM_IM_IF
#define IM_LAMBDA	SCM_IM_LAMBDA
#define IM_LET		SCM_IM_LET
#define IM_LETSTAR	SCM_IM_LETSTAR
#define IM_LETREC	SCM_IM_LETREC
#define IM_OR		SCM_IM_OR
#define IM_QUOTE	SCM_IM_QUOTE
#define IM_SET		SCM_IM_SET
#define IM_DEFINE	SCM_IM_DEFINE
#define IM_APPLY	SCM_IM_APPLY
#define IM_CONT		SCM_IM_CONT
#define NUM_ISYMS	SCM_NUM_ISYMS


/* Basic predicates */
#define IMP		SCM_IMP
#define NIMP		SCM_NIMP
#define UNBNDP		SCM_UNBNDP
#define UNSPECIFIED	SCM_UNSPECIFIED
#define EOF_VAL		SCM_EOF_VAL






/* Booleans */
#include "boolean.h"

#define BOOL_F		SCM_BOOL_F
#define BOOL_T		SCM_BOOL_T
#define FALSEP		SCM_FALSEP
#define NFALSEP		SCM_NFALSEP
#define BOOL_NOT	SCM_BOOL_NOT


#include "numbers.h"

/* IS_INF tests its floating point number for infiniteness
 */
#ifndef IS_INF
# define IS_INF(x) ((x)==(x)/2)
#endif

/* MAXEXP is the maximum double precision expontent
 * FLTMAX is less than or scm_equal the largest single precision float
 */

#ifdef FLOATS
# ifdef STDC_HEADERS
#  ifndef GO32
#   include <float.h>
#  endif /* ndef GO32 */
# endif /* def STDC_HEADERS */
# ifdef DBL_MAX_10_EXP
#  define MAXEXP DBL_MAX_10_EXP
# else
#  define MAXEXP 308   /* IEEE doubles */
# endif /* def DBL_MAX_10_EXP */
# ifdef FLT_MAX
#  define FLTMAX FLT_MAX
# else
#  define FLTMAX 1e+23
# endif /* def FLT_MAX */
#endif /* def FLOATS */


/* Immediate numbers -- exact integer data that fits 
 * within an SCM word.
 */
#define INUMP		SCM_INUMP
#define NINUMP		SCM_NINUMP
#define INUM0		SCM_INUM0
#define MAKINUM		SCM_MAKINUM
#define INUM		SCM_INUM
#define SRS		SCM_SRS

/* FIXABLE is non-0 if its long argument can be encoded in an INUM.
 */
#define POSFIXABLE	SCM_POSFIXABLE
#define NEGFIXABLE	SCM_NEGFIXABLE
#define UNEGFIXABLE	SCM_UNEGFIXABLE
#define FIXABLE		SCM_FIXABLE

#ifndef CHAR_BIT
#define CHAR_BIT	SCM_CHAR_BIT
#endif

#ifndef LONG_BIT
#define LONG_BIT	SCM_LONG_BIT
#endif

#define INTBUFLEN	SCM_INTBUFLEN
#define FLOBUFLEN	SCM_FLOBUFLEN

#define INEXP		SCM_INEXP
#define CPLXP		SCM_CPLXP
#define REAL		SCM_REAL
#define IMAG		SCM_IMAG
#define REALP		SCM_REALP
#define SINGP		SCM_SINGP
#define FLO		SCM_FLO
#define REALPART	SCM_REALPART
#define NUMBERP		SCM_NUMBERP
#define NUMP		SCM_NUMP
#define BIGP		SCM_BIGP
#define BIGSIGN		SCM_BIGSIGN
#define BDIGITS		SCM_BDIGITS
#define NUMDIGS		SCM_NUMDIGS
#define SETNUMDIGS	SCM_SETNUMDIGS


#define DIGSTOOBIG SCM_DIGSTOOBIG
#ifndef NO_BIGDIG
#define BIGDIG SCM_BIGDIG
#endif
#define BITSPERDIG SCM_BITSPERDIG
#define BIGRAD SCM_BIGRAD
#define DIGSPERLONG SCM_DIGSPERLONG
#define BIGUP SCM_BIGUP
#define BIGDN SCM_BIGDN
#define BIGLO SCM_BIGLO

#define string2number scm_string_to_number

#include "chars.h"

/* Immediate characters.
 */
#define ICHRP		SCM_ICHRP
#define ICHR		SCM_ICHR
#define MAKICHR		SCM_MAKICHR


/* Cons Pairs
 */
#include "pairs.h"

#define EOL	SCM_EOL

#define NCONSP	SCM_NCONSP
#define CONSP	SCM_CONSP
#define ECONSP	SCM_ECONSP
#define NECONSP	SCM_NECONSP

#define CAR	SCM_CAR
#define CDR	SCM_CDR
#define GCCDR	SCM_GCCDR
#define SETCDR	SCM_SETCDR

#define CAAR	SCM_CAAR
#define CDAR	SCM_CDAR
#define CADR	SCM_CADR
#define CDDR	SCM_CDDR

#define CAAAR	SCM_CAAAR
#define CDAAR	SCM_CDAAR
#define CADAR	SCM_CADAR
#define CDDAR	SCM_CDDAR
#define CAADR	SCM_CAADR
#define CDADR	SCM_CDADR
#define CADDR	SCM_CADDR
#define CDDDR	SCM_CDDDR

#define CAAAAR	SCM_CAAAAR
#define CDAAAR	SCM_CDAAAR
#define CADAAR	SCM_CADAAR
#define CDDAAR	SCM_CDDAAR
#define CAADAR	SCM_CAADAR
#define CDADAR	SCM_CDADAR
#define CADDAR	SCM_CADDAR
#define CDDDAR	SCM_CDDDAR
#define CAAADR	SCM_CAAADR
#define CDAADR	SCM_CDAADR
#define CADADR	SCM_CADADR
#define CDDADR	SCM_CDDADR
#define CAADDR	SCM_CAADDR
#define CDADDR	SCM_CDADDR
#define CADDDR	SCM_CADDDR
#define CDDDDR	SCM_CDDDDR


#define CELLPTR	SCM_CELLPTR
#define PTR_LT	SCM_PTR_LT

#define NEWCELL SCM_NEWCELL


#include "smob.h"


#include "symbols.h"

#define SYMBOLP		SCM_SYMBOLP
#define ROSTRINGP	SCM_ROSTRINGP
#define LENGTH		SCM_LENGTH
#define LENGTH_MAX	SCM_LENGTH_MAX
#define SETLENGTH	SCM_SETLENGTH
#define SETCHARS	SCM_SETCHARS
#define CHARS		SCM_CHARS
#define UCHARS		SCM_UCHARS
#define SLOTS		SCM_SLOTS
#define SYMBOL_SLOTS	SCM_SYMBOL_SLOTS
#define SYMBOL_FUNC	SCM_SYMBOL_FUNC
#define SYMBOL_PROPS	SCM_SYMBOL_PROPS
#define SYMBOL_HASH	SCM_SYMBOL_HASH

#define intern scm_intern


#include "strings.h"

#define STRINGP		SCM_STRINGP
#define NSTRINGP	SCM_NSTRINGP

#define makfromstr(STR,LEN) scm_makfromstr((STR), (LEN), 0)



#include "strop.h"



#include "kw.h"

#define tc16_kw		scm_tc16_kw
#define KEYWORDP	SCM_KEYWORDP
#define KEYWORDSYM	SCM_KEYWORDSYM



#include "variable.h"

#define tc16_variable		scm_tc16_variable

#define VARVCELL		SCM_VARVCELL
#define VARIABLEP		SCM_VARIABLEP
#define UDVARIABLEP		SCM_UDVARIABLEP
#define DEFVARIABLEP		SCM_DEFVARIABLEP



#include "vectors.h"

#define VECTORP		SCM_VECTORP
#define NVECTORP	SCM_NVECTORP
#define VELTS		SCM_VELTS
#define SETVELTS	SCM_SETVELTS


#include "lvectors.h"

#define LVECTORP	SCM_LVECTORP
#define LVECTOR_KEY	SCM_LVECTOR_KEY
#define LV_REF_FN	SCM_LV_REF_FN
#define LV_SET_FN	SCM_LV_SET_FN
#define LV_PRINT_FN	SCM_LV_PRINT_FN
#define LV_EQUAL_FN	SCM_LV_EQUAL_FN
#define LV_ISA_FN	SCM_LV_ISA_FN


#include "weaks.h"

#define WVECTP SCM_WVECTP
#define WHVECTP SCM_WHVECTP



#define MALLOCDATA SCM_MALLOCDATA
#define MALLOCLEN SCM_MALLOCLEN
#define WORDDATA SCM_WORDDATA



#define BYTECODEP SCM_BYTECODEP
#define BYTECODE_CONSTANTS SCM_BYTECODE_CONSTANTS
#define BYTECODE_CODE SCM_BYTECODE_CODE
#define BYTECODE_NAME SCM_BYTECODE_NAME
#define BYTECODE_BCODE SCM_BYTECODE_BCODE
#define BYTECODE_ELTS SCM_BYTECODE_ELTS



#include "unif.h"

#define ARRAYP			SCM_ARRAYP
#define ARRAY_V			SCM_ARRAY_V
#define ARRAY_NDIM		SCM_ARRAY_NDIM
#define ARRAY_CONTIGUOUS	SCM_ARRAY_CONTIGUOUS
#define ARRAY_CONTP		SCM_ARRAY_CONTP
#define ARRAY_BASE		SCM_ARRAY_BASE
#define ARRAY_DIMS		SCM_ARRAY_DIMS

extern SCM scm_resizuve();



#include "ramap.h"


#include "struct.h"

#define struct_i_name		scm_struct_i_name
#define struct_i_vcell		scm_struct_i_vcell
#define struct_i_format		scm_struct_i_format
#define struct_i_refcnt		scm_struct_i_refcnt
#define struct_i_self		scm_struct_i_self
#define struct_i_sekrit		scm_struct_i_sekrit
#define struct_i_vtab_size	scm_struct_i_vtab_size
#define struct_i_vtab		scm_struct_i_vtab
#define n_struct_header		scm_n_struct_header

#define STRUCT_TYPE_NAME	SCM_STRUCT_TYPE_NAME
#define STRUCT_TYPE_VCELL	SCM_STRUCT_TYPE_VCELL
#define STRUCT_TYPE_FORMAT	SCM_STRUCT_TYPE_FORMAT
#define STRUCT_TYPE_REFCNT	SCM_STRUCT_TYPE_REFCNT
#define STRUCT_TYPE_SELF	SCM_STRUCT_TYPE_SELF
#define STRUCT_TYPE_SEKRIT	SCM_STRUCT_TYPE_SEKRIT
#define STRUCT_TYPE_VTAB_SIZE	SCM_STRUCT_TYPE_VTAB_SIZE
#define STRUCT_TYPE_VTAB	SCM_STRUCT_TYPE_VTAB
#define STRUCT_TYPEP		SCM_STRUCT_TYPEP

#define STRUCTP			SCM_STRUCTP
#define STRUCT_TYPE_DATA	SCM_STRUCT_TYPE_DATA



#include "procs.h"

#define SNAME		SCM_SNAME
#define SUBRF		SCM_SUBRF
#define DSUBRF		SCM_DSUBRF
#define CCLO_SUBR	SCM_CCLO_SUBR
#define CLOSUREP	SCM_CLOSUREP
#define CLOSCAR		SCM_CLOSCAR
#define CODE		SCM_CODE
#define PROCPROPS	SCM_PROCPROPS
#define SETCODE		SCM_SETCODE
#define ENV		SCM_ENV
#define TOP_LEVEL	SCM_TOP_LEVEL

#define make_subr scm_make_subr
#define makcclo scm_makcclo


#include "gsubr.h"



#include "ports.h"

/* PORT FLAGS
 * A set of flags caracterizes a port.
 */
#define OPN		SCM_OPN
#define RDNG		SCM_RDNG
#define WRTNG		SCM_WRTNG
#define BUF0		SCM_BUF0
#define CRDY		SCM_CRDY
#define CUC		SCM_CUC

#define PORTP		SCM_PORTP
#define OPPORTP		SCM_OPPORTP
#define OPINPORTP	SCM_OPINPORTP
#define OPOUTPORTP	SCM_OPOUTPORTP
#define FPORTP		SCM_FPORTP
#define OPFPORTP	SCM_OPFPORTP
#define OPINFPORTP	SCM_OPINFPORTP
#define OPOUTFPORTP	SCM_OPOUTFPORTP

#define INPORTP		SCM_INPORTP
#define OUTPORTP	SCM_OUTPORTP
#define OPENP		SCM_OPENP
#define CLOSEDP		SCM_CLOSEDP
#define STREAM		SCM_STREAM
#define SETSTREAM	SCM_SETSTREAM
#define CRDYP		SCM_CRDYP
#define CLRDY		SCM_CLRDY
#define CGETUN		SCM_CGETUN
#define CUNGET		SCM_CUNGET

#define DIRP		SCM_DIRP
#define OPDIRP		SCM_OPDIRP




#include "vports.h"
#include "fports.h"
#include "strports.h"



#include "eq.h"



#include "dynwind.h"



#include "continuations.h"



#include "time.h"



#include "hash.h"



#include "files.h"



#include "arbiters.h"



#include "throw.h"



#include "eval.h"

#define eval scm_eval
#define apply scm_apply
#define cons scm_cons 



#include "feature.h"



#include "scmsigs.h"



#include "simpos.h"




/* GC */

#include "gc.h"

#define STACKITEM		SCM_STACKITEM

#define cur_inp			scm_cur_inp
#define cur_outp		scm_cur_outp
#define cur_errp		scm_cur_errp
#define def_inp			scm_def_inp
#define def_outp		scm_def_outp
#define def_errp		scm_def_errp
#define listofnull		scm_listofnull
#define undefineds		scm_undefineds
#define nullvect		scm_nullvect
#define nullstr			scm_nullstr
#define symhash			scm_symhash
#define progargs		scm_progargs
#define transcript		scm_transcript
#define rootcont		scm_rootcont
#define dynwinds		scm_dynwinds
#define symhash_vars		scm_symhash_vars
#define permobjs		scm_permobjs
#define flo0			scm_flo0
#define kw_obarray		scm_kw_obarray
#define type_obj_list		scm_type_obj_list
#define first_type		scm_first_type
#define NUM_PROTECTS		SCM_NUM_PROTECTS

#define PTR_GT		SCM_PTR_GT
#define PTR_LE		SCM_PTR_LE
#define PTR_GE		SCM_PTR_GE



#include "stackchk.h"



/* Repl.c */
#include "repl.h"



#ifdef DEBUG_EXTENSIONS
#include "debug.h"

typedef struct scm_mode_flag mode_flag;

extern SCM (*scm_ceval_ptr) P ((SCM exp, SCM env));
extern int scm_debug_state;
extern int scm_check_entry;
extern int scm_check_exit;
extern struct scm_mode_flag scm_debug_flags[];

#define RECORD_PROCNAMES scm_debug_flags[0].val
#define TRACE_CALLS      scm_debug_flags[1].val
#define SINGLE_STEP      scm_debug_flags[2].val
#define BREAKPOINTS      scm_debug_flags[3].val
#define BACKTRACE        scm_debug_flags[4].val
#define N_DEBUG_FLAGS 5
#define CHECK_ENTRY      scm_check_entry
#define CHECK_EXIT       scm_check_exit

extern struct scm_mode_flag scm_print_flags[];

#define PRINT_PROCNAMES  scm_print_flags[0].val
#define N_PRINT_FLAGS 1

/* Source Properties */
extern long tc16_srcprops;
typedef struct scm_srcprops
{
  SCM car;
  SCM cdr;
  SCM fname;
  SCM copy;
} scm_srcprops;
#define SRCPROPS_NCELLS 2

#define SRCPROPSP(p) (TYP16 (p) == tc16_srcprops)
#define SRCPROPBRK(p) ((1L << 16) & CAR (p) ? BOOL_T : BOOL_F)
#define SRCPROPLINE(p) (CDR (p) >> 12)
#define SRCPROPCOL(p) (CDR (p) & 0x0fffL)
#define SRCPROPFNAME(p) ((scm_srcprops *) (p))->fname
#define SRCPROPCOPY(p) ((scm_srcprops *) (p))->copy
#define SETSRCPROPBRK(p) {CAR (p) = CAR (p) | (1L << 16);}
#define CLEARSRCPROPBRK(p) {CAR (p) = CAR (p) & ~(1L << 16);}
#define SETSRCPROPPOS(p,l,c) SETCDR (p, ((l) << 12) + (c))
#define SETSRCPROPLINE(p,l) SETCDR (p, ((l) << 12) + SRCPROPCOL (p))
#define SETSRCPROPCOL(p,c) SETCDR (p, CDR (p) & ~0x0fffL + (c))

#define SRCBRKPROP(x) ((t.arg1 = scm_weak_hash_lookup (scm_object_whash, (x))) != BOOL_F\
		       && NIMP (t.arg1)\
		       && (SRCPROPSP (t.arg1)\
			   || (CONSP (t.arg1) && SRCPROPSP (t.arg1 = CAR (t.arg1))))\
		       && (1L << 16) & CAR (t.arg1))

/* Evaluator */
typedef struct scm_debug_info debug_info;

#define BIGPTR ((void *) -4)
#define DEBUGGINGP scm_debug_state
#define EVAL(x, env) (IMP(x) \
		      ? (x) \
		      : (*scm_ceval_ptr) ((x), (env)))
#define DSIDEVAL(x, env) if NIMP(x) scm_deval((x), (env))

#else

#define EVAL(x, env) (IMP(x)?(x):scm_ceval((x), (env)))
#endif /* DEBUG_EXTENSIONS */

#define SCM_CEVAL scm_ceval
#define SCM_APPLY scm_apply
#define SIDEVAL(x, env) if NIMP(x) SCM_CEVAL((x), (env))

#ifdef READER_EXTENSIONS
extern struct scm_mode_flag scm_read_flags[];

#define RECORD_POSITIONS scm_read_flags[0].val
#define COPY_SOURCE      scm_read_flags[1].val
#define N_READ_FLAGS 2
#endif




#ifndef SCM_MAGIC_SNARFER
#define PROC(RANAME, STR, REQ, OPT, VAR, CFN)  \
	static char RANAME[]=STR;
#define PROC1(RANAME, STR, TYPE, CFN)  \
	static char RANAME[]=STR;
#else
#define PROC(RANAME, STR, REQ, OPT, VAR, CFN)  \
%%% scm_make_gsubr (RANAME, REQ, OPT, VAR, CFN)
#define PROC1(RANAME, STR, TYPE, CFN)  \
%%% scm_make_subr(RANAME, TYPE, CFN)
#endif





#define long2num	scm_long2num
#define scm_vector2list	scm_vector_to_list
#define scm_string2list	scm_string_to_list
#define scm_lputs	scm_puts
#define scm_lputc	scm_putc
#define scm_equal	scm_equal_p
#define scm_my_time	scm_get_internal_run_time
#define scm_your_time	scm_get_internal_real_time
#define scm_procedurep	scm_procedure_p
#define scm_eqp		scm_eq_p
#define scm_lessp	scm_less_p

extern void scm_init_ramap ();
extern void scm_init_unif ();

#ifdef __STDC__

#else /* STDC */

#endif /* STDC */


#endif  /* _SCMH */
