/* 
 * pvfsine.c
 *
 * pvfsine.c -- cc -I.. -o pvfsine pvfsine.c pvflib.o -lm 
 *
 */
 
char pvfsine_c[] = "$Id: pvfsine.c,v 1.5 1995/03/29 18:27:17 marc Exp $";

#include <stdio.h>
#include <math.h>

#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif

#include "../mgetty.h"
#include "pvflib.h"

int
pvfsine _P2((argc, argv), int argc, char **argv ) {
    FILE *out=stdout;
    double freq;
    int time, i;

    if( argc<=2 ) USAGE("<time> <frequency>");

    time=(int)(RATE*atof(argv[1]));
    freq=atof(argv[2]);

    if( !time || !freq ) USAGE("<time> <frequency>");    

    for(i=0; i<time; i++ ) {
	int d;
	
	d=(int)(sin((double)i *2*M_PI * freq / RATE)*0x7fff);
	zput(d, out );
    }
    return 0;
}

