
#include "super.h"
#include "version.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Processes the special ":" builtin commands */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*	Return -1 if caller should give up parsing the file;
 *	return 0 on success;
 */
int
process_colon_cmds(command)
char *command;
{
    if ((strcmp(":global", command) == 0) ||
	(strcmp(":global_options", command) == 0) ||
	(strcmp("/", command) == 0)	/*obsolescent*/
	) {

	/* Process global options */
	return colon_global(command);

    } else if (strcmp(":define", command) == 0) {

	/* Process variable definition */
	return colon_define(command);

    } else if (strcmp(":include", command) == 0) {

	/* Process include-file directive */
	return colon_include(command);
    }

    return Error(0, 0, "%t\n\tUnknown builtin command `%s'.\n", command);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Process the :global command */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int
colon_global(command)
char *command;
{
    if (strcmp("/", command) == 0) {
	/* OBSOLESCENT COMMAND */
	/* Get the full path; verify that it is '/', then discard  */
	char *path = strqtokS(NULL, SEP, NULL, NULL, 1);
	if (!command || !*path || strcmp(path, "/") != 0)
	return Error(0, 0, "%t\n\tformat error in super.tab file: \
Cmd == '/' requires FullPathName == '/'.\n");
    }

    /* Some global settings need to be reset on each new :global line. */
    if (handle_option(NULL, NULL, 1) != 0)
	return -1;

    if (*gi.log.filename != '\0')
	opensuperlog();
    return 0;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Process a global arg */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int
global_arg(word)
char *word;	/* opt=xxx or condition~Pattern or PermittedUserPattern */
{
    /* Return 0 on success, -1 if formatting error. */
    extern int error_syslog;
    int invert, iscondition;
    char *s;

    if (strcmp("\\", word) == 0)
	return 0;

    s = word;
    if (*s == CONDITION_SEP || *s == OPTION_SEP)
	return Error(0, 0, "%t\n\tBad super.tab syntax: <%s>\n", word);
    for (s++; *s && ((*s != CONDITION_SEP && *s != OPTION_SEP) ||
					    (*(s-1) == '\\')); s++)
	    ;

    invert = (*word == '!');
    if (invert && *s == OPTION_SEP) {
	return Error(0, 0,
	    "%t\n\tsuper.tab syntax error: options cannot be negated: <%s>\n",
	    word);
    } else if (invert) {
	word++;
    }
    /* Note that word has been advanced past the '!' inversion character */

    if (strcmp(word, "<>") == 0) {
	/* End of gi.before list.  Since we accumulate into
	 * gi.after list, just move that list over to
	 * gi.before.
	 */
	if (invert)
	    return Error(0, 0, "%t\n\tInvalid global condition \"!<>\"\n");

	if (gi.use_after != 0)
	    return Error(0, 0, "%t\n\tMultiple use of `<>' in :global list.\n");

	gi.use_after = 1;
	gi.userbefore.next = gi.userafter.next;
	gi.userafter.next = NULL;

	gi.timebefore.next = gi.timeafter.next;
	gi.timeafter.next = NULL;

	return 0;
    }

    iscondition = (*s != OPTION_SEP);
    if (iscondition && STRMATCH3("user", word, s)) {
	/* It's a PermittedUser pattern */
	if (*s == CONDITION_SEP)
	    s++;

	/* It's a user/group/host pattern.  Put it into the after list.
	 * If we eventually see "<>", we'll move the list to
	 * before list (see above).
	 */
	if (gi.user_clear) {
	    free_Simple2List(&gi.userbefore);
	    free_Simple2List(&gi.userafter);
	    free_SimpleList(&gi.b_a_text);
	    gi.user_clear = 0;
	}
	if (InsertUserList(s, &gi.userafter, &gi.b_a_text, invert) == -1)
	    return -1;

    } else if (iscondition && STRMATCH3("time", word, s)) {
	/* It's a PermittedTime pattern.  Put it into the after list.
	 * If we eventually see "<>", we'll move the list to
	 * before list (see above).
	 */
	s++;
	if (gi.time_clear) {
	    free_TimeList(&gi.timebefore);
	    free_TimeList(&gi.timeafter);
	    gi.time_clear = 0;
	}
	if (InsertTimeList(s, &gi.timeafter,  "global", invert) == -1)
	    return -1;

    } else if (iscondition) {
	return Error(0, 0,
	"%t\n\tInternal error -- unrecognized global condition <%s>\n", word);
	
    } else {
	return handle_option(word, s+1, 1);
    }
    return 0;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Process the :define command */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int
colon_define(command)
char *command;
{
    extern char *strqS_start;
    char *varname, *varbody;
    char *s;

    varname = strqtokS(NULL, SEP, NULL, NULL, 1);
    if (!varname)
	return Error(0, 0, "%t\n\tformat error in super.tab file: \
variable name missing after ':define'.\n");

    varbody = strqS_start;
    if (!varbody)
	varbody = "";

    /* Skip leading whitespace in variable body */
    while (strchr(SEP, *varbody))
	varbody++;

    /* Delete final newline from varbody */
    s = varbody + strlen(varbody)-1;
    if (s >= varbody && *s == '\n')
	*s = '\0';

    return add_variable(varname, varbody);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Process the :include command */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int
colon_include(command)
char *command;
{
    char *filename, *wd, *s;
    extern char *strqS_start;
    FileList *fl;

    filename = strqtokS(NULL, SEP, NULL, NULL, 1);
    if (!filename)
	return Error(0, 0, "%t\n\tformat error in super.tab file: \
filename missing after ':include'.\n");

    wd = strqS_start;
    if (wd && *wd != '\n' && *wd != '\0')
	return Error(0, 0, "%t\n\tformat error in super.tab file: \n\t\
extra text <%s> after :include filename\n", wd);

    /* Check for and delete possible newline from filename */
    s = filename + strlen(filename)-1;
    if (s >= filename && *s == '\n')
	*s = '\0';

    fl = file_open(currfile, filename);
    if (!fl)
	return -1;

    currfile = fl;
    return 0;
}

