//@Man: toolbar.C
//@{
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor 	 
*	    Copyright (C) 1995 1996  Matthias Ettrich
*
*           This file is Copyright 1996
*           Lars Gullik Bjnnes
*
*======================================================*/

//  Added pseudo-action handling, asierra 180296

#include "config.h"

#include <stdio.h>
#include "forms.h"

#include "lyx.h"
#include "toolbar.h"
#include "xdefinitions.h"
#include "keybind.h"
#include "lyxlex.h"
#include "combox.h"
#include "lyx_cb.h"
#include "minibuffer.h"

#ifdef TWO_COLOR_ICONS
#include "cut_bw.xpm"
#include "emph_bw.xpm"
#include "fig_bw.xpm"
#include "foot_bw.xpm"
#include "math_bw.xpm"
#include "form_bw.xpm"
#include "depth_bw.xpm"
#include "margin_bw.xpm"
#include "melt_bw.xpm"
#include "copy_bw.xpm"
#include "noun_bw.xpm"
#include "paste_bw.xpm"
#include "free_bw.xpm"
#include "tab_bw.xpm"
#include "tex_bw.xpm"
#include "open_bw.xpm"
#include "close_bw.xpm"
#include "save_bw.xpm"
#include "print1_bw.xpm"
#include "quit_bw.xpm"
// #include "unknown_bw.xpm" // unused
#else 
#include "cut.xpm"
#include "emph.xpm"
#include "fig.xpm"
#include "foot.xpm"
#include "math.xpm"
#include "form.xpm"
#include "depth.xpm"
#include "margin.xpm"
#include "melt.xpm"
#include "copy.xpm"
#include "noun.xpm"
#include "paste.xpm"
#include "free.xpm"
#include "tab.xpm"
#include "tex.xpm"
#include "open.xpm"
#include "close.xpm"
#include "save.xpm"
#include "print1.xpm"
#include "quit.xpm"
// #include "unknown.xpm" // unused
#endif

extern FD_form_main *fd_form_main;
extern void LayoutsCB(int);
extern char** get_pixmap_from_symbol(const char *arg, int, int);

///
enum _tooltags {
	TO_ADD = 1,
	TO_ENDTOOLBAR,
        TO_SEPARATOR,
        TO_LAYOUTS,
        TO_NEWLINE,
	TO_LAST
};

///
struct keyword_item toolTags[TO_LAST-1] = {
	{ "\\add", TO_ADD },
	{ "\\end_toolbar", TO_ENDTOOLBAR },
        { "\\layouts", TO_LAYOUTS },
        { "\\newline", TO_NEWLINE },
        { "\\separator", TO_SEPARATOR }
};

///
static FL_OBJECT *bubble_timer = NULL;

/// this is the toolbar object
Toolbar toolbar;


/// timer-cb for bubble-help (Matthias)
void Toolbar::BubbleTimerCB(FL_OBJECT *, long data){
	FL_OBJECT* ob = (FL_OBJECT*) data;
	char* help = (char*) ob->u_vdata;
	fl_show_oneliner(help, ob->form->x + ob->x,
			 ob->form->y + ob->y + ob->h);
}


/// post_handler for bubble-help (Matthias)
int Toolbar::BubblePost(FL_OBJECT *ob, int event,
	     FL_Coord mx, FL_Coord my, int key, void *xev)
{
	char* help = (char*) ob->u_vdata;
	if(event == FL_ENTER && help){
		fl_set_object_callback(bubble_timer,
				       BubbleTimerCB, (long) ob);
		fl_set_timer(bubble_timer, 1);
	}
	else if(event != FL_MOTION){
		fl_set_timer(bubble_timer, 0);
		fl_hide_oneliner();
	}
	return 0;
}

///
void Toolbar::activate()
{
	toolbarItem *item, *tmp=NULL;
	item = toollist;
	while(item){
		tmp = item->next;
		if (item->icon) {
			fl_activate_object(item->icon);
		}
		item = tmp;
	}
}

///
void Toolbar::deactivate()
{
	toolbarItem *item, *tmp=NULL;
	item = toollist;
	while(item){
		tmp = item->next;
		if (item->icon) {
			fl_deactivate_object(item->icon);
		}
		item = tmp;
	}
}

///
void Toolbar::ToolbarCB(FL_OBJECT *ob, long ac)
{
	char *res;
	if((res = DispatchFunction(ac, NULL, ob)))
		fprintf(stderr, "%s\n", res);
}

///
int Toolbar::get_toolbar_func(const char *func)
{
	int action;
	action = LookupLyxFunc(func);
	if (action == -1) {
		if (StringEqual(func, "tool-seperator")){
			action = TOOL_SEPERATOR;
		} else if (StringEqual(func, "tool-layouts")){
			action = TOOL_LAYOUTS;
		} else action = 0;
	}
	return action;
}

///
void Toolbar::init()
{
	add(TOOL_LAYOUTS);
	add(LFUN_MENUOPEN);
	//add(LFUN_CLOSEBUFFER);
	add(LFUN_MENUWRITE);
	add(LFUN_MENUPRINT);
	add(TOOL_SEPERATOR);

	add(LFUN_CUT);
	add(LFUN_COPY);
	add(LFUN_PASTE);
	add(TOOL_SEPERATOR);
	
	add(LFUN_EMPH);
	add(LFUN_NOUN);
	add(LFUN_FREE);
	add(TOOL_SEPERATOR);
	
	add(LFUN_FOOTMELT);
	add(LFUN_MARGINMELT);
	add(LFUN_DEPTH);
	add(TOOL_SEPERATOR);

	add(LFUN_TEX);
        add(LFUN_MATH_MODE);
	add(TOOL_SEPERATOR);

	add(LFUN_FIGURE);
	add(LFUN_TABLE);
	//add(LFUN_MELT);
	set();
}

///
void Toolbar::set()
{
	// we shoulden't set if we have not cleaned
	if (!cleaned) return;
	
	toolbarItem *item;
	FL_OBJECT *obj;
	item = toollist;
	
	fl_freeze_form(fd_form_main->form_main);
	fl_addto_form(fd_form_main->form_main);

	// add the time if it don't exist
	if (bubble_timer == NULL)
		bubble_timer = fl_add_timer(FL_HIDDEN_TIMER,
					    xpos,ypos,0,0,"Timer");
	
	while(item != NULL)
		switch(item->action){
		  case TOOL_SEPERATOR:
			  xpos += sepspace;
			  item = item->next;
			  break;
		  case TOOL_LAYOUTS:
			  xpos += standardspacing;
			  combox->add(xpos, ypos, 135, height, 300);
			  combox->setcallback(LayoutsCB);
			  combox->resize(FL_RESIZE_ALL);
			  combox->gravity(NorthWestGravity, NorthWestGravity);
			  item = item->next;
			  xpos += 135;
			  break;
		  default:
			  xpos += standardspacing;
			  item->icon = obj =
				  fl_add_pixmapbutton(FL_NORMAL_BUTTON,
						      xpos,ypos,
						      buttonwidth,
						      height,"");
			  fl_set_object_boxtype(obj,FL_UP_BOX);
			  fl_set_object_color(obj,FL_MCOL,FL_BLUE);
			  fl_set_object_resize(obj, FL_RESIZE_ALL);
			  fl_set_object_gravity(obj,
						NorthWestGravity,
						NorthWestGravity);
			  fl_set_object_callback(obj,ToolbarCB,
						 (long)item->action);

			  // set the bubble-help (Matthias)
			  obj->u_vdata = item->help;
			  fl_set_object_posthandler(obj, BubblePost);

			  fl_set_pixmapbutton_data(obj,item->pixmap);
			  item = item->next;
			  // we must remember to update the positions
			  xpos += buttonwidth;
			  // ypos is constant
			  /* Here will come a check to see if the new
			   * pos is within the bounds of the main frame,
			   * and perhaps wrap the toolbar if not.
			   */
			  break;
		}

	fl_end_form();
	fl_unfreeze_form(fd_form_main->form_main);

	// I wish we could do something else than to redraw the whole form
	// here. I tried XFlush() that did not work, maybe it would be
	// enough to redraw all the toolbar objects? Naaa, I don't think that
	// will do it either.
	fl_redraw_form(fd_form_main->form_main);
	
	cleaned = false;
}

///
char **Toolbar::getPixmap(kb_action action, char *arg)
{
	char **pixmap = NULL;
	switch(action){
	  case LFUN_MENUOPEN:    pixmap = open_xpm; break;
	  case LFUN_CLOSEBUFFER: pixmap = close_xpm; break;
	  case LFUN_MENUPRINT:   pixmap = print1_xpm; break;
	  case LFUN_MENUWRITE:   pixmap = save_xpm; break;
	  case LFUN_EMPH:	 pixmap = emph_xpm; break;
	  case LFUN_NOUN:        pixmap = noun_xpm; break;
	  case LFUN_FREE:        pixmap = free_xpm; break;
	  case LFUN_FOOTMELT:    pixmap = foot_xpm; break;
	  case LFUN_DEPTH:       pixmap = depth_xpm; break;
	  case LFUN_COPY:        pixmap = copy_xpm; break;
	  case LFUN_CUT:         pixmap = cut_xpm; break;
	  case LFUN_PASTE:       pixmap = paste_xpm; break;
	  case LFUN_TEX:         pixmap = tex_xpm; break;
	  case LFUN_FORMULA:     pixmap = form_xpm; break;
	  case LFUN_MATH_MODE:   pixmap = math_xpm; break;
	  case LFUN_MARGINMELT:  pixmap = margin_xpm; break;
	  case LFUN_FIGURE:      pixmap = fig_xpm; break;
	  case LFUN_TABLE:       pixmap = tab_xpm; break;
	  case LFUN_MELT:        pixmap = melt_xpm; break;
	  case LFUN_QUIT:        pixmap = quit_xpm; break;
	  case LFUN_INSERT_MATH:
		  if (arg)
			  pixmap = get_pixmap_from_symbol(arg,
							  buttonwidth,
							  height);
		  break;
	  default:
		  break;
	}
	return pixmap;
}


/// returns the bubble help text (Matthias)
char *Toolbar::getHelp(kb_action action, char *arg)
{
	char *help  = NULL;
	switch(action){
	  case LFUN_MENUOPEN:    help = "Open"; break;
	  case LFUN_CLOSEBUFFER: help = "Close"; break;
	  case LFUN_MENUPRINT:   help = "Print"; break;
	  case LFUN_MENUWRITE:   help = "Save"; break;
	  case LFUN_EMPH:	 help = "Toggle emphasize style"; break;
	  case LFUN_NOUN:        help = "Toggle noun style"; break;
	  case LFUN_FREE:        help = "Toggle user defined style"; break;
	  case LFUN_FOOTMELT:    help = "Footnote"; break;
	  case LFUN_DEPTH:       help = "Change environment depth"; break;
	  case LFUN_COPY:        help = "Copy"; break;
	  case LFUN_CUT:         help = "Cut"; break;
	  case LFUN_PASTE:       help = "Paste"; break;
	  case LFUN_TEX:         help = "Toggle TeX style"; break;
	  case LFUN_FORMULA:     help = "Toggle formula style"; break;
	  case LFUN_MATH_MODE:   help = "Set math mode"; break;
	  case LFUN_MARGINMELT:  help = "Margin note"; break;  
	  case LFUN_FIGURE:      help = "Insert Figure"; break;
	  case LFUN_TABLE:       help = "Insert Table"; break;
	  case LFUN_MELT:        help = "Melt Float"; break;
	  case LFUN_QUIT:        help = "Quit LyX"; break;
	  default:
		  break;
	}
	return help;
}

///
void Toolbar::add(int action, bool doclean)
{
	if (doclean && !cleaned) clean();

	// this is what we do if we want to add to an existing
	// toolbar.
	if (!doclean) {
		// first hide the toolbar buttons. This is not a real hide
		// actually it deletes and frees the button altogether.
		toolbarItem *item, *tmp=NULL;
		item = toollist;

		lightReset();
		
		fl_freeze_form(fd_form_main->form_main);
		while(item){
			tmp = item->next;
			if (item->icon) {
				fl_delete_object(item->icon);
				fl_free_object(item->icon);
			}
			item = tmp;
		}
		if (combox) {
			//combox->remove();
			delete combox;
			combox = NULL;
		}
		fl_unfreeze_form(fd_form_main->form_main);
		cleaned = true; // this is not completely true, but OK anyway
	}
	
	// there exist some special actions not part of
	// kb_action: TOOL_SEPERATOR, TOOL_LAYOUTS
	char **pixmap = NULL;
	char* help = NULL;

	toolbarItem *newItem,*tmp;

	if (IsPseudoAction(action)) {
		char *arg;
		kb_action act = (kb_action)retrieve_action_arg(action, &arg);
		pixmap = getPixmap(act, arg);
		help = getHelp(act, arg);
		//fprintf(stderr,"Pseudo action %d\n", action);
	} else {
		pixmap = getPixmap((kb_action)action);
		help = getHelp((kb_action)action);
	}
	
	// adds an item to the list
	if (pixmap != NULL
	    || action == TOOL_SEPERATOR
	    || action == TOOL_LAYOUTS)
	{
		newItem = new toolbarItem;
		newItem->action = action;
		newItem->pixmap = pixmap;
		newItem->help = help;
		// the new item is placed at the end of the list
		tmp = toollist;
		if (tmp != NULL){
			while(tmp->next != NULL)
				tmp = tmp->next;
			// here is tmp->next == NULL
			tmp->next = newItem;
		} else
			toollist = newItem;
	}
	if (action == TOOL_LAYOUTS) {
		combox = new Combox(FL_COMBOX_DROPLIST);
	}
}

///
void Toolbar::add(const char *func, bool doclean)
{
	int tf;
	tf = get_toolbar_func(func);

	if (!tf){
		fprintf(stderr,
			"Toolbar::add: no LyX"
			" command `%s' exists!\n",
			func);
	} else {
		add(tf, doclean);
	}
}

///
void Toolbar::clean()
{
	toolbarItem *item, *tmp= NULL;
	item = toollist;

	reset();

	//now delete all the objects...
	fl_freeze_form(fd_form_main->form_main);
	while(item){
		tmp = item->next;
		delete item;
		item = tmp;
	}
	if (combox) {
		//combox->remove();
		delete combox;
		combox = NULL;
	}
	fl_unfreeze_form(fd_form_main->form_main);
	cleaned = true;
}

///
void Toolbar::push(int nth)
{
	if (lyx_debug_level & DEBUG_TOOLBAR) {
		fprintf(stderr, "Toolbar::push: trying to trigger no `%d'\n",
			nth);
	}
	
	if (nth == 0) return;

	int count=0;
	toolbarItem *tmp = toollist;
	while (tmp) {
		count++;
		if (count == nth) {
			fl_trigger_object(tmp->icon);
			return;
		}
		tmp = tmp->next;
	}
	// item nth not found...
	LyXBell();
}

///
void Toolbar::read(LyXLexClass *lex)
{
	//consistency check
	if (!StringEqual(lex->text(),"\\begin_toolbar"))
		fprintf(stderr,
			"Toolbar::read: ERROR wrong token: `%s'\n",
			lex->text());
	    
	char *func;
	bool quit = false;
	
	lex->pushTable(toolTags, TO_LAST);

	if (lyx_debug_level & DEBUG_LEX_PARSER)
		lex->printTable();
	
	while (lex->IsOK() && !quit) {
		
		if (lyx_debug_level & DEBUG_LEX_PARSER)
			fprintf(stderr,
				"Toolbar::read: current lex text: `%s'\n",
				lex->text());

		switch(lex->lex()) {
		  case LEX_UNDEF:
			  fprintf(stderr,
				  "Toolbar::read: Unknown toolbar tag: `%s'\n",
				  lex->text());
			  break;
			
		  case TO_ADD:
			  if (lex->next()){
				  func = lex->text();
				  add(func);
			  }
			  break;
		   
		  case TO_SEPARATOR:
			  add(TOOL_SEPERATOR);
			  break;
		   
		  case TO_LAYOUTS:
			  add(TOOL_LAYOUTS);
			  break;
		   
		  case TO_NEWLINE:
			  add(TOOL_NEWLINE);
			  break;
			
		  case TO_ENDTOOLBAR:
			  set();
			  quit = true;
			  break;
			
		}
	}
	lex->popTable();
}
//@}
