// -*- C++ -*-
/*
	paths.h - header for path-mangling functions - part of LyX project
	(C)1996 by Dirk Niggemann
	parts (C) 1996 Ivan Schreter
*/
#ifndef PATHS_H
#define PATHS_H
// sorry dabn100 has reversed all the protos!!


char * safe_getcwd (void);
// returns a pointer to right-sized buffer for cwd
// which you have to deallocate yourself 

char * safer_getcwd (void);
// will perform automountd correction Real Soon Now
// right now, just checks for PWD and CWD as environment
// otherwise returns safe_getcwd
// NB this is _not_ a real getcwd.
// it just finds the cwd on which we started LyX
// otherwise like safe_getcwd

char * NameToPath(char * buf, const char *filename);
// strip filename from path name and puts the path into buf
// creates buf if buf == NULL

char * MakePath(char *buf, const char *primname, const char *secname);
// strips filename from primname and puts resulting path into buf.
// If primname is empty or NULL, it'll do it on secname. If that is
// empty or null, it will use documentpath, if non-null, otherwise
// will make a '.'
// if buf == NULL, allocates buf


char * MakeAbsPath(char *buf, const char *relpath, const char* basepath);
// If relpath is absolute, it'll just copy it. If relpath is empty or
// null, it will use the basepath if exists, and if not, then use '.'
// Otherwise, make absolute path based on basepath and put into buf.
// WARNING: if basepath is not absolute, it works, but makerelpath
// WILL NOT WORK back from it.
// If buf == NULL, allocate a large enough buffer
// Not done efficiently yet....


char * MakeAbsPath2(char *buf, const char *relpath);
// make absolute path from current directory
// uses safer_getcwd to eliminate orst cases of automountd problems

char * MakeRelPath(char *buf, const char *abspath, const char *basepath);
// makes relative path out of absolute path. If it is deeper than basepath,
// it's easy. If basepath and abspath share something (they are all deeper
// than some directory), it'll be rendered using ..'s. If they are completely
// different, then the absolute path will be used as relative path
// WARNING: the absolute path and base path must really be absolute paths!!!

char * AddName(char *buf, const char *path, const char *fname);
// correctly append filename to the pathname
// if pathname is '.', then don't use pathname
// if buf == NULL create buf

char * AddPath(char *buf, const char *path, const char *path2);
// correctly append a sub-directory to the pathname
// if pathname is '.', then don't use pathname
// Deletes leading /'s from path2 
// deals with trailing /'s  
// if buf == NULL allocates buf
// accepts multiple subdirs

// swaps extension on end of oldname with extension 
// strips path off oldname if no_path == 1 
// if no extension, just appends. 
// if newname == NULL create it. 
// returns addr of newname 
char * ChangeExtension (char * newname, const char * oldname, const char * extension, int no_path); 


// strcat that can
// do newbuf = strcat (NULL, old1, old2) 
// or strcat (dest, old1, old2) where dest == old1 is allowed  
char * AddExtension (char * dest, const char *src1, const char* src2);

//this is just to get a clean i/f for kfopen and LyXGetTextClass
//returns newly created buff with all that stuff in it
char * MakeFullPath (const char * path, const char *dirs, 
		     const char * name, const char * ext); 


// PathPush - changes to directory path and stores old cwd in buf
// which it allocates internally. Stack-like.
// NON-REENTRANT!!
void PathPush (const char *path);

// changes back to old path and pops dir from stack
void PathPop ();

// MakeDisplayPath 
// creates a nice compact path for display in the buffer/lastfiles list 
char * MakeDisplayPath (char * buf, const char *path);

//uses a string formatted like the $PATH
//variable in bash to find a file to open
//bit stupoid right now. Can't cope with 
//pathnames with a ':' in them
//not much of a limitation, really, but
//we should cater for the most demented tastes
//returns dynamically-allocated buf to full path of 
//file. If path entry begins with $$LyX/, use system_lyxdir.
char * FileOpenSearch (const char * cwd, const char *path, 
			const char *name, const char *ext);

//is a file read_only?
//return 1 read-write
//	 0 read_only
//	-1 error (doesn't exist, no access, anything else) 
int IsFileWriteable (const char * path);

//returns 1: dir writeable
//	  0: not writeable
//	 -1: error- couldn't find out, or unsure
int IsDirWriteable (const char * path);

char * CreateBufferTmpDir (const char *pathfor);
char * CreateLyXTmpDir (const char * deflt);
int DestroyBufferTmpDir (const char * tmpdir);
int DestroyLyXTmpDir (const char * tmpdir);


// temporary measure // shoulf be removed or moved to paths.C
#define PathCopy StringCopy

// file selector procedures 
const char *SelectFile(const char *title, const char *path, const char *mask, const char *dummy);
// better file selection dialog

void SetFSelButton(int idx, const char *name, const char *path);
// set file selector button 0 or 1 to name that will generate path path

char * GetFSelDir (char *buf); 
// gets last directory that file selector was in
// if buf = NULL, allocate one

#endif
