// $Id: sashes.C,v 1.1 1996/01/20 15:24:16 zeller Exp $ -*- C++ -*-
// Kill unmanaged sashes

// Copyright (C) 1996 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller (zeller@ips.cs.tu-bs.de).
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.

const char sashes_rcsid[] = 
    "$Id: sashes.C,v 1.1 1996/01/20 15:24:16 zeller Exp $";

#ifdef __GNUG__
#pragma implementation
#endif

#include "sashes.h"

#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <X11/StringDefs.h>

#ifndef LESSTIF_VERSION
extern "C" {
#define new new_w
#define class class_w
#include <Xm/SashP.h>	  // XmIsSash()
#undef class
#undef new
}
#else
#define XmIsSash(x) false
#endif

//-----------------------------------------------------------------------------
// Sashes
//-----------------------------------------------------------------------------

// Destroy all sashes of PANED, except the one numbered IGNORE
void unmanage_sashes(Widget paned, int ignore)
{
    if (!XmIsPanedWindow(paned))
	return;

    WidgetList children;
    int num_children;

    XtVaGetValues(paned,
		  XtNchildren, &children,
		  XtNnumChildren, &num_children,
		  NULL);

    int n = 0;
    for (int i = 0; i < num_children; i++)
	if (XmIsSash(children[i]) && n++ != ignore)
	{
	    XtUnmanageChild(children[i]);
	    XtUnmapWidget(children[i]);
	}
}

// Disable traversal for all sashes of PANED
void untraverse_sashes(Widget paned)
{
    if (!XmIsPanedWindow(paned))
	return;

    WidgetList children;
    int num_children;

    XtVaGetValues(paned,
		  XtNchildren, &children,
		  XtNnumChildren, &num_children,
		  NULL);

    for (int i = 0; i < num_children; i++)
	if (XmIsSash(children[i]))
	    XtVaSetValues(children[i], XmNtraversalOn, False, NULL);
}
