/*
 * Copyright (c) 1999-2001 Ivan Francolin Martinez
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the company nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include "jni.h"

#include "config.h"

#include "teapop.h"

/**
Variables used to access/control JVM
**/
JavaVM * jvm = NULL;
JNIEnv * java_env = NULL;
JavaVMInitArgs vm_args;
JavaVMOption options[10];
char cpbuffer[2048];


int init_jvm() {
	jint res;
	char * classpath;
	
	if (jvm != NULL) {
		return 0;
	}

	JNI_GetDefaultJavaVMInitArgs(&vm_args);
	vm_args.version = JNI_VERSION_1_2;
	vm_args.nOptions = 0;
	classpath = getenv("CLASSPATH");
	if (classpath != NULL) {
		strcpy(&cpbuffer[0],"-Djava.class.path=");
		strcat(&cpbuffer[0],classpath);
		options[vm_args.nOptions].optionString = &cpbuffer[0];
		vm_args.nOptions = vm_args.nOptions + 1;
	}
	vm_args.options = &options[0];
     
	res = JNI_CreateJavaVM(&jvm, (void **)&java_env, &vm_args);
	if (res < 0) { 
		syslog(LOG_ERR,"Can't create Java VM : %d\n",res);
		return res; 
	}
        return 0;       
}

void finish_jvm() {
	if (jvm != NULL) {
		(*jvm)->DestroyJavaVM(jvm);
   	}
}


/** Return a Java Class (Remember to use '/' instead of '.')  **/
#define JavaFindClass(classname) (*java_env)->FindClass(java_env,classname)

/** Return the class of object **/
#define JavaGetObjectClass(obj) (*java_env)->GetObjectClass(java_env,obj)

/** Return the method with specified parameters **/
#define JavaGetMethodId(class,method,id) (*java_env)->GetMethodID(java_env,class,method, id)
#define JavaGetMethodIdObj(obj,method,id) (*java_env)->GetMethodID(java_env,JavaGetObjectClass(obj),method, id)

/** Return the constructor with specified parameters **/
#define JavaGetConstructor(class,id) JavaGetMethodId(class, "<init>", id)

/** Return the default constructor of class **/
#define JavaGetDefaultConstructor(class) JavaGetConstructor(class, "()V")

/** Create a new object using specified constructor **/
#define JavaNewObjectC(class,constructor) (*java_env)->NewObject(java_env,class, constructor)

/** Create a new object using standard constructor **/
#define JavaNewObject(class) (*java_env)->NewObject(java_env,class, JavaGetDefaultConstructor(class))

/** Chama metodo que retorna boolean **/
#define JavaCallBooleanMethod(object,method) (*java_env)->CallBooleanMethod(java_env,object,method)

/** Create an java String **/
#define JavaNewString(str) (*java_env)->NewStringUTF(java_env,str) 

/** Check if JavaException has Occurred **/
#define JavaExceptionOccurred() (*java_env)->ExceptionOccurred(java_env)

/** Clear JavaException  **/
#define JavaExceptionClear() (*java_env)->ExceptionClear(java_env)


jthrowable CheckJavaException() {
	jthrowable jexp = JavaExceptionOccurred();
	if (jexp != NULL) {
		JavaExceptionClear();
	}
	return jexp;
}

/**
   HERE STARTS THE SPECIFIC CODE,
   THE CODE BEFORE THIS POINT IS GENERIC AND CAN BE USED IN ANY PLACE TO ENABLE 
   PROGRAMS TO CREATE A JAVA JVM AND EXECUTE JAVA CODE. 
*/

/**
JAVA_AUTHCLASS comes from configure script
*/
char * authClassName = JAVA_AUTHCLASS;
jclass authClass;

int init() {
	if (authClass != NULL) {
		return 0;
	}
	if (init_jvm() == 0) {
		authClass = JavaFindClass(authClassName);
		if (authClass == NULL) { 
			syslog(LOG_ERR,"Cant find java class : %s \n",authClassName);
			return 1;
		}
	} else {
		return 1;
	}
	return 0; 
                                                                                                         
}

/**
Authentication of the user.
There is no disposal of Java objects,Java garbage collector will 
dispose it because they are not referenced in Java context
**/
#define AUTHSIGNATURE "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/Object;"
int pop_password_java(pinfo,auth,isapop,passwd) 
	POP_INFO *pinfo;
	POP_AUTH *auth;
	int isapop;
	char * passwd;
{
    
	jobject obj;
	jobject user = NULL;
	jmethodID authMethod;
	jboolean ret = JNI_FALSE;
	jstring userid;
	jstring domain;
	jstring password;
	jstring apopstr;
	jstring mailbox = NULL;
	jboolean jisapop;
	 
        if (init() != 0) {
        	return 1;
        } 
	obj = JavaNewObject(authClass);
	if (obj != NULL) { 
		/* 
			Java Method to authenticate
			public boolean doPOPAuth(String userid, 
						String domain,
						String password,
						String apopstr,
						boolean isapop) 
		*/	
		authMethod = JavaGetMethodId(authClass,"doPOPAuth",AUTHSIGNATURE);
		if (authMethod != NULL) {
		        userid = JavaNewString(pinfo->userid);
			domain = JavaNewString(pinfo->domain);
			password = JavaNewString(passwd);
			apopstr = JavaNewString(pinfo->apopstr);
			/* Checking for APOP auth */
			jisapop = JNI_FALSE;
			if (isapop == 1) {
			    jisapop = JNI_TRUE;
			}
			user = (*java_env)->CallObjectMethod(java_env,obj,
								authMethod,
								userid,
								domain,
								password,
								apopstr,
								jisapop);
			if (user != NULL) {
				authMethod = JavaGetMethodIdObj(user,
								"getMailbox",
								"()Ljava/lang/String;");
				if (authMethod != NULL) {
	        	                mailbox = (*java_env)->CallObjectMethod(java_env,
	        	                					user,
	        	                					authMethod);
	        	                strncpy(pinfo->chroot,
	        	                	auth->maildrop,
	        	                	sizeof(pinfo->chroot));     		
        		                strncpy(pinfo->maildrop,
        		                	(*java_env)->GetStringUTFChars(java_env,
        		                					mailbox,&ret),
        		                	sizeof(pinfo->maildrop));	
					ret = JNI_TRUE;
				} else {
					syslog(LOG_ERR,"method : public String getMailbox() "
					               "not found in user object");
				} 
			} 
		} else {
			syslog(LOG_ERR,"method : public Object "
			       "doPOPAuth(userid,domain,password,isapop) not found");
		}

	}

        if (ret == JNI_TRUE) {
		return 0;
	} else {
		return 1;
	}
}

