/**
 * This is a sample Authentication Class for use with teapop
 */

import java.sql.*;
import java.security.*;

public class SampleAuth implements Authentication, User {
  /**
   * teapop will create an instance for each autentication that must be made, then we can use the
   * same object to implement the 2 interfaces. If you already have routines to get userinfo,
   * you can implement the User interface in your user class
   */
  private String mailbox;

  public String getMailbox() {
      return mailbox;
  };

  /**
   * It's recommended to use the connection via a Pool Driver, or create a static
   * connection object if your database driver support multiple statements in a single connection
   */
  private Connection c = null;

  static private MessageDigest md;

  static {
      try {
          md = MessageDigest.getInstance("MD5");
      } catch (NoSuchAlgorithmException e) {
          md = null;
      }
  }

  public static String calcAPOP(String password,String apopstr) {
      if (md == null) {
          /**
           * Can't do APOP
           */
          return "";
      }
      password = apopstr+password;
      byte[] d = md.digest(password.getBytes());
      // Convert MD5 byte array to Hex
      password = "";
      for (int x = 0; x < d.length; x++) {
          /**
           * Convert byte (signed) to int without signal
           */
          int i = d[x];
          if (i < 0) i = i + 256;
          i = i+256;
          password = password + Integer.toHexString(i).substring(1).toLowerCase();
      }
      return password;
  }

  public Object doPOPAuth(String userid,String domain,String password,String apopstr,boolean isapop) {
      boolean ok = false;
      try {
          c = DriverManager.getConnection("jdbc:yourjdbcurl","userid","password");
          Statement st = c.createStatement();
          ResultSet rs = st.executeQuery("SELECT PASSWORD "+
                                         "FROM TABLENAME "+
                                         "WHERE (USERID = '"+userid+"') AND "+
                                         "(DOMAIN = '"+domain+"')");
          if (rs.next()) {
              String dbpassword = rs.getString(1);
              if (isapop) {
                  dbpassword = calcAPOP(dbpassword,apopstr);
              }
              ok = dbpassword.equals(password);
          }
          rs.close();
          st.close();
      } catch (Exception e) {
          /**
           * An unexpected error ocurred, please write it to file, syslog or something else
           * DOES NOT USE System.err or System.out here, if you make it and you are using
           * inetd or xinetd the output will be sent to POP client
           * I recommend to use System.SetErr and System.SetOut to make the redirection
           */
      }
      if (c != null) {
          try { c.close(); } catch (Exception e) {};
      }
      if (ok) {
          return this;
      } else {
          return null;
      }
  }

}