/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: qhexvalidator.cpp 
 *              
 *      Abstract: Implement hex validator for WEP security 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      fstanchina      7th  May 04     Removed some convoluted use of 
 *                                      temporary strings
 ***************************************************************************/ 


#include <qvalidator.h>
#include <qwidget.h>

#include "qhexvalidator.h"

QHexValidator::QHexValidator ( QWidget * parent, const char * name )
  : QValidator(parent, name)
{

}

QHexValidator::~QHexValidator()
{}

QValidator::State QHexValidator::validate ( QString &str, int &pos ) const
{
	const char *tmp;
	char ch;
	unsigned int i;
	QValidator::State result=QValidator::Acceptable;

	if(str.length() == 0)
		return QValidator::Acceptable;

	tmp = str.data();
	for(i=0; i<str.length(); i++)
	{
		ch = tmp[i];
		if( ((ch >= 'a') && (ch <= 'f')) || ((ch >= 'A') && (ch <= 'F')) ||
		  ((ch >= '0') && (ch <= '9')) )
		{
			; /* do nothing */
		}
		else
		{
			result=QValidator::Invalid;
			pos=i;
			break;
		}
	}

	return result;
}


