#ifndef LCG_LOADER_H
#define LCG_LOADER_H

#include <stdio.h>
#define CG_EXPLICIT
#include <Cg/cg.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Loader API */

extern int         lcgInit(const char *filename);
extern void        lcgList(const char *prefix, FILE *out);
extern void        lcgDestroy(void);
extern const char *lcgGetProcName(void **function);
extern int         lcgHasVersion(void ***version);

extern void ***lcgVersion1_1_0000();
extern void ***lcgVersion1_2_0000();
extern void ***lcgVersion1_4_0000();
extern void ***lcgVersion1_5_0000();
extern void ***lcgVersion1_5_0001();
extern void ***lcgVersion2_0_0000();
extern void ***lcgVersion2_1_0000();
extern void ***lcgVersion2_2_0000();
extern void ***lcgVersion3_0_0000();
extern void ***lcgVersion3_0_0005();
extern void ***lcgVersion3_1_0000();

/* Internals */

typedef struct _LcgHandle *LcgHandle;

extern LcgHandle lcgHandle;

extern LcgHandle   lcgLoadLibrary(const char *filename);
extern int         lcgFreeLibrary(LcgHandle handle);
extern void *      lcgGetProcAddress(LcgHandle handle, const char *name);
extern const char *lcgGetModuleFileName(LcgHandle handle, void *function);

/* Typedefs */

typedef void (*PFNCGADDSTATEENUMERANTPROC)(CGstate, const char *, int);
typedef CGbool (*PFNCGCALLSTATERESETCALLBACKPROC)(CGstateassignment);
typedef CGbool (*PFNCGCALLSTATESETCALLBACKPROC)(CGstateassignment);
typedef CGbool (*PFNCGCALLSTATEVALIDATECALLBACKPROC)(CGstateassignment);
typedef CGprogram (*PFNCGCOMBINEPROGRAMSPROC)(int, const CGprogram *);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS2PROC)(const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS3PROC)(const CGprogram, const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS4PROC)(const CGprogram, const CGprogram, const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS5PROC)(const CGprogram, const CGprogram, const CGprogram, const CGprogram, const CGprogram);
typedef void (*PFNCGCOMPILEPROGRAMPROC)(CGprogram);
typedef void (*PFNCGCONNECTPARAMETERPROC)(CGparameter, CGparameter);
typedef CGeffect (*PFNCGCOPYEFFECTPROC)(CGeffect);
typedef CGprogram (*PFNCGCOPYPROGRAMPROC)(CGprogram);
typedef CGstate (*PFNCGCREATEARRAYSAMPLERSTATEPROC)(CGcontext, const char *, CGtype, int);
typedef CGstate (*PFNCGCREATEARRAYSTATEPROC)(CGcontext, const char *, CGtype, int);
typedef CGbuffer (*PFNCGCREATEBUFFERPROC)(CGcontext, int, const void *, CGbufferusage);
typedef CGcontext (*PFNCGCREATECONTEXTPROC)();
typedef CGeffect (*PFNCGCREATEEFFECTPROC)(CGcontext, const char *, const char **);
typedef CGannotation (*PFNCGCREATEEFFECTANNOTATIONPROC)(CGeffect, const char *, CGtype);
typedef CGeffect (*PFNCGCREATEEFFECTFROMFILEPROC)(CGcontext, const char *, const char **);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERPROC)(CGeffect, const char *, CGtype);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERARRAYPROC)(CGeffect, const char *, CGtype, int);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERMULTIDIMARRAYPROC)(CGeffect, const char *, CGtype, int, const int *);
typedef CGobj (*PFNCGCREATEOBJPROC)(CGcontext, CGenum, const char *, CGprofile, const char **);
typedef CGobj (*PFNCGCREATEOBJFROMFILEPROC)(CGcontext, CGenum, const char *, CGprofile, const char **);
typedef CGparameter (*PFNCGCREATEPARAMETERPROC)(CGcontext, CGtype);
typedef CGannotation (*PFNCGCREATEPARAMETERANNOTATIONPROC)(CGparameter, const char *, CGtype);
typedef CGparameter (*PFNCGCREATEPARAMETERARRAYPROC)(CGcontext, CGtype, int);
typedef CGparameter (*PFNCGCREATEPARAMETERMULTIDIMARRAYPROC)(CGcontext, CGtype, int, const int *);
typedef CGpass (*PFNCGCREATEPASSPROC)(CGtechnique, const char *);
typedef CGannotation (*PFNCGCREATEPASSANNOTATIONPROC)(CGpass, const char *, CGtype);
typedef CGprogram (*PFNCGCREATEPROGRAMPROC)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
typedef CGannotation (*PFNCGCREATEPROGRAMANNOTATIONPROC)(CGprogram, const char *, CGtype);
typedef CGprogram (*PFNCGCREATEPROGRAMFROMEFFECTPROC)(CGeffect, CGprofile, const char *, const char **);
typedef CGprogram (*PFNCGCREATEPROGRAMFROMFILEPROC)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
typedef CGstate (*PFNCGCREATESAMPLERSTATEPROC)(CGcontext, const char *, CGtype);
typedef CGstateassignment (*PFNCGCREATESAMPLERSTATEASSIGNMENTPROC)(CGparameter, CGstate);
typedef CGstate (*PFNCGCREATESTATEPROC)(CGcontext, const char *, CGtype);
typedef CGstateassignment (*PFNCGCREATESTATEASSIGNMENTPROC)(CGpass, CGstate);
typedef CGstateassignment (*PFNCGCREATESTATEASSIGNMENTINDEXPROC)(CGpass, CGstate, int);
typedef CGtechnique (*PFNCGCREATETECHNIQUEPROC)(CGeffect, const char *);
typedef CGannotation (*PFNCGCREATETECHNIQUEANNOTATIONPROC)(CGtechnique, const char *, CGtype);
typedef void (*PFNCGDESTROYBUFFERPROC)(CGbuffer);
typedef void (*PFNCGDESTROYCONTEXTPROC)(CGcontext);
typedef void (*PFNCGDESTROYEFFECTPROC)(CGeffect);
typedef void (*PFNCGDESTROYOBJPROC)(CGobj);
typedef void (*PFNCGDESTROYPARAMETERPROC)(CGparameter);
typedef void (*PFNCGDESTROYPROGRAMPROC)(CGprogram);
typedef void (*PFNCGDISCONNECTPARAMETERPROC)(CGparameter);
typedef void (*PFNCGEVALUATEPROGRAMPROC)(CGprogram, float *, int, int, int, int);
typedef const char *(*PFNCGGETANNOTATIONNAMEPROC)(CGannotation);
typedef CGtype (*PFNCGGETANNOTATIONTYPEPROC)(CGannotation);
typedef int (*PFNCGGETARRAYDIMENSIONPROC)(CGparameter);
typedef CGparameter (*PFNCGGETARRAYPARAMETERPROC)(CGparameter, int);
typedef int (*PFNCGGETARRAYSIZEPROC)(CGparameter, int);
typedef int (*PFNCGGETARRAYTOTALSIZEPROC)(CGparameter);
typedef CGtype (*PFNCGGETARRAYTYPEPROC)(CGparameter);
typedef CGenum (*PFNCGGETAUTOCOMPILEPROC)(CGcontext);
typedef CGbehavior (*PFNCGGETBEHAVIORPROC)(const char *);
typedef const char *(*PFNCGGETBEHAVIORSTRINGPROC)(CGbehavior);
typedef const CGbool *(*PFNCGGETBOOLANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const CGbool *(*PFNCGGETBOOLSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const int *(*PFNCGGETBOOLEANANNOTATIONVALUESPROC)(CGannotation, int *);
typedef int (*PFNCGGETBUFFERSIZEPROC)(CGbuffer);
typedef CGIncludeCallbackFunc (*PFNCGGETCOMPILERINCLUDECALLBACKPROC)(CGcontext);
typedef CGparameter (*PFNCGGETCONNECTEDPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETCONNECTEDSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETCONNECTEDTOPARAMETERPROC)(CGparameter, int);
typedef CGbehavior (*PFNCGGETCONTEXTBEHAVIORPROC)(CGcontext);
typedef CGparameter (*PFNCGGETDEPENDENTANNOTATIONPARAMETERPROC)(CGannotation, int);
typedef CGparameter (*PFNCGGETDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment, int);
typedef CGparameter (*PFNCGGETDEPENDENTSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment, int);
typedef CGdomain (*PFNCGGETDOMAINPROC)(const char *);
typedef const char *(*PFNCGGETDOMAINSTRINGPROC)(CGdomain);
typedef CGcontext (*PFNCGGETEFFECTCONTEXTPROC)(CGeffect);
typedef const char *(*PFNCGGETEFFECTNAMEPROC)(CGeffect);
typedef CGbuffer (*PFNCGGETEFFECTPARAMETERBUFFERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETEFFECTPARAMETERBYSEMANTICPROC)(CGeffect, const char *);
typedef CGenum (*PFNCGGETENUMPROC)(const char *);
typedef const char *(*PFNCGGETENUMSTRINGPROC)(CGenum);
typedef CGerror (*PFNCGGETERRORPROC)();
typedef CGerrorCallbackFunc (*PFNCGGETERRORCALLBACKPROC)();
typedef CGerrorHandlerFunc (*PFNCGGETERRORHANDLERPROC)(void **);
typedef const char *(*PFNCGGETERRORSTRINGPROC)(CGerror);
typedef CGparameter (*PFNCGGETFIRSTDEPENDENTPARAMETERPROC)(CGparameter);
typedef CGeffect (*PFNCGGETFIRSTEFFECTPROC)(CGcontext);
typedef CGannotation (*PFNCGGETFIRSTEFFECTANNOTATIONPROC)(CGeffect);
typedef CGparameter (*PFNCGGETFIRSTEFFECTPARAMETERPROC)(CGeffect);
typedef CGerror (*PFNCGGETFIRSTERRORPROC)();
typedef CGparameter (*PFNCGGETFIRSTLEAFEFFECTPARAMETERPROC)(CGeffect);
typedef CGparameter (*PFNCGGETFIRSTLEAFPARAMETERPROC)(CGprogram, CGenum);
typedef CGparameter (*PFNCGGETFIRSTPARAMETERPROC)(CGprogram, CGenum);
typedef CGannotation (*PFNCGGETFIRSTPARAMETERANNOTATIONPROC)(CGparameter);
typedef CGpass (*PFNCGGETFIRSTPASSPROC)(CGtechnique);
typedef CGannotation (*PFNCGGETFIRSTPASSANNOTATIONPROC)(CGpass);
typedef CGprogram (*PFNCGGETFIRSTPROGRAMPROC)(CGcontext);
typedef CGannotation (*PFNCGGETFIRSTPROGRAMANNOTATIONPROC)(CGprogram);
typedef CGstate (*PFNCGGETFIRSTSAMPLERSTATEPROC)(CGcontext);
typedef CGstateassignment (*PFNCGGETFIRSTSAMPLERSTATEASSIGNMENTPROC)(CGparameter);
typedef CGstate (*PFNCGGETFIRSTSTATEPROC)(CGcontext);
typedef CGstateassignment (*PFNCGGETFIRSTSTATEASSIGNMENTPROC)(CGpass);
typedef CGparameter (*PFNCGGETFIRSTSTRUCTPARAMETERPROC)(CGparameter);
typedef CGtechnique (*PFNCGGETFIRSTTECHNIQUEPROC)(CGeffect);
typedef CGannotation (*PFNCGGETFIRSTTECHNIQUEANNOTATIONPROC)(CGtechnique);
typedef CGparameter (*PFNCGGETFIRSTUNIFORMBUFFERPARAMETERPROC)(CGparameter);
typedef const float *(*PFNCGGETFLOATANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const float *(*PFNCGGETFLOATSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const int *(*PFNCGGETINTANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const int *(*PFNCGGETINTSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const char *(*PFNCGGETLASTERRORSTRINGPROC)(CGerror *);
typedef const char *(*PFNCGGETLASTLISTINGPROC)(CGcontext);
typedef CGenum (*PFNCGGETLOCKINGPOLICYPROC)();
typedef CGenum (*PFNCGGETMATRIXPARAMETERORDERPROC)(CGparameter);
typedef void (*PFNCGGETMATRIXPARAMETERDCPROC)(CGparameter, double *);
typedef void (*PFNCGGETMATRIXPARAMETERDRPROC)(CGparameter, double *);
typedef void (*PFNCGGETMATRIXPARAMETERFCPROC)(CGparameter, float *);
typedef void (*PFNCGGETMATRIXPARAMETERFRPROC)(CGparameter, float *);
typedef void (*PFNCGGETMATRIXPARAMETERICPROC)(CGparameter, int *);
typedef void (*PFNCGGETMATRIXPARAMETERIRPROC)(CGparameter, int *);
typedef void (*PFNCGGETMATRIXSIZEPROC)(CGtype, int *, int *);
typedef CGeffect (*PFNCGGETNAMEDEFFECTPROC)(CGcontext, const char *);
typedef CGannotation (*PFNCGGETNAMEDEFFECTANNOTATIONPROC)(CGeffect, const char *);
typedef CGparameter (*PFNCGGETNAMEDEFFECTPARAMETERPROC)(CGeffect, const char *);
typedef CGparameter (*PFNCGGETNAMEDEFFECTUNIFORMBUFFERPROC)(CGeffect, const char *);
typedef CGparameter (*PFNCGGETNAMEDPARAMETERPROC)(CGprogram, const char *);
typedef CGannotation (*PFNCGGETNAMEDPARAMETERANNOTATIONPROC)(CGparameter, const char *);
typedef CGpass (*PFNCGGETNAMEDPASSPROC)(CGtechnique, const char *);
typedef CGannotation (*PFNCGGETNAMEDPASSANNOTATIONPROC)(CGpass, const char *);
typedef CGannotation (*PFNCGGETNAMEDPROGRAMANNOTATIONPROC)(CGprogram, const char *);
typedef CGparameter (*PFNCGGETNAMEDPROGRAMPARAMETERPROC)(CGprogram, CGenum, const char *);
typedef CGparameter (*PFNCGGETNAMEDPROGRAMUNIFORMBUFFERPROC)(CGprogram, const char *);
typedef CGstate (*PFNCGGETNAMEDSAMPLERSTATEPROC)(CGcontext, const char *);
typedef CGstateassignment (*PFNCGGETNAMEDSAMPLERSTATEASSIGNMENTPROC)(CGparameter, const char *);
typedef CGstate (*PFNCGGETNAMEDSTATEPROC)(CGcontext, const char *);
typedef CGstateassignment (*PFNCGGETNAMEDSTATEASSIGNMENTPROC)(CGpass, const char *);
typedef CGparameter (*PFNCGGETNAMEDSTRUCTPARAMETERPROC)(CGparameter, const char *);
typedef CGparameter (*PFNCGGETNAMEDSUBPARAMETERPROC)(CGparameter, const char *);
typedef CGtechnique (*PFNCGGETNAMEDTECHNIQUEPROC)(CGeffect, const char *);
typedef CGannotation (*PFNCGGETNAMEDTECHNIQUEANNOTATIONPROC)(CGtechnique, const char *);
typedef CGparameter (*PFNCGGETNAMEDUNIFORMBUFFERPARAMETERPROC)(CGparameter, const char *);
typedef CGtype (*PFNCGGETNAMEDUSERTYPEPROC)(CGhandle, const char *);
typedef CGannotation (*PFNCGGETNEXTANNOTATIONPROC)(CGannotation);
typedef CGeffect (*PFNCGGETNEXTEFFECTPROC)(CGeffect);
typedef CGparameter (*PFNCGGETNEXTLEAFPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETNEXTPARAMETERPROC)(CGparameter);
typedef CGpass (*PFNCGGETNEXTPASSPROC)(CGpass);
typedef CGprogram (*PFNCGGETNEXTPROGRAMPROC)(CGprogram);
typedef CGstate (*PFNCGGETNEXTSTATEPROC)(CGstate);
typedef CGstateassignment (*PFNCGGETNEXTSTATEASSIGNMENTPROC)(CGstateassignment);
typedef CGtechnique (*PFNCGGETNEXTTECHNIQUEPROC)(CGtechnique);
typedef int (*PFNCGGETNUMCONNECTEDTOPARAMETERSPROC)(CGparameter);
typedef int (*PFNCGGETNUMDEPENDENTANNOTATIONPARAMETERSPROC)(CGannotation);
typedef int (*PFNCGGETNUMDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERSPROC)(CGstateassignment);
typedef int (*PFNCGGETNUMDEPENDENTSTATEASSIGNMENTPARAMETERSPROC)(CGstateassignment);
typedef int (*PFNCGGETNUMPARENTTYPESPROC)(CGtype);
typedef int (*PFNCGGETNUMPROGRAMDOMAINSPROC)(CGprogram);
typedef int (*PFNCGGETNUMSTATEENUMERANTSPROC)(CGstate);
typedef int (*PFNCGGETNUMSUPPORTEDPROFILESPROC)();
typedef int (*PFNCGGETNUMUSERTYPESPROC)(CGhandle);
typedef CGresource (*PFNCGGETPARAMETERBASERESOURCEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERBASETYPEPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERBUFFERINDEXPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERBUFFEROFFSETPROC)(CGparameter);
typedef CGparameterclass (*PFNCGGETPARAMETERCLASSPROC)(CGparameter);
typedef CGparameterclass (*PFNCGGETPARAMETERCLASSENUMPROC)(const char *);
typedef const char *(*PFNCGGETPARAMETERCLASSSTRINGPROC)(CGparameterclass);
typedef int (*PFNCGGETPARAMETERCOLUMNSPROC)(CGparameter);
typedef CGcontext (*PFNCGGETPARAMETERCONTEXTPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEDCPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEDRPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEFCPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEFRPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEICPROC)(CGparameter, int, int *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEIRPROC)(CGparameter, int, int *);
typedef CGenum (*PFNCGGETPARAMETERDIRECTIONPROC)(CGparameter);
typedef CGeffect (*PFNCGGETPARAMETEREFFECTPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERINDEXPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERNAMEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERNAMEDTYPEPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERORDINALNUMBERPROC)(CGparameter);
typedef CGprogram (*PFNCGGETPARAMETERPROGRAMPROC)(CGparameter);
typedef CGresource (*PFNCGGETPARAMETERRESOURCEPROC)(CGparameter);
typedef unsigned long (*PFNCGGETPARAMETERRESOURCEINDEXPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERRESOURCENAMEPROC)(CGparameter);
typedef long (*PFNCGGETPARAMETERRESOURCESIZEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERRESOURCETYPEPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERROWSPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERSEMANTICPROC)(CGparameter);
typedef CGenum (*PFNCGGETPARAMETERSETTINGMODEPROC)(CGcontext);
typedef CGtype (*PFNCGGETPARAMETERTYPEPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERVALUEDCPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERVALUEDRPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERVALUEFCPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERVALUEFRPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERVALUEICPROC)(CGparameter, int, int *);
typedef int (*PFNCGGETPARAMETERVALUEIRPROC)(CGparameter, int, int *);
typedef const double *(*PFNCGGETPARAMETERVALUESPROC)(CGparameter, CGenum, int *);
typedef CGenum (*PFNCGGETPARAMETERVARIABILITYPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARENTTYPEPROC)(CGtype, int);
typedef const char *(*PFNCGGETPASSNAMEPROC)(CGpass);
typedef CGprogram (*PFNCGGETPASSPROGRAMPROC)(CGpass, CGdomain);
typedef CGtechnique (*PFNCGGETPASSTECHNIQUEPROC)(CGpass);
typedef CGprofile (*PFNCGGETPROFILEPROC)(const char *);
typedef CGdomain (*PFNCGGETPROFILEDOMAINPROC)(CGprofile);
typedef CGbool (*PFNCGGETPROFILEPROPERTYPROC)(CGprofile, CGenum);
typedef CGprofile (*PFNCGGETPROFILESIBLINGPROC)(CGprofile, CGdomain);
typedef const char *(*PFNCGGETPROFILESTRINGPROC)(CGprofile);
typedef CGbuffer (*PFNCGGETPROGRAMBUFFERPROC)(CGprogram, int);
typedef int (*PFNCGGETPROGRAMBUFFERMAXINDEXPROC)(CGprofile);
typedef int (*PFNCGGETPROGRAMBUFFERMAXSIZEPROC)(CGprofile);
typedef CGcontext (*PFNCGGETPROGRAMCONTEXTPROC)(CGprogram);
typedef CGdomain (*PFNCGGETPROGRAMDOMAINPROC)(CGprogram);
typedef CGprofile (*PFNCGGETPROGRAMDOMAINPROFILEPROC)(CGprogram, int);
typedef CGprogram (*PFNCGGETPROGRAMDOMAINPROGRAMPROC)(CGprogram, int);
typedef CGenum (*PFNCGGETPROGRAMINPUTPROC)(CGprogram);
typedef char const * const *(*PFNCGGETPROGRAMOPTIONSPROC)(CGprogram);
typedef CGenum (*PFNCGGETPROGRAMOUTPUTPROC)(CGprogram);
typedef int (*PFNCGGETPROGRAMOUTPUTVERTICESPROC)(CGprogram);
typedef CGprofile (*PFNCGGETPROGRAMPROFILEPROC)(CGprogram);
typedef CGprogram (*PFNCGGETPROGRAMSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef const char *(*PFNCGGETPROGRAMSTRINGPROC)(CGprogram, CGenum);
typedef CGresource (*PFNCGGETRESOURCEPROC)(const char *);
typedef const char *(*PFNCGGETRESOURCESTRINGPROC)(CGresource);
typedef CGparameter (*PFNCGGETSAMPLERSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment);
typedef CGstate (*PFNCGGETSAMPLERSTATEASSIGNMENTSTATEPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETSAMPLERSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGenum (*PFNCGGETSEMANTICCASEPOLICYPROC)();
typedef int (*PFNCGGETSTATEASSIGNMENTINDEXPROC)(CGstateassignment);
typedef CGpass (*PFNCGGETSTATEASSIGNMENTPASSPROC)(CGstateassignment);
typedef CGstate (*PFNCGGETSTATEASSIGNMENTSTATEPROC)(CGstateassignment);
typedef CGcontext (*PFNCGGETSTATECONTEXTPROC)(CGstate);
typedef const char *(*PFNCGGETSTATEENUMERANTPROC)(CGstate, int, int *);
typedef const char *(*PFNCGGETSTATEENUMERANTNAMEPROC)(CGstate, int);
typedef int (*PFNCGGETSTATEENUMERANTVALUEPROC)(CGstate, const char *);
typedef CGprofile (*PFNCGGETSTATELATESTPROFILEPROC)(CGstate);
typedef const char *(*PFNCGGETSTATENAMEPROC)(CGstate);
typedef CGstatecallback (*PFNCGGETSTATERESETCALLBACKPROC)(CGstate);
typedef CGstatecallback (*PFNCGGETSTATESETCALLBACKPROC)(CGstate);
typedef CGtype (*PFNCGGETSTATETYPEPROC)(CGstate);
typedef CGstatecallback (*PFNCGGETSTATEVALIDATECALLBACKPROC)(CGstate);
typedef const char *(*PFNCGGETSTRINGPROC)(CGenum);
typedef const char *(*PFNCGGETSTRINGANNOTATIONVALUEPROC)(CGannotation);
typedef const char * const *(*PFNCGGETSTRINGANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const char *(*PFNCGGETSTRINGPARAMETERVALUEPROC)(CGparameter);
typedef const char *(*PFNCGGETSTRINGSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGprofile (*PFNCGGETSUPPORTEDPROFILEPROC)(int);
typedef CGeffect (*PFNCGGETTECHNIQUEEFFECTPROC)(CGtechnique);
typedef const char *(*PFNCGGETTECHNIQUENAMEPROC)(CGtechnique);
typedef CGparameter (*PFNCGGETTEXTURESTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGtype (*PFNCGGETTYPEPROC)(const char *);
typedef CGtype (*PFNCGGETTYPEBASEPROC)(CGtype);
typedef CGparameterclass (*PFNCGGETTYPECLASSPROC)(CGtype);
typedef CGbool (*PFNCGGETTYPESIZESPROC)(CGtype, int *, int *);
typedef const char *(*PFNCGGETTYPESTRINGPROC)(CGtype);
typedef const char *(*PFNCGGETUNIFORMBUFFERBLOCKNAMEPROC)(CGparameter);
typedef CGbuffer (*PFNCGGETUNIFORMBUFFERPARAMETERPROC)(CGparameter);
typedef CGtype (*PFNCGGETUSERTYPEPROC)(CGhandle, int);
typedef CGbool (*PFNCGISANNOTATIONPROC)(CGannotation);
typedef CGbool (*PFNCGISBUFFERPROC)(CGbuffer);
typedef CGbool (*PFNCGISCONTEXTPROC)(CGcontext);
typedef CGbool (*PFNCGISEFFECTPROC)(CGeffect);
typedef CGbool (*PFNCGISINTERFACETYPEPROC)(CGtype);
typedef CGbool (*PFNCGISPARAMETERPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERGLOBALPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERREFERENCEDPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERUSEDPROC)(CGparameter, CGhandle);
typedef CGbool (*PFNCGISPARENTTYPEPROC)(CGtype, CGtype);
typedef CGbool (*PFNCGISPASSPROC)(CGpass);
typedef CGbool (*PFNCGISPROFILESUPPORTEDPROC)(CGprofile);
typedef CGbool (*PFNCGISPROGRAMPROC)(CGprogram);
typedef CGbool (*PFNCGISPROGRAMCOMPILEDPROC)(CGprogram);
typedef CGbool (*PFNCGISSTATEPROC)(CGstate);
typedef CGbool (*PFNCGISSTATEASSIGNMENTPROC)(CGstateassignment);
typedef CGbool (*PFNCGISTECHNIQUEPROC)(CGtechnique);
typedef CGbool (*PFNCGISTECHNIQUEVALIDATEDPROC)(CGtechnique);
typedef void *(*PFNCGMAPBUFFERPROC)(CGbuffer, CGbufferaccess);
typedef void (*PFNCGRESETPASSSTATEPROC)(CGpass);
typedef void (*PFNCGSETARRAYSIZEPROC)(CGparameter, int);
typedef void (*PFNCGSETAUTOCOMPILEPROC)(CGcontext, CGenum);
typedef CGbool (*PFNCGSETBOOLANNOTATIONPROC)(CGannotation, CGbool);
typedef CGbool (*PFNCGSETBOOLARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const CGbool *);
typedef CGbool (*PFNCGSETBOOLSTATEASSIGNMENTPROC)(CGstateassignment, CGbool);
typedef void (*PFNCGSETBUFFERDATAPROC)(CGbuffer, int, const void *);
typedef void (*PFNCGSETBUFFERSUBDATAPROC)(CGbuffer, int, int, const void *);
typedef void (*PFNCGSETCOMPILERINCLUDECALLBACKPROC)(CGcontext, CGIncludeCallbackFunc);
typedef void (*PFNCGSETCOMPILERINCLUDEFILEPROC)(CGcontext, const char *, const char *);
typedef void (*PFNCGSETCOMPILERINCLUDESTRINGPROC)(CGcontext, const char *, const char *);
typedef void (*PFNCGSETCONTEXTBEHAVIORPROC)(CGcontext, CGbehavior);
typedef CGbool (*PFNCGSETEFFECTNAMEPROC)(CGeffect, const char *);
typedef void (*PFNCGSETEFFECTPARAMETERBUFFERPROC)(CGparameter, CGbuffer);
typedef void (*PFNCGSETERRORCALLBACKPROC)(CGerrorCallbackFunc);
typedef void (*PFNCGSETERRORHANDLERPROC)(CGerrorHandlerFunc, void *);
typedef CGbool (*PFNCGSETFLOATANNOTATIONPROC)(CGannotation, float);
typedef CGbool (*PFNCGSETFLOATARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const float *);
typedef CGbool (*PFNCGSETFLOATSTATEASSIGNMENTPROC)(CGstateassignment, float);
typedef CGbool (*PFNCGSETINTANNOTATIONPROC)(CGannotation, int);
typedef CGbool (*PFNCGSETINTARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const int *);
typedef CGbool (*PFNCGSETINTSTATEASSIGNMENTPROC)(CGstateassignment, int);
typedef void (*PFNCGSETLASTLISTINGPROC)(CGhandle, const char *);
typedef CGenum (*PFNCGSETLOCKINGPOLICYPROC)(CGenum);
typedef void (*PFNCGSETMATRIXPARAMETERDCPROC)(CGparameter, const double *);
typedef void (*PFNCGSETMATRIXPARAMETERDRPROC)(CGparameter, const double *);
typedef void (*PFNCGSETMATRIXPARAMETERFCPROC)(CGparameter, const float *);
typedef void (*PFNCGSETMATRIXPARAMETERFRPROC)(CGparameter, const float *);
typedef void (*PFNCGSETMATRIXPARAMETERICPROC)(CGparameter, const int *);
typedef void (*PFNCGSETMATRIXPARAMETERIRPROC)(CGparameter, const int *);
typedef void (*PFNCGSETMULTIDIMARRAYSIZEPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER1DPROC)(CGparameter, double);
typedef void (*PFNCGSETPARAMETER1DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER1FPROC)(CGparameter, float);
typedef void (*PFNCGSETPARAMETER1FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER1IPROC)(CGparameter, int);
typedef void (*PFNCGSETPARAMETER1IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER2DPROC)(CGparameter, double, double);
typedef void (*PFNCGSETPARAMETER2DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER2FPROC)(CGparameter, float, float);
typedef void (*PFNCGSETPARAMETER2FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER2IPROC)(CGparameter, int, int);
typedef void (*PFNCGSETPARAMETER2IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER3DPROC)(CGparameter, double, double, double);
typedef void (*PFNCGSETPARAMETER3DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER3FPROC)(CGparameter, float, float, float);
typedef void (*PFNCGSETPARAMETER3FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER3IPROC)(CGparameter, int, int, int);
typedef void (*PFNCGSETPARAMETER3IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER4DPROC)(CGparameter, double, double, double, double);
typedef void (*PFNCGSETPARAMETER4DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER4FPROC)(CGparameter, float, float, float, float);
typedef void (*PFNCGSETPARAMETER4FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER4IPROC)(CGparameter, int, int, int, int);
typedef void (*PFNCGSETPARAMETER4IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETERSEMANTICPROC)(CGparameter, const char *);
typedef void (*PFNCGSETPARAMETERSETTINGMODEPROC)(CGcontext, CGenum);
typedef void (*PFNCGSETPARAMETERVALUEDCPROC)(CGparameter, int, const double *);
typedef void (*PFNCGSETPARAMETERVALUEDRPROC)(CGparameter, int, const double *);
typedef void (*PFNCGSETPARAMETERVALUEFCPROC)(CGparameter, int, const float *);
typedef void (*PFNCGSETPARAMETERVALUEFRPROC)(CGparameter, int, const float *);
typedef void (*PFNCGSETPARAMETERVALUEICPROC)(CGparameter, int, const int *);
typedef void (*PFNCGSETPARAMETERVALUEIRPROC)(CGparameter, int, const int *);
typedef void (*PFNCGSETPARAMETERVARIABILITYPROC)(CGparameter, CGenum);
typedef void (*PFNCGSETPASSPROGRAMPARAMETERSPROC)(CGprogram);
typedef void (*PFNCGSETPASSSTATEPROC)(CGpass);
typedef void (*PFNCGSETPROGRAMBUFFERPROC)(CGprogram, int, CGbuffer);
typedef void (*PFNCGSETPROGRAMOUTPUTVERTICESPROC)(CGprogram, int);
typedef void (*PFNCGSETPROGRAMPROFILEPROC)(CGprogram, CGprofile);
typedef CGbool (*PFNCGSETPROGRAMSTATEASSIGNMENTPROC)(CGstateassignment, CGprogram);
typedef void (*PFNCGSETSAMPLERSTATEPROC)(CGparameter);
typedef CGbool (*PFNCGSETSAMPLERSTATEASSIGNMENTPROC)(CGstateassignment, CGparameter);
typedef CGenum (*PFNCGSETSEMANTICCASEPOLICYPROC)(CGenum);
typedef void (*PFNCGSETSTATECALLBACKSPROC)(CGstate, CGstatecallback, CGstatecallback, CGstatecallback);
typedef void (*PFNCGSETSTATELATESTPROFILEPROC)(CGstate, CGprofile);
typedef CGbool (*PFNCGSETSTRINGANNOTATIONPROC)(CGannotation, const char *);
typedef void (*PFNCGSETSTRINGPARAMETERVALUEPROC)(CGparameter, const char *);
typedef CGbool (*PFNCGSETSTRINGSTATEASSIGNMENTPROC)(CGstateassignment, const char *);
typedef CGbool (*PFNCGSETTEXTURESTATEASSIGNMENTPROC)(CGstateassignment, CGparameter);
typedef void (*PFNCGSETUNIFORMBUFFERPARAMETERPROC)(CGparameter, CGbuffer);
typedef void (*PFNCGUNMAPBUFFERPROC)(CGbuffer);
typedef void (*PFNCGUPDATEPASSPARAMETERSPROC)(CGpass);
typedef void (*PFNCGUPDATEPROGRAMPARAMETERSPROC)(CGprogram);
typedef CGbool (*PFNCGVALIDATETECHNIQUEPROC)(CGtechnique);

/* Declarations */

extern PFNCGADDSTATEENUMERANTPROC cgAddStateEnumerant;
extern PFNCGCALLSTATERESETCALLBACKPROC cgCallStateResetCallback;
extern PFNCGCALLSTATESETCALLBACKPROC cgCallStateSetCallback;
extern PFNCGCALLSTATEVALIDATECALLBACKPROC cgCallStateValidateCallback;
extern PFNCGCOMBINEPROGRAMSPROC cgCombinePrograms;
extern PFNCGCOMBINEPROGRAMS2PROC cgCombinePrograms2;
extern PFNCGCOMBINEPROGRAMS3PROC cgCombinePrograms3;
extern PFNCGCOMBINEPROGRAMS4PROC cgCombinePrograms4;
extern PFNCGCOMBINEPROGRAMS5PROC cgCombinePrograms5;
extern PFNCGCOMPILEPROGRAMPROC cgCompileProgram;
extern PFNCGCONNECTPARAMETERPROC cgConnectParameter;
extern PFNCGCOPYEFFECTPROC cgCopyEffect;
extern PFNCGCOPYPROGRAMPROC cgCopyProgram;
extern PFNCGCREATEARRAYSAMPLERSTATEPROC cgCreateArraySamplerState;
extern PFNCGCREATEARRAYSTATEPROC cgCreateArrayState;
extern PFNCGCREATEBUFFERPROC cgCreateBuffer;
extern PFNCGCREATECONTEXTPROC cgCreateContext;
extern PFNCGCREATEEFFECTPROC cgCreateEffect;
extern PFNCGCREATEEFFECTANNOTATIONPROC cgCreateEffectAnnotation;
extern PFNCGCREATEEFFECTFROMFILEPROC cgCreateEffectFromFile;
extern PFNCGCREATEEFFECTPARAMETERPROC cgCreateEffectParameter;
extern PFNCGCREATEEFFECTPARAMETERARRAYPROC cgCreateEffectParameterArray;
extern PFNCGCREATEEFFECTPARAMETERMULTIDIMARRAYPROC cgCreateEffectParameterMultiDimArray;
extern PFNCGCREATEOBJPROC cgCreateObj;
extern PFNCGCREATEOBJFROMFILEPROC cgCreateObjFromFile;
extern PFNCGCREATEPARAMETERPROC cgCreateParameter;
extern PFNCGCREATEPARAMETERANNOTATIONPROC cgCreateParameterAnnotation;
extern PFNCGCREATEPARAMETERARRAYPROC cgCreateParameterArray;
extern PFNCGCREATEPARAMETERMULTIDIMARRAYPROC cgCreateParameterMultiDimArray;
extern PFNCGCREATEPASSPROC cgCreatePass;
extern PFNCGCREATEPASSANNOTATIONPROC cgCreatePassAnnotation;
extern PFNCGCREATEPROGRAMPROC cgCreateProgram;
extern PFNCGCREATEPROGRAMANNOTATIONPROC cgCreateProgramAnnotation;
extern PFNCGCREATEPROGRAMFROMEFFECTPROC cgCreateProgramFromEffect;
extern PFNCGCREATEPROGRAMFROMFILEPROC cgCreateProgramFromFile;
extern PFNCGCREATESAMPLERSTATEPROC cgCreateSamplerState;
extern PFNCGCREATESAMPLERSTATEASSIGNMENTPROC cgCreateSamplerStateAssignment;
extern PFNCGCREATESTATEPROC cgCreateState;
extern PFNCGCREATESTATEASSIGNMENTPROC cgCreateStateAssignment;
extern PFNCGCREATESTATEASSIGNMENTINDEXPROC cgCreateStateAssignmentIndex;
extern PFNCGCREATETECHNIQUEPROC cgCreateTechnique;
extern PFNCGCREATETECHNIQUEANNOTATIONPROC cgCreateTechniqueAnnotation;
extern PFNCGDESTROYBUFFERPROC cgDestroyBuffer;
extern PFNCGDESTROYCONTEXTPROC cgDestroyContext;
extern PFNCGDESTROYEFFECTPROC cgDestroyEffect;
extern PFNCGDESTROYOBJPROC cgDestroyObj;
extern PFNCGDESTROYPARAMETERPROC cgDestroyParameter;
extern PFNCGDESTROYPROGRAMPROC cgDestroyProgram;
extern PFNCGDISCONNECTPARAMETERPROC cgDisconnectParameter;
extern PFNCGEVALUATEPROGRAMPROC cgEvaluateProgram;
extern PFNCGGETANNOTATIONNAMEPROC cgGetAnnotationName;
extern PFNCGGETANNOTATIONTYPEPROC cgGetAnnotationType;
extern PFNCGGETARRAYDIMENSIONPROC cgGetArrayDimension;
extern PFNCGGETARRAYPARAMETERPROC cgGetArrayParameter;
extern PFNCGGETARRAYSIZEPROC cgGetArraySize;
extern PFNCGGETARRAYTOTALSIZEPROC cgGetArrayTotalSize;
extern PFNCGGETARRAYTYPEPROC cgGetArrayType;
extern PFNCGGETAUTOCOMPILEPROC cgGetAutoCompile;
extern PFNCGGETBEHAVIORPROC cgGetBehavior;
extern PFNCGGETBEHAVIORSTRINGPROC cgGetBehaviorString;
extern PFNCGGETBOOLANNOTATIONVALUESPROC cgGetBoolAnnotationValues;
extern PFNCGGETBOOLSTATEASSIGNMENTVALUESPROC cgGetBoolStateAssignmentValues;
extern PFNCGGETBOOLEANANNOTATIONVALUESPROC cgGetBooleanAnnotationValues;
extern PFNCGGETBUFFERSIZEPROC cgGetBufferSize;
extern PFNCGGETCOMPILERINCLUDECALLBACKPROC cgGetCompilerIncludeCallback;
extern PFNCGGETCONNECTEDPARAMETERPROC cgGetConnectedParameter;
extern PFNCGGETCONNECTEDSTATEASSIGNMENTPARAMETERPROC cgGetConnectedStateAssignmentParameter;
extern PFNCGGETCONNECTEDTOPARAMETERPROC cgGetConnectedToParameter;
extern PFNCGGETCONTEXTBEHAVIORPROC cgGetContextBehavior;
extern PFNCGGETDEPENDENTANNOTATIONPARAMETERPROC cgGetDependentAnnotationParameter;
extern PFNCGGETDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERPROC cgGetDependentProgramArrayStateAssignmentParameter;
extern PFNCGGETDEPENDENTSTATEASSIGNMENTPARAMETERPROC cgGetDependentStateAssignmentParameter;
extern PFNCGGETDOMAINPROC cgGetDomain;
extern PFNCGGETDOMAINSTRINGPROC cgGetDomainString;
extern PFNCGGETEFFECTCONTEXTPROC cgGetEffectContext;
extern PFNCGGETEFFECTNAMEPROC cgGetEffectName;
extern PFNCGGETEFFECTPARAMETERBUFFERPROC cgGetEffectParameterBuffer;
extern PFNCGGETEFFECTPARAMETERBYSEMANTICPROC cgGetEffectParameterBySemantic;
extern PFNCGGETENUMPROC cgGetEnum;
extern PFNCGGETENUMSTRINGPROC cgGetEnumString;
extern PFNCGGETERRORPROC cgGetError;
extern PFNCGGETERRORCALLBACKPROC cgGetErrorCallback;
extern PFNCGGETERRORHANDLERPROC cgGetErrorHandler;
extern PFNCGGETERRORSTRINGPROC cgGetErrorString;
extern PFNCGGETFIRSTDEPENDENTPARAMETERPROC cgGetFirstDependentParameter;
extern PFNCGGETFIRSTEFFECTPROC cgGetFirstEffect;
extern PFNCGGETFIRSTEFFECTANNOTATIONPROC cgGetFirstEffectAnnotation;
extern PFNCGGETFIRSTEFFECTPARAMETERPROC cgGetFirstEffectParameter;
extern PFNCGGETFIRSTERRORPROC cgGetFirstError;
extern PFNCGGETFIRSTLEAFEFFECTPARAMETERPROC cgGetFirstLeafEffectParameter;
extern PFNCGGETFIRSTLEAFPARAMETERPROC cgGetFirstLeafParameter;
extern PFNCGGETFIRSTPARAMETERPROC cgGetFirstParameter;
extern PFNCGGETFIRSTPARAMETERANNOTATIONPROC cgGetFirstParameterAnnotation;
extern PFNCGGETFIRSTPASSPROC cgGetFirstPass;
extern PFNCGGETFIRSTPASSANNOTATIONPROC cgGetFirstPassAnnotation;
extern PFNCGGETFIRSTPROGRAMPROC cgGetFirstProgram;
extern PFNCGGETFIRSTPROGRAMANNOTATIONPROC cgGetFirstProgramAnnotation;
extern PFNCGGETFIRSTSAMPLERSTATEPROC cgGetFirstSamplerState;
extern PFNCGGETFIRSTSAMPLERSTATEASSIGNMENTPROC cgGetFirstSamplerStateAssignment;
extern PFNCGGETFIRSTSTATEPROC cgGetFirstState;
extern PFNCGGETFIRSTSTATEASSIGNMENTPROC cgGetFirstStateAssignment;
extern PFNCGGETFIRSTSTRUCTPARAMETERPROC cgGetFirstStructParameter;
extern PFNCGGETFIRSTTECHNIQUEPROC cgGetFirstTechnique;
extern PFNCGGETFIRSTTECHNIQUEANNOTATIONPROC cgGetFirstTechniqueAnnotation;
extern PFNCGGETFIRSTUNIFORMBUFFERPARAMETERPROC cgGetFirstUniformBufferParameter;
extern PFNCGGETFLOATANNOTATIONVALUESPROC cgGetFloatAnnotationValues;
extern PFNCGGETFLOATSTATEASSIGNMENTVALUESPROC cgGetFloatStateAssignmentValues;
extern PFNCGGETINTANNOTATIONVALUESPROC cgGetIntAnnotationValues;
extern PFNCGGETINTSTATEASSIGNMENTVALUESPROC cgGetIntStateAssignmentValues;
extern PFNCGGETLASTERRORSTRINGPROC cgGetLastErrorString;
extern PFNCGGETLASTLISTINGPROC cgGetLastListing;
extern PFNCGGETLOCKINGPOLICYPROC cgGetLockingPolicy;
extern PFNCGGETMATRIXPARAMETERORDERPROC cgGetMatrixParameterOrder;
extern PFNCGGETMATRIXPARAMETERDCPROC cgGetMatrixParameterdc;
extern PFNCGGETMATRIXPARAMETERDRPROC cgGetMatrixParameterdr;
extern PFNCGGETMATRIXPARAMETERFCPROC cgGetMatrixParameterfc;
extern PFNCGGETMATRIXPARAMETERFRPROC cgGetMatrixParameterfr;
extern PFNCGGETMATRIXPARAMETERICPROC cgGetMatrixParameteric;
extern PFNCGGETMATRIXPARAMETERIRPROC cgGetMatrixParameterir;
extern PFNCGGETMATRIXSIZEPROC cgGetMatrixSize;
extern PFNCGGETNAMEDEFFECTPROC cgGetNamedEffect;
extern PFNCGGETNAMEDEFFECTANNOTATIONPROC cgGetNamedEffectAnnotation;
extern PFNCGGETNAMEDEFFECTPARAMETERPROC cgGetNamedEffectParameter;
extern PFNCGGETNAMEDEFFECTUNIFORMBUFFERPROC cgGetNamedEffectUniformBuffer;
extern PFNCGGETNAMEDPARAMETERPROC cgGetNamedParameter;
extern PFNCGGETNAMEDPARAMETERANNOTATIONPROC cgGetNamedParameterAnnotation;
extern PFNCGGETNAMEDPASSPROC cgGetNamedPass;
extern PFNCGGETNAMEDPASSANNOTATIONPROC cgGetNamedPassAnnotation;
extern PFNCGGETNAMEDPROGRAMANNOTATIONPROC cgGetNamedProgramAnnotation;
extern PFNCGGETNAMEDPROGRAMPARAMETERPROC cgGetNamedProgramParameter;
extern PFNCGGETNAMEDPROGRAMUNIFORMBUFFERPROC cgGetNamedProgramUniformBuffer;
extern PFNCGGETNAMEDSAMPLERSTATEPROC cgGetNamedSamplerState;
extern PFNCGGETNAMEDSAMPLERSTATEASSIGNMENTPROC cgGetNamedSamplerStateAssignment;
extern PFNCGGETNAMEDSTATEPROC cgGetNamedState;
extern PFNCGGETNAMEDSTATEASSIGNMENTPROC cgGetNamedStateAssignment;
extern PFNCGGETNAMEDSTRUCTPARAMETERPROC cgGetNamedStructParameter;
extern PFNCGGETNAMEDSUBPARAMETERPROC cgGetNamedSubParameter;
extern PFNCGGETNAMEDTECHNIQUEPROC cgGetNamedTechnique;
extern PFNCGGETNAMEDTECHNIQUEANNOTATIONPROC cgGetNamedTechniqueAnnotation;
extern PFNCGGETNAMEDUNIFORMBUFFERPARAMETERPROC cgGetNamedUniformBufferParameter;
extern PFNCGGETNAMEDUSERTYPEPROC cgGetNamedUserType;
extern PFNCGGETNEXTANNOTATIONPROC cgGetNextAnnotation;
extern PFNCGGETNEXTEFFECTPROC cgGetNextEffect;
extern PFNCGGETNEXTLEAFPARAMETERPROC cgGetNextLeafParameter;
extern PFNCGGETNEXTPARAMETERPROC cgGetNextParameter;
extern PFNCGGETNEXTPASSPROC cgGetNextPass;
extern PFNCGGETNEXTPROGRAMPROC cgGetNextProgram;
extern PFNCGGETNEXTSTATEPROC cgGetNextState;
extern PFNCGGETNEXTSTATEASSIGNMENTPROC cgGetNextStateAssignment;
extern PFNCGGETNEXTTECHNIQUEPROC cgGetNextTechnique;
extern PFNCGGETNUMCONNECTEDTOPARAMETERSPROC cgGetNumConnectedToParameters;
extern PFNCGGETNUMDEPENDENTANNOTATIONPARAMETERSPROC cgGetNumDependentAnnotationParameters;
extern PFNCGGETNUMDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERSPROC cgGetNumDependentProgramArrayStateAssignmentParameters;
extern PFNCGGETNUMDEPENDENTSTATEASSIGNMENTPARAMETERSPROC cgGetNumDependentStateAssignmentParameters;
extern PFNCGGETNUMPARENTTYPESPROC cgGetNumParentTypes;
extern PFNCGGETNUMPROGRAMDOMAINSPROC cgGetNumProgramDomains;
extern PFNCGGETNUMSTATEENUMERANTSPROC cgGetNumStateEnumerants;
extern PFNCGGETNUMSUPPORTEDPROFILESPROC cgGetNumSupportedProfiles;
extern PFNCGGETNUMUSERTYPESPROC cgGetNumUserTypes;
extern PFNCGGETPARAMETERBASERESOURCEPROC cgGetParameterBaseResource;
extern PFNCGGETPARAMETERBASETYPEPROC cgGetParameterBaseType;
extern PFNCGGETPARAMETERBUFFERINDEXPROC cgGetParameterBufferIndex;
extern PFNCGGETPARAMETERBUFFEROFFSETPROC cgGetParameterBufferOffset;
extern PFNCGGETPARAMETERCLASSPROC cgGetParameterClass;
extern PFNCGGETPARAMETERCLASSENUMPROC cgGetParameterClassEnum;
extern PFNCGGETPARAMETERCLASSSTRINGPROC cgGetParameterClassString;
extern PFNCGGETPARAMETERCOLUMNSPROC cgGetParameterColumns;
extern PFNCGGETPARAMETERCONTEXTPROC cgGetParameterContext;
extern PFNCGGETPARAMETERDEFAULTVALUEDCPROC cgGetParameterDefaultValuedc;
extern PFNCGGETPARAMETERDEFAULTVALUEDRPROC cgGetParameterDefaultValuedr;
extern PFNCGGETPARAMETERDEFAULTVALUEFCPROC cgGetParameterDefaultValuefc;
extern PFNCGGETPARAMETERDEFAULTVALUEFRPROC cgGetParameterDefaultValuefr;
extern PFNCGGETPARAMETERDEFAULTVALUEICPROC cgGetParameterDefaultValueic;
extern PFNCGGETPARAMETERDEFAULTVALUEIRPROC cgGetParameterDefaultValueir;
extern PFNCGGETPARAMETERDIRECTIONPROC cgGetParameterDirection;
extern PFNCGGETPARAMETEREFFECTPROC cgGetParameterEffect;
extern PFNCGGETPARAMETERINDEXPROC cgGetParameterIndex;
extern PFNCGGETPARAMETERNAMEPROC cgGetParameterName;
extern PFNCGGETPARAMETERNAMEDTYPEPROC cgGetParameterNamedType;
extern PFNCGGETPARAMETERORDINALNUMBERPROC cgGetParameterOrdinalNumber;
extern PFNCGGETPARAMETERPROGRAMPROC cgGetParameterProgram;
extern PFNCGGETPARAMETERRESOURCEPROC cgGetParameterResource;
extern PFNCGGETPARAMETERRESOURCEINDEXPROC cgGetParameterResourceIndex;
extern PFNCGGETPARAMETERRESOURCENAMEPROC cgGetParameterResourceName;
extern PFNCGGETPARAMETERRESOURCESIZEPROC cgGetParameterResourceSize;
extern PFNCGGETPARAMETERRESOURCETYPEPROC cgGetParameterResourceType;
extern PFNCGGETPARAMETERROWSPROC cgGetParameterRows;
extern PFNCGGETPARAMETERSEMANTICPROC cgGetParameterSemantic;
extern PFNCGGETPARAMETERSETTINGMODEPROC cgGetParameterSettingMode;
extern PFNCGGETPARAMETERTYPEPROC cgGetParameterType;
extern PFNCGGETPARAMETERVALUEDCPROC cgGetParameterValuedc;
extern PFNCGGETPARAMETERVALUEDRPROC cgGetParameterValuedr;
extern PFNCGGETPARAMETERVALUEFCPROC cgGetParameterValuefc;
extern PFNCGGETPARAMETERVALUEFRPROC cgGetParameterValuefr;
extern PFNCGGETPARAMETERVALUEICPROC cgGetParameterValueic;
extern PFNCGGETPARAMETERVALUEIRPROC cgGetParameterValueir;
extern PFNCGGETPARAMETERVALUESPROC cgGetParameterValues;
extern PFNCGGETPARAMETERVARIABILITYPROC cgGetParameterVariability;
extern PFNCGGETPARENTTYPEPROC cgGetParentType;
extern PFNCGGETPASSNAMEPROC cgGetPassName;
extern PFNCGGETPASSPROGRAMPROC cgGetPassProgram;
extern PFNCGGETPASSTECHNIQUEPROC cgGetPassTechnique;
extern PFNCGGETPROFILEPROC cgGetProfile;
extern PFNCGGETPROFILEDOMAINPROC cgGetProfileDomain;
extern PFNCGGETPROFILEPROPERTYPROC cgGetProfileProperty;
extern PFNCGGETPROFILESIBLINGPROC cgGetProfileSibling;
extern PFNCGGETPROFILESTRINGPROC cgGetProfileString;
extern PFNCGGETPROGRAMBUFFERPROC cgGetProgramBuffer;
extern PFNCGGETPROGRAMBUFFERMAXINDEXPROC cgGetProgramBufferMaxIndex;
extern PFNCGGETPROGRAMBUFFERMAXSIZEPROC cgGetProgramBufferMaxSize;
extern PFNCGGETPROGRAMCONTEXTPROC cgGetProgramContext;
extern PFNCGGETPROGRAMDOMAINPROC cgGetProgramDomain;
extern PFNCGGETPROGRAMDOMAINPROFILEPROC cgGetProgramDomainProfile;
extern PFNCGGETPROGRAMDOMAINPROGRAMPROC cgGetProgramDomainProgram;
extern PFNCGGETPROGRAMINPUTPROC cgGetProgramInput;
extern PFNCGGETPROGRAMOPTIONSPROC cgGetProgramOptions;
extern PFNCGGETPROGRAMOUTPUTPROC cgGetProgramOutput;
extern PFNCGGETPROGRAMOUTPUTVERTICESPROC cgGetProgramOutputVertices;
extern PFNCGGETPROGRAMPROFILEPROC cgGetProgramProfile;
extern PFNCGGETPROGRAMSTATEASSIGNMENTVALUEPROC cgGetProgramStateAssignmentValue;
extern PFNCGGETPROGRAMSTRINGPROC cgGetProgramString;
extern PFNCGGETRESOURCEPROC cgGetResource;
extern PFNCGGETRESOURCESTRINGPROC cgGetResourceString;
extern PFNCGGETSAMPLERSTATEASSIGNMENTPARAMETERPROC cgGetSamplerStateAssignmentParameter;
extern PFNCGGETSAMPLERSTATEASSIGNMENTSTATEPROC cgGetSamplerStateAssignmentState;
extern PFNCGGETSAMPLERSTATEASSIGNMENTVALUEPROC cgGetSamplerStateAssignmentValue;
extern PFNCGGETSEMANTICCASEPOLICYPROC cgGetSemanticCasePolicy;
extern PFNCGGETSTATEASSIGNMENTINDEXPROC cgGetStateAssignmentIndex;
extern PFNCGGETSTATEASSIGNMENTPASSPROC cgGetStateAssignmentPass;
extern PFNCGGETSTATEASSIGNMENTSTATEPROC cgGetStateAssignmentState;
extern PFNCGGETSTATECONTEXTPROC cgGetStateContext;
extern PFNCGGETSTATEENUMERANTPROC cgGetStateEnumerant;
extern PFNCGGETSTATEENUMERANTNAMEPROC cgGetStateEnumerantName;
extern PFNCGGETSTATEENUMERANTVALUEPROC cgGetStateEnumerantValue;
extern PFNCGGETSTATELATESTPROFILEPROC cgGetStateLatestProfile;
extern PFNCGGETSTATENAMEPROC cgGetStateName;
extern PFNCGGETSTATERESETCALLBACKPROC cgGetStateResetCallback;
extern PFNCGGETSTATESETCALLBACKPROC cgGetStateSetCallback;
extern PFNCGGETSTATETYPEPROC cgGetStateType;
extern PFNCGGETSTATEVALIDATECALLBACKPROC cgGetStateValidateCallback;
extern PFNCGGETSTRINGPROC cgGetString;
extern PFNCGGETSTRINGANNOTATIONVALUEPROC cgGetStringAnnotationValue;
extern PFNCGGETSTRINGANNOTATIONVALUESPROC cgGetStringAnnotationValues;
extern PFNCGGETSTRINGPARAMETERVALUEPROC cgGetStringParameterValue;
extern PFNCGGETSTRINGSTATEASSIGNMENTVALUEPROC cgGetStringStateAssignmentValue;
extern PFNCGGETSUPPORTEDPROFILEPROC cgGetSupportedProfile;
extern PFNCGGETTECHNIQUEEFFECTPROC cgGetTechniqueEffect;
extern PFNCGGETTECHNIQUENAMEPROC cgGetTechniqueName;
extern PFNCGGETTEXTURESTATEASSIGNMENTVALUEPROC cgGetTextureStateAssignmentValue;
extern PFNCGGETTYPEPROC cgGetType;
extern PFNCGGETTYPEBASEPROC cgGetTypeBase;
extern PFNCGGETTYPECLASSPROC cgGetTypeClass;
extern PFNCGGETTYPESIZESPROC cgGetTypeSizes;
extern PFNCGGETTYPESTRINGPROC cgGetTypeString;
extern PFNCGGETUNIFORMBUFFERBLOCKNAMEPROC cgGetUniformBufferBlockName;
extern PFNCGGETUNIFORMBUFFERPARAMETERPROC cgGetUniformBufferParameter;
extern PFNCGGETUSERTYPEPROC cgGetUserType;
extern PFNCGISANNOTATIONPROC cgIsAnnotation;
extern PFNCGISBUFFERPROC cgIsBuffer;
extern PFNCGISCONTEXTPROC cgIsContext;
extern PFNCGISEFFECTPROC cgIsEffect;
extern PFNCGISINTERFACETYPEPROC cgIsInterfaceType;
extern PFNCGISPARAMETERPROC cgIsParameter;
extern PFNCGISPARAMETERGLOBALPROC cgIsParameterGlobal;
extern PFNCGISPARAMETERREFERENCEDPROC cgIsParameterReferenced;
extern PFNCGISPARAMETERUSEDPROC cgIsParameterUsed;
extern PFNCGISPARENTTYPEPROC cgIsParentType;
extern PFNCGISPASSPROC cgIsPass;
extern PFNCGISPROFILESUPPORTEDPROC cgIsProfileSupported;
extern PFNCGISPROGRAMPROC cgIsProgram;
extern PFNCGISPROGRAMCOMPILEDPROC cgIsProgramCompiled;
extern PFNCGISSTATEPROC cgIsState;
extern PFNCGISSTATEASSIGNMENTPROC cgIsStateAssignment;
extern PFNCGISTECHNIQUEPROC cgIsTechnique;
extern PFNCGISTECHNIQUEVALIDATEDPROC cgIsTechniqueValidated;
extern PFNCGMAPBUFFERPROC cgMapBuffer;
extern PFNCGRESETPASSSTATEPROC cgResetPassState;
extern PFNCGSETARRAYSIZEPROC cgSetArraySize;
extern PFNCGSETAUTOCOMPILEPROC cgSetAutoCompile;
extern PFNCGSETBOOLANNOTATIONPROC cgSetBoolAnnotation;
extern PFNCGSETBOOLARRAYSTATEASSIGNMENTPROC cgSetBoolArrayStateAssignment;
extern PFNCGSETBOOLSTATEASSIGNMENTPROC cgSetBoolStateAssignment;
extern PFNCGSETBUFFERDATAPROC cgSetBufferData;
extern PFNCGSETBUFFERSUBDATAPROC cgSetBufferSubData;
extern PFNCGSETCOMPILERINCLUDECALLBACKPROC cgSetCompilerIncludeCallback;
extern PFNCGSETCOMPILERINCLUDEFILEPROC cgSetCompilerIncludeFile;
extern PFNCGSETCOMPILERINCLUDESTRINGPROC cgSetCompilerIncludeString;
extern PFNCGSETCONTEXTBEHAVIORPROC cgSetContextBehavior;
extern PFNCGSETEFFECTNAMEPROC cgSetEffectName;
extern PFNCGSETEFFECTPARAMETERBUFFERPROC cgSetEffectParameterBuffer;
extern PFNCGSETERRORCALLBACKPROC cgSetErrorCallback;
extern PFNCGSETERRORHANDLERPROC cgSetErrorHandler;
extern PFNCGSETFLOATANNOTATIONPROC cgSetFloatAnnotation;
extern PFNCGSETFLOATARRAYSTATEASSIGNMENTPROC cgSetFloatArrayStateAssignment;
extern PFNCGSETFLOATSTATEASSIGNMENTPROC cgSetFloatStateAssignment;
extern PFNCGSETINTANNOTATIONPROC cgSetIntAnnotation;
extern PFNCGSETINTARRAYSTATEASSIGNMENTPROC cgSetIntArrayStateAssignment;
extern PFNCGSETINTSTATEASSIGNMENTPROC cgSetIntStateAssignment;
extern PFNCGSETLASTLISTINGPROC cgSetLastListing;
extern PFNCGSETLOCKINGPOLICYPROC cgSetLockingPolicy;
extern PFNCGSETMATRIXPARAMETERDCPROC cgSetMatrixParameterdc;
extern PFNCGSETMATRIXPARAMETERDRPROC cgSetMatrixParameterdr;
extern PFNCGSETMATRIXPARAMETERFCPROC cgSetMatrixParameterfc;
extern PFNCGSETMATRIXPARAMETERFRPROC cgSetMatrixParameterfr;
extern PFNCGSETMATRIXPARAMETERICPROC cgSetMatrixParameteric;
extern PFNCGSETMATRIXPARAMETERIRPROC cgSetMatrixParameterir;
extern PFNCGSETMULTIDIMARRAYSIZEPROC cgSetMultiDimArraySize;
extern PFNCGSETPARAMETER1DPROC cgSetParameter1d;
extern PFNCGSETPARAMETER1DVPROC cgSetParameter1dv;
extern PFNCGSETPARAMETER1FPROC cgSetParameter1f;
extern PFNCGSETPARAMETER1FVPROC cgSetParameter1fv;
extern PFNCGSETPARAMETER1IPROC cgSetParameter1i;
extern PFNCGSETPARAMETER1IVPROC cgSetParameter1iv;
extern PFNCGSETPARAMETER2DPROC cgSetParameter2d;
extern PFNCGSETPARAMETER2DVPROC cgSetParameter2dv;
extern PFNCGSETPARAMETER2FPROC cgSetParameter2f;
extern PFNCGSETPARAMETER2FVPROC cgSetParameter2fv;
extern PFNCGSETPARAMETER2IPROC cgSetParameter2i;
extern PFNCGSETPARAMETER2IVPROC cgSetParameter2iv;
extern PFNCGSETPARAMETER3DPROC cgSetParameter3d;
extern PFNCGSETPARAMETER3DVPROC cgSetParameter3dv;
extern PFNCGSETPARAMETER3FPROC cgSetParameter3f;
extern PFNCGSETPARAMETER3FVPROC cgSetParameter3fv;
extern PFNCGSETPARAMETER3IPROC cgSetParameter3i;
extern PFNCGSETPARAMETER3IVPROC cgSetParameter3iv;
extern PFNCGSETPARAMETER4DPROC cgSetParameter4d;
extern PFNCGSETPARAMETER4DVPROC cgSetParameter4dv;
extern PFNCGSETPARAMETER4FPROC cgSetParameter4f;
extern PFNCGSETPARAMETER4FVPROC cgSetParameter4fv;
extern PFNCGSETPARAMETER4IPROC cgSetParameter4i;
extern PFNCGSETPARAMETER4IVPROC cgSetParameter4iv;
extern PFNCGSETPARAMETERSEMANTICPROC cgSetParameterSemantic;
extern PFNCGSETPARAMETERSETTINGMODEPROC cgSetParameterSettingMode;
extern PFNCGSETPARAMETERVALUEDCPROC cgSetParameterValuedc;
extern PFNCGSETPARAMETERVALUEDRPROC cgSetParameterValuedr;
extern PFNCGSETPARAMETERVALUEFCPROC cgSetParameterValuefc;
extern PFNCGSETPARAMETERVALUEFRPROC cgSetParameterValuefr;
extern PFNCGSETPARAMETERVALUEICPROC cgSetParameterValueic;
extern PFNCGSETPARAMETERVALUEIRPROC cgSetParameterValueir;
extern PFNCGSETPARAMETERVARIABILITYPROC cgSetParameterVariability;
extern PFNCGSETPASSPROGRAMPARAMETERSPROC cgSetPassProgramParameters;
extern PFNCGSETPASSSTATEPROC cgSetPassState;
extern PFNCGSETPROGRAMBUFFERPROC cgSetProgramBuffer;
extern PFNCGSETPROGRAMOUTPUTVERTICESPROC cgSetProgramOutputVertices;
extern PFNCGSETPROGRAMPROFILEPROC cgSetProgramProfile;
extern PFNCGSETPROGRAMSTATEASSIGNMENTPROC cgSetProgramStateAssignment;
extern PFNCGSETSAMPLERSTATEPROC cgSetSamplerState;
extern PFNCGSETSAMPLERSTATEASSIGNMENTPROC cgSetSamplerStateAssignment;
extern PFNCGSETSEMANTICCASEPOLICYPROC cgSetSemanticCasePolicy;
extern PFNCGSETSTATECALLBACKSPROC cgSetStateCallbacks;
extern PFNCGSETSTATELATESTPROFILEPROC cgSetStateLatestProfile;
extern PFNCGSETSTRINGANNOTATIONPROC cgSetStringAnnotation;
extern PFNCGSETSTRINGPARAMETERVALUEPROC cgSetStringParameterValue;
extern PFNCGSETSTRINGSTATEASSIGNMENTPROC cgSetStringStateAssignment;
extern PFNCGSETTEXTURESTATEASSIGNMENTPROC cgSetTextureStateAssignment;
extern PFNCGSETUNIFORMBUFFERPARAMETERPROC cgSetUniformBufferParameter;
extern PFNCGUNMAPBUFFERPROC cgUnmapBuffer;
extern PFNCGUPDATEPASSPARAMETERSPROC cgUpdatePassParameters;
extern PFNCGUPDATEPROGRAMPARAMETERSPROC cgUpdateProgramParameters;
extern PFNCGVALIDATETECHNIQUEPROC cgValidateTechnique;

#ifdef __cplusplus
}
#endif

#endif
