//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _App_h_
#define _App_h_

#include <X11/Xlib.h>
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>
#include <errno.h>
#include <setjmp.h>
#include <stdlib.h>
#include <iostream.h>
#include "Panel.h"
#include "Version.h"
#include "Config.h"


class App
{
public:
    App(int argc, char** argv);
    ~App();
    void Run();
    int GetServerPID();
    void StopServer();
    
private:
    void Login();
    void Reboot();
    void Halt();
    void Console();
    void Exit();
    void KillAllClients(Bool top);

    // Server functions
    int StartServer(char** server);
    int ServerTimeout(int timeout, char *string);
    int WaitForServer();

    // Private data
    Window Root;
    Display* Dpy;
    int Scr;
    Panel* LoginPanel;
    int ServerPID;

    // Options
    char* DispName;
    int NoAnimations;
};


#endif

