/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public abstract class HttpHeader
implements Serializable {
    private static final long serialVersionUID = 7922279497679304778L;
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    public static final String CONTENT_LENGTH = "content-length";
    public static final String TRANSFER_ENCODING = "transfer-encoding";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String CONTENT_LOCATION = "content-location";
    public static final String CONTENT_TYPE = "content-type";
    public static final String PROXY_CONNECTION = "proxy-connection";
    public static final String PROXY_AUTHENTICATE = "proxy-authenticate";
    public static final String CONNECTION = "connection";
    public static final String AUTHORIZATION = "authorization";
    public static final String WWW_AUTHENTICATE = "www-authenticate";
    public static final String LOCATION = "location";
    public static final String IF_MODIFIED_SINCE = "if-modified-since";
    public static final String IF_NONE_MATCH = "if-none-match";
    public static final String USER_AGENT = "user-agent";
    public static final String ACCEPT_ENCODING = "accept-encoding";
    public static final String CACHE_CONTROL = "cache-control";
    public static final String PRAGMA = "pragma";
    public static final String REFERER = "referer";
    public static final String X_ZAP_REQUESTID = "x-zap-requestid";
    public static final String X_SECURITY_PROXY = "x-security-proxy";
    public static final String COOKIE = "cookie";
    public static final String SET_COOKIE = "set-cookie";
    public static final String SET_COOKIE2 = "set-cookie2";
    public static final String X_XSS_PROTECTION = "x-xss-protection";
    public static final String X_FRAME_OPTION = "x-frame-options";
    public static final String X_CONTENT_TYPE_OPTIONS = "x-content-type-options";
    public static final String HTTP09 = "HTTP/0.9";
    public static final String HTTP10 = "HTTP/1.0";
    public static final String HTTP11 = "HTTP/1.1";
    public static final String HTTP2 = "HTTP/2";
    public static final String _CLOSE = "Close";
    public static final String _KEEP_ALIVE = "Keep-Alive";
    public static final String _CHUNKED = "Chunked";
    public static final String FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String FORM_MULTIPART_CONTENT_TYPE = "multipart/form-data";
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String DEFLATE = "deflate";
    public static final String GZIP = "gzip";
    public static final String IDENTITY = "identity";
    public static final String SEC_PROXY_INTERCEPT = "intercept";
    public static final String SEC_PROXY_RECORD = "record";
    public static final String LINK = "link";
    public static final String REFRESH = "refresh";
    public static final Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    public static final Pattern patternLF = Pattern.compile("\\n", 8);
    private static final Pattern patternCharset = Pattern.compile("charset *= *(?:(?:'([^';\\s]+))|(?:\"?([^\";\\s]+)\"?))", 2);
    protected static final String p_TEXT = "[^\\x00-\\x1f\\r\\n]*";
    protected static final String p_METHOD = "(\\w+)";
    protected static final String p_SP = " +";
    protected static final String p_URI = "([^\\r\\n]+)";
    protected static final String p_VERSION = "(HTTP/\\d+(?:\\.\\d+)?)";
    protected static final String p_STATUS_CODE = "(\\d{3})";
    protected static final String p_REASON_PHRASE = "([^\\x00-\\x1f\\r\\n]*)";
    protected String mStartLine;
    protected String mMsgHeader;
    protected boolean mMalformedHeader;
    protected Hashtable<String, Vector<String>> mHeaderFields;
    protected int mContentLength;
    protected String mLineDelimiter;
    protected String mVersion;
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "access-control-allow-origin";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "access-control-allow-headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "access-control-allow-methods";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "access-control-expose-headers";
    public static final String METHODS_ALLOW = "Allow";
    public static final String METHODS_PUBLIC = "Public";
    public static final String X_ZAP_SCAN_ID = "x-zap-scan-id";
    public static final String X_ZAP_API_KEY = "x-zap-api-key";
    public static final String X_ZAP_API_NONCE = "x-zap-api-nonce";
    public static final String PROXY_AUTHORIZATION = "proxy-authorization";
    public static final String X_CSRF_TOKEN = "x-csrf-token";
    public static final String X_CSRFTOKEN = "x-csrftoken";
    public static final String X_XSRF_TOKEN = "x-xsrf-token";

    public HttpHeader() {
        this.init();
    }

    public HttpHeader(String data) throws HttpMalformedHeaderException {
        this.setMessage(data);
    }

    private void init() {
        this.mHeaderFields = new Hashtable();
        this.mStartLine = "";
        this.mMsgHeader = "";
        this.mMalformedHeader = false;
        this.mContentLength = -1;
        this.mLineDelimiter = CRLF;
        this.mVersion = HTTP10;
    }

    public void setMessage(String data) throws HttpMalformedHeaderException {
        this.clear();
        try {
            if (!this.parse(data)) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception e) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public void clear() {
        this.init();
    }

    public String getHeader(String name) {
        List<String> headers = this.getHeaderValues(name);
        if (headers.isEmpty()) {
            return null;
        }
        return headers.get(0);
    }

    @Deprecated
    public Vector<String> getHeaders(String name) {
        return this.mHeaderFields.get(HttpHeader.normalisedHeaderName(name));
    }

    public List<String> getHeaderValues(String name) {
        List values = this.mHeaderFields.get(HttpHeader.normalisedHeaderName(name));
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    public List<HttpHeaderField> getHeaders() {
        ArrayList<HttpHeaderField> headerFields = new ArrayList<HttpHeaderField>();
        String[] headers = this.mMsgHeader.split(Pattern.quote(this.mLineDelimiter));
        for (int i = 0; i < headers.length; ++i) {
            String[] headerField = headers[i].split(":", 2);
            if (headerField.length != 2) continue;
            headerFields.add(new HttpHeaderField(headerField[0].trim(), headerField[1].trim()));
        }
        return headerFields;
    }

    public void addHeader(String name, String val) {
        this.mMsgHeader = this.mMsgHeader + name + ": " + val + this.mLineDelimiter;
        this.addInternalHeaderFields(name, val);
    }

    public void setHeader(String name, String value) {
        Pattern pattern = null;
        if (this.getHeaderValues(name).isEmpty() && value != null) {
            this.addHeader(name, value);
        } else {
            pattern = this.getHeaderRegex(name);
            Matcher matcher = pattern.matcher(this.mMsgHeader);
            if (value == null) {
                this.mMsgHeader = matcher.replaceAll("");
            } else {
                String newString = name + ": " + value + this.mLineDelimiter;
                this.mMsgHeader = matcher.replaceAll(Matcher.quoteReplacement(newString));
            }
            this.replaceInternalHeaderFields(name, value);
        }
    }

    private Pattern getHeaderRegex(String name) throws PatternSyntaxException {
        return Pattern.compile("^ *\\Q" + name + "\\E *: *[^\\r\\n]*" + this.mLineDelimiter, 10);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public abstract void setVersion(String var1);

    public int getContentLength() {
        return this.mContentLength;
    }

    public void setContentLength(int len) {
        if (this.mContentLength != len) {
            this.setHeader(CONTENT_LENGTH, Integer.toString(len));
            this.mContentLength = len;
        }
    }

    public boolean isConnectionClose() {
        boolean result = true;
        if (this.mMalformedHeader) {
            return true;
        }
        if (this.isHttp10()) {
            result = true;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_KEEP_ALIVE) || this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_KEEP_ALIVE)) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else if (this.isHttp11()) {
            result = false;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
                if (this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isHttp10() {
        return this.mVersion.equalsIgnoreCase(HTTP10);
    }

    public boolean isHttp11() {
        return this.mVersion.equalsIgnoreCase(HTTP11);
    }

    public boolean isTransferEncodingChunked() {
        String transferEncoding = this.getHeader(TRANSFER_ENCODING);
        return transferEncoding != null && transferEncoding.equalsIgnoreCase(_CHUNKED);
    }

    protected boolean parse(String data) throws Exception {
        if (data == null || data.isEmpty()) {
            return true;
        }
        String newData = data.replaceAll("(?<!\r)\n", CRLF);
        this.mLineDelimiter = CRLF;
        String[] split = patternCRLF.split(newData);
        this.mStartLine = split[0];
        String token = null;
        String name = null;
        String value = null;
        int pos = 0;
        StringBuilder sb = new StringBuilder(2048);
        for (int i = 1; i < split.length; ++i) {
            token = split[i];
            if (token.equals("")) continue;
            pos = token.indexOf(":");
            if (pos < 0) {
                this.mMalformedHeader = true;
                return false;
            }
            name = token.substring(0, pos).trim();
            value = token.substring(pos + 1).trim();
            if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
                try {
                    this.mContentLength = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(name + ": " + value + this.mLineDelimiter);
            this.addInternalHeaderFields(name, value);
        }
        this.mMsgHeader = sb.toString();
        return true;
    }

    private void replaceInternalHeaderFields(String name, String value) {
        String key = HttpHeader.normalisedHeaderName(name);
        Vector<String> v = this.getHeaders(key);
        if (v == null) {
            v = new Vector();
            this.mHeaderFields.put(key, v);
        }
        if (value != null) {
            v.clear();
            v.add(value);
        } else {
            this.mHeaderFields.remove(key);
        }
    }

    private void addInternalHeaderFields(String name, String value) {
        String key = HttpHeader.normalisedHeaderName(name);
        Vector<String> v = this.getHeaders(key);
        if (v == null) {
            v = new Vector();
            this.mHeaderFields.put(key, v);
        }
        if (value != null) {
            v.add(value);
        } else {
            this.mHeaderFields.remove(key);
        }
    }

    private static String normalisedHeaderName(String name) {
        return name.toUpperCase(Locale.ROOT);
    }

    public boolean isMalformedHeader() {
        return this.mMalformedHeader;
    }

    public String toString() {
        return this.getPrimeHeader() + this.mLineDelimiter + this.mMsgHeader + this.mLineDelimiter;
    }

    public abstract String getPrimeHeader();

    public boolean isImage() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public boolean hasContentType(String ... contentTypes) {
        if (contentTypes == null || contentTypes.length == 0) {
            return true;
        }
        String normalisedContentType = this.getNormalisedContentTypeValue();
        if (normalisedContentType == null) {
            return false;
        }
        for (String contentType : contentTypes) {
            if (!normalisedContentType.contains(contentType)) continue;
            return true;
        }
        return false;
    }

    public String getNormalisedContentTypeValue() {
        String contentType = this.getHeader(CONTENT_TYPE);
        if (contentType != null) {
            return contentType.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    public String getLineDelimiter() {
        return this.mLineDelimiter;
    }

    public String getHeadersAsString() {
        return this.mMsgHeader;
    }

    public boolean isEmpty() {
        return this.mStartLine == null || this.mStartLine.isEmpty();
    }

    public String getCharset() {
        String contentType = this.getHeader(CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        Matcher matcher = patternCharset.matcher(contentType);
        if (matcher.find()) {
            String charset = matcher.group(2);
            if (charset == null) {
                return matcher.group(1);
            }
            return charset;
        }
        return null;
    }
}

