/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.apache.catalina.webresources.AbstractArchiveResource;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UriUtil;

public class JarWarResource
extends AbstractArchiveResource {
    private static final Log log = LogFactory.getLog(JarWarResource.class);
    private final String archivePath;

    public JarWarResource(AbstractArchiveResourceSet abstractArchiveResourceSet, String string, String string2, JarEntry jarEntry, String string3) {
        super(abstractArchiveResourceSet, string, "jar:war:" + string2 + UriUtil.getWarSeparator() + string3 + "!/", jarEntry, "war:" + string2 + UriUtil.getWarSeparator() + string3);
        this.archivePath = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractArchiveResource.JarInputStreamWrapper getJarInputStreamWrapper() {
        InputStream inputStream;
        JarFile jarFile = null;
        ZipInputStream zipInputStream = null;
        JarEntry jarEntry = null;
        try {
            jarFile = this.getArchiveResourceSet().openJarFile();
            JarEntry jarEntry2 = jarFile.getJarEntry(this.archivePath);
            inputStream = jarFile.getInputStream(jarEntry2);
            zipInputStream = new JarInputStream(inputStream);
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null && !jarEntry.getName().equals(this.getResource().getName())) {
            }
            if (jarEntry == null) {
                AbstractArchiveResource.JarInputStreamWrapper jarInputStreamWrapper = null;
                return jarInputStreamWrapper;
            }
            AbstractArchiveResource.JarInputStreamWrapper jarInputStreamWrapper = new AbstractArchiveResource.JarInputStreamWrapper(jarEntry, zipInputStream);
            return jarInputStreamWrapper;
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jarResource.getInputStreamFail", new Object[]{this.getResource().getName(), this.getBaseUrl()}), (Throwable)iOException);
            }
            jarEntry = null;
            inputStream = null;
            return inputStream;
        }
        finally {
            if (jarEntry == null) {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jarFile != null) {
                    this.getArchiveResourceSet().closeJarFile();
                }
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

