import { CancellationToken } from 'vscode-languageserver';
import { CallHierarchyIncomingCall, CallHierarchyItem, CallHierarchyOutgoingCall, Position } from 'vscode-languageserver-types';
import { Document } from '../../../lib/documents';
import { CallHierarchyProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export declare class CallHierarchyProviderImpl implements CallHierarchyProvider {
    private readonly lsAndTsDocResolver;
    private readonly workspaceUris;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, workspaceUris: string[]);
    prepareCallHierarchy(document: Document, position: Position, cancellationToken?: CancellationToken): Promise<CallHierarchyItem[] | null>;
    private isSourceFileItem;
    private convertCallHierarchyItem;
    private getNameAndDetailForItem;
    getIncomingCalls(previousItem: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyIncomingCall[] | null>;
    getOutgoingCalls(previousItem: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyOutgoingCall[] | null>;
    private prepareFurtherCalls;
    private redirectCallHierarchyItem;
    private toComponentCallHierarchyItem;
    private convertFromRanges;
    private getInComingCallsForComponent;
    private getComponentStartTagFromReference;
    private isComponentStartTag;
    private getOutgoingCallsForComponent;
}
